<?php
/* 	
 * ecDownloads 3.3 by Ronin of EliteCoders.org
 *
 *	Human License (non-binding, for the actual license please view licence.txt)
 *	Attribution-NonCommercial-ShareAlike 2.5
 *	You are free:
 *	   * to copy, distribute, display, and perform the work
 * 	   * to make derivative works
 *
 *	Under the following conditions:
 *		by: Attribution. You must attribute the work in the manner specified by the author or licensor.
 *		nc: Noncommercial. You may not use this work for commercial purposes.
 *		sa: Share Alike. If you alter, transform, or build upon this work, you may distribute the resulting work only under a license identical to this one.
 *
 *		* For any reuse or distribution, you must make clear to others the license terms of this work.
 *		* Any of these conditions can be waived if you get permission from the copyright holder.
 */
 
class vB_Downloads
{
	var $perpage, $disabled, $reason, $url, $order, $ext, $ixt, $stats;
	
	function vB_Downloads()
	{
		global $vbulletin, $db;
			
		$this->perpage = $vbulletin->options['ecperpage'];
		$this->disabled = $vbulletin->options['ecdisabled'];
		$this->reason = $vbulletin->options['ecreason'];
		$this->url = $vbulletin->options['ecurl'];
		if ($vbulletin->options['ecorder'])
		{
			$this->order = "`weight`";
		}
		else
		{
			$this->order = "`name`";
		}
		$this->ext = $vbulletin->options['ecext'];
		$this->ixt = $vbulletin->options['ecixt'];
		
		$this->stats = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "dl_main");
	}
	
	function update_counters()
	{
		$this->update_latest_files();
		$this->update_popular_files();
		$this->update_top_contributors();
	}
	
	function update_counters_all()
	{
			global $db;
			// clear current category numbers
			$db->query_write("UPDATE " . TABLE_PREFIX . "dl_cats set files = 0");
			
			// get file loaded information
			$result = $db->query_read("SELECT `uploaderid`,`category` FROM " . TABLE_PREFIX . "dl_files");
				while ($contrib = $db->fetch_array($result))
				{
					$catid = $contrib['category'];
					$uploaderid = $contrib['uploaderid'];
					
					$this->modify_filecount($catid, 1);
					
				$cat = $db->query_first("SELECT count(id) AS filecount FROM " . TABLE_PREFIX . "dl_files WHERE `uploaderid` = ".$uploaderid);
				$db->query("UPDATE " . TABLE_PREFIX . "user SET `uploads`=".$cat['filecount']." WHERE `userid`= ".$uploaderid);
				$db->free_result($cat);
				
				}
				
			$db->free_result($result);
			// Update the contributors
			$this->update_top_contributors();
			
			// update total files count
			$temp = $db->query_first("SELECT COUNT(`id`) AS `files` FROM " . TABLE_PREFIX . "dl_files");
			$db->query_write("UPDATE " . TABLE_PREFIX . "dl_main SET `files`=".$db->sql_prepare($temp['files']));
			
			// update total categories count
			$temp = $db->query_first("SELECT COUNT(`id`) AS `cats` FROM " . TABLE_PREFIX . "dl_cats");
			$db->query_write("UPDATE " . TABLE_PREFIX . "dl_main SET `categories`=".$db->sql_prepare($temp['cats']));
			
			$db->free_result($temp);
	}
	
	function update_latest_files() 
	{
		global $db;
		$result = $db->query_read("SELECT `id`,`name`,`date` FROM " . TABLE_PREFIX . "dl_files WHERE `purgatory`='0' ORDER BY `date` DESC LIMIT 4");
		while ($latest = $db->fetch_array($result)) 
		{
			$temp['name'][] = addslashes($latest['name']);
			$temp['id'][] = $latest['id'];
			$temp['value'][] = $latest['time'];
		}
		$db->free_result($result);
		for($i = 0; $i < 4; $i++) 
		{
			$query .= "`latest[".($i+1)."]` = '".$temp['name'][$i]."', `latestid[".($i+1)."]` = '".$temp['id'][$i]."', `latestval[".($i+1)."]` = '".$temp['value'][$i]."', ";
		}
		$query = substr($query,0,-2);
		$db->query_write("UPDATE " . TABLE_PREFIX . "dl_main SET ".$query);
	}

	function update_popular_files() 
	{
		global $db;
		$result = $db->query_read("SELECT `id`,`name`,`downloads` FROM " . TABLE_PREFIX . "dl_files WHERE `purgatory`='0' ORDER BY `downloads` DESC LIMIT 4");
		while ($popular = $db->fetch_array($result)) 
		{
			$temp['name'][] = addslashes($popular['name']);
			$temp['id'][] = $popular['id'];
			$temp['value'][] = $popular['downloads'];
		}
		$db->free_result($result);
		for($i = 0; $i < 4; $i++) 
		{
			$query .= "`popular[".($i+1)."]` = '".$temp['name'][$i]."', `popularid[".($i+1)."]` = '".$temp['id'][$i]."', `popularval[".($i+1)."]` = '".$temp['value'][$i]."', ";
		}
		$query = substr($query,0,-2);
		$db->query_write("UPDATE " . TABLE_PREFIX . "dl_main SET ".$query);
	}
	
	function update_top_contributors() 
	{
		global $db;
		$result = $db->query_read("SELECT `userid`,`username`,`uploads` FROM " . TABLE_PREFIX . "user ORDER BY `uploads` DESC");
		while ($contrib = $db->fetch_array($result))
		{
			$temp['id'][] = $contrib['userid'];
			$temp['name'][] = addslashes($contrib['username']);
			$temp['value'][] = $contrib['uploads'];
		}
		$db->free_result($result);
		for($i = 0; $i < 4; $i++) 
		{
			$query .= "`contrib[".($i+1)."]` = '".$temp['name'][$i]."', `contribid[".($i+1)."]` = '".$temp['id'][$i]."', `contribval[".($i+1)."]` = '".$temp['value'][$i]."', ";
		}
		$query = substr($query,0,-2);
		$db->query_write("UPDATE " . TABLE_PREFIX . "dl_main SET ".$query);
	}

	function file_prepare($text) {
		$patterns = array("~","`","!","@","#","$","%","^","&amp;","*","(",")","{","}","|","\"",":",";","'","<",",",">","?","/");
		return strtolower(str_replace($patterns, '', $text));
	}
		
	function build_cat_nav($id)
	{
		if ($id > 0)
		{
			global $db;
			$cat = $db->query_first("SELECT `name`,`id`,`parent` FROM " . TABLE_PREFIX . "dl_cats WHERE `id`=".$db->sql_prepare($id));
			return $this->build_cat_nav($cat['parent']) + array('downloads.php?do=cat&amp;id='.$cat['id'] => $cat['name']);
		}
		else
			return array();
	}
	
	function grab_subcats_by_name_client($id)
	{
		$subcats = $this->grab_subcats_by_name($id);
		if ($subcats != '')
		{
			$subcats = '<br><i>Sub Categories: '.substr($subcats, 0, -2).'</i>';
		}
		return $subcats;
	}
	
	function grab_subcats_by_name($id)
	{
		global $db;
		$result = $db->query_read("SELECT `name`,`id` FROM " . TABLE_PREFIX . "dl_cats WHERE `parent`=".$db->sql_prepare($id)." ORDER BY ".$this->order);
		while($subs = $db->fetch_array($result))
		{
			$subcats .= '<a href="downloads.php?do=cat&amp;id='.$subs['id'].'">'.$subs['name'].'</a>, '.$this->grab_subcats_by_name($subs['id']);
		}
		return $subcats;
	}
	
	function validate_move($start, $destination)
	{
		global $db;
		$cat = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "dl_cats WHERE `id`=".$db->sql_prepare($destination));
		if ($cat['parent'] == 0 || $cat['parent'] == '')
		{
			return true;
		}
		elseif ($cat['parent'] == $start)
		{
			return false;
		}
		else
		{
			return $this->validate_move($start, $cat['parent']);
		}
	}
	
	function like($data)
	{
		global $db;
		return $db->sql_prepare('%'.$db->escape_string_like($data).'%');
	}
	
	function construct_select_array($id = 0, $categories = array(), $spacer = '', $short = false)
	{
		global $db;	
		$result = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "dl_cats WHERE `parent` = ".$db->sql_prepare($id)." ORDER BY ".$this->order);
		while($category = $db->fetch_array($result)) {
			if (!$short)
				$categories += array($category['id'] => $spacer.$category['name']);
			else
				$categories += array($category['id'] => $spacer.$category['abbr']);
			if ($category['subs'] > 0)
			{
				$categories += $this->construct_select_array($category['id'], $categories, $spacer."-");
			}
		}
		$db->free_result($result);
		return $categories;
	}
	
	function unset_subcats($id)
	{
		global $db, $categories;
		$result = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "dl_cats WHERE `parent`=".$db->sql_prepare($id));
		if ($db->num_rows($result) > 0)
		{
			while ($cat = $db->fetch_array($result))
			{
				$this->unset_subcats($cat['id']);
			}
		}
		$db->free_result($result);
		unset($categories[$id]);
	}
	
	function modify_filecount_delete($id, $n = -1)
	{
		global $db;
		$cat = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "dl_cats WHERE `id` = ".$db->sql_prepare($id));
		if ($cat['parent'] > 0)
		{
			$this->modify_filecount_delete($cat['parent'], -1);
		}
		$db->query("UPDATE " . TABLE_PREFIX . "dl_cats SET `files`=`files`+".$n." WHERE `id`= ".$db->sql_prepare($id));
	}
	
	function modify_filecount($id, $n = 1)
	{
		global $db;
		$cat = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "dl_cats WHERE `id` = ".$db->sql_prepare($id));
		if ($cat['parent'] > 0)
		{
			$this->modify_filecount($cat['parent']);
		}
		$db->query_write("UPDATE " . TABLE_PREFIX . "dl_cats SET `files`=`files`+".$n." WHERE `id`= ".$db->sql_prepare($id));
	}
	
	function modify_filecount_user($id)
	{
		global $db;
		$cat = $db->query_first("SELECT count(id) AS filecount FROM " . TABLE_PREFIX . "dl_files WHERE `uploaderid` = ".$db->sql_prepare($id));
		$db->query("UPDATE " . TABLE_PREFIX . "user SET `uploads`=".$cat['filecount']." WHERE `userid`= ".$db->sql_prepare($id));
		$db->free_result($cat);
	}
	
	function modify_subcount($id, $n = 1)
	{
		global $db;
		$cat = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "dl_cats WHERE `id` = ".$db->sql_prepare($id));
		if ($cat['parent'] > 0)
		{
			$this->modify_subcount($cat['parent']);
		}
		$db->query_write("UPDATE " . TABLE_PREFIX . "dl_cats SET `subs`=`subs`+".$n." WHERE `id`= ".$db->sql_prepare($id));
	}
}
?>