<?php
/* 	
 * ecDownloads 3.3 by Ronin of EliteCoders.org
 *
 *	Human License (non-binding, for the actual license please view licence.txt)
 *	Attribution-NonCommercial-ShareAlike 2.5
 *	You are free:
 *	   * to copy, distribute, display, and perform the work
 * 	   * to make derivative works
 *
 *	Under the following conditions:
 *		by: Attribution. You must attribute the work in the manner specified by the author or licensor.
 *		nc: Noncommercial. You may not use this work for commercial purposes.
 *		sa: Share Alike. If you alter, transform, or build upon this work, you may distribute the resulting work only under a license identical to this one.
 *
 *		* For any reuse or distribution, you must make clear to others the license terms of this work.
 *		* Any of these conditions can be waived if you get permission from the copyright holder.
 */
 
// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

define('NO_REGISTER_GLOBALS', 1);
define('THIS_SCRIPT', 'downloads');

// ################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array('ecdownloads');
$specialtemplates = array();
$globaltemplates = array(
						'DOWNLOADS',
						'downloads_cat',
						'downloads_cat_filebit',
						'downloads_cat_files',
						'downloads_cat_subbit',
						'downloads_cat_subs',
						'downloads_file',
						'downloads_file_addit',
						'downloads_main',
						'downloads_main_catbit',
						'downloads_man',
						'downloads_man_bit',
						'downloads_my',
						'downloads_my_bit',
						'downloads_panel_bit',
						'downloads_panel_side',
						'downloads_panel_top',
						'downloads_search',
						'downloads_search_result',
						'downloads_search_result_bit',
						'downloads_stats',
						'downloads_stats_bit',
						'downloads_wrapper_side',
						'downloads_wrapper_top'
					);
$actiontemplates = array();

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');
require_once('./includes/class_downloads.php');
require_once('./includes/class_bbcode.php');
$parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());
$dl = new vB_Downloads();
$navbits = array();
$navbits['downloads.php?'] = $vbphrase['ecdownloads_downloads'];
$forceredirect = false;
$vbulletin->url = './downloads.php?do=null';

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################
if ($dl->disabled) {
	if (($permissions['ecdownloadpermissions'] && $vbulletin->bf_ugp['ecdownloadpermissions']['canviewdisabled'])) {
		echo '<center>'.$vbphrase['ecdownloads_disabled'].': '.$dl->reason.'</center>';
	}
	else {
		die('<center>'.$vbphrase['ecdownloads_disabled'].': '.$dl->reason.'</center>');
	}
}

$dlinks = '<a href="./downloads.php?">'.$vbphrase['ecdownloads_main'].'</a> | <a href="./downloads.php?do=stats">'.$vbphrase['ecdownloads_stats'].'</a> | <a href="./downloads.php?do=search">'.$vbphrase['ecdownloads_search'].'</a>';

if (($permissions['ecdownloadpermissions'] && $vbulletin->bf_ugp['ecdownloadpermissions']['canuploadfiles']) || ($permissions['ecdownloadpermissions'] & $vbulletin->bf_ugp['ecdownloadpermissions']['canlinktofiles'])) 
{
	if ($_GET['do'] == 'cat') $catid = $_GET['id'];
	else $catid = '';
	
	$dlinks .=  ' | <a href="./downloads.php?do=add&cat='.$catid.'">'.$vbphrase['ecdownloads_add'].'</a> | <a href="./downloads.php?do=my">'.$vbphrase['ecdownloads_my_files'].'</a>';
}
if (($permissions['ecdownloadpermissions'] & $vbulletin->bf_ugp['ecdownloadpermissions']['canmanagepurgatory']) || ($permissions['ecdownloadpermissions'] & $vbulletin->bf_ugp['ecdownloadpermissions']['caneditallfiles']))
{
	$dlinks .= ' | <a href="./downloads.php?do=manfiles">'.$vbphrase['ecdownloads_manage_files'].'</a>';
}

for($i = 1; $i <= 4; $i++) {
	$name = $dl->stats['latest['.$i.']'];
	$id = $dl->stats['latestid['.$i.']'];
	//$value = vbdate($vboptions['dateformat'],$main['latestval['.$i.']'],true);
	$url = "downloads.php?do=file&id=$id";
	if ($id > 0)
	eval('$dpanel_latest_bits .= "' . fetch_template('downloads_panel_bit') . '";');
}
for($i = 1; $i <= 4; $i++) {
	$name = $dl->stats['popular['.$i.']'];
	$id = $dl->stats['popularid['.$i.']'];
	$value = vb_number_format($dl->stats['popularval['.$i.']']);
	$url = "downloads.php?do=file&id=$id";
	if ($id > 0)
	eval('$dpanel_popular_bits .= "' . fetch_template('downloads_panel_bit') . '";');
}
for($i = 1; $i <= 4; $i++) {
	$name = $dl->stats['contrib['.$i.']'];
	$id = $dl->stats['contribid['.$i.']'];
	$value = vb_number_format($dl->stats['contribval['.$i.']']);
	$url = "member.php?u=$id";
	if ($id > 0)
	eval('$dpanel_contrib_bits .= "' . fetch_template('downloads_panel_bit') . '";');
}
	
if ($_GET['do'] == 'cat')
{
	$cat = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "dl_cats WHERE `id`=".$db->sql_prepare($_GET['id']));
	if($cat['id'] == 0)
		eval(print_standard_redirect('ecdownloads_msg_invalid_cat'));
	
	$navbits += $dl->build_cat_nav($_GET['id']);

	$result = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "dl_cats WHERE `parent` = ".$db->sql_prepare($_GET['id'])." ORDER BY ".$dl->order);
	if ($db->num_rows($result) > 0) {
		while ($sub = $db->fetch_array($result)) {
			$subcats = $dl->grab_subcats_by_name_client($sub['id']);
			$files = vb_number_format($sub['files']);
			exec_switch_bg();
			eval('$dsubbits .= "' . fetch_template('downloads_cat_subbit') . '";');
		}				
		eval('$dsubcats .= "' . fetch_template('downloads_cat_subs') . '";');
	}	
	$db->free_result($result);
	
	$temp = $db->query_first("SELECT count(id) as files FROM " . TABLE_PREFIX . "dl_files WHERE `category` = ".$db->sql_prepare($_GET['id']));
	if ($_GET['sort'] == '')
		$_GET['sort'] = 'date';
	if ($_GET['page'] == '')
		$_GET['page'] = 1;
	$limit = (($_GET['page'] -1)*$dl->perpage);
	$navigation = construct_page_nav($_GET['page'] , $dl->perpage, $temp['files'], "downloads.php?do=cat&id=".$_GET['id']."&sort=".$_GET['sort']);
			
	$result = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "dl_files WHERE `purgatory` = '0' AND `category` = ".$db->sql_prepare($_GET['id'])." ORDER BY `pin` DESC, `".$_GET['sort']."` DESC LIMIT ".$db->sql_prepare($limit).",".$dl->perpage);
	if ($db->num_rows($result) > 0) {
		while ($file = $db->fetch_array($result)) {
			$date = vbdate($vbulletin->options['dateformat'],$file['date'],true);		
			$downloads = vb_number_format($file['downloads']);
			exec_switch_bg();
			eval('$dfilebits .= "' . fetch_template('downloads_cat_filebit') . '";');	
		}
		eval('$dfiles .= "' . fetch_template('downloads_cat_files') . '";');
	}
	$db->free_result($result);
	
	$category_array = $dl->construct_select_array(0,array('#' => $vbphrase['ecdownloads_category_jump']),'',false);
	foreach($category_array as $cat_key => $cat_value)
	{
		$category_jump .= '<option value="./downloads.php?do=cat&id='.$cat_key.'">'.$cat_value.'</option>';
	}
	
	eval('$dmain_jr = "' . fetch_template('downloads_cat') . '";');
	eval('$dpanel = "' . fetch_template('downloads_panel_side') . '";');
	eval('$dmain = "' . fetch_template('downloads_wrapper_side') . '";');
}
elseif ($_GET['do'] == 'file')
{
	if (!($permissions['ecdownloadpermissions'] & $vbulletin->bf_ugp['ecdownloadpermissions']['canviewfiles']))
		print_no_permission();
		
	$file = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "dl_files WHERE `id`=".$db->sql_prepare($_GET['id']));
	if($file['id'] == 0)
		eval(print_standard_redirect('ecdownloads_msg_invalid_file'));
	
	$vbulletin->url = './downloads.php?do=file&id='.$file['id'];
	
	$navbits += $dl->build_cat_nav($file['category']);
	$navbits['downloads.php?do=file&id='.$file['id']] = $file['name'];
	
	if (($permissions['ecdownloadpermissions'] & $vbulletin->bf_ugp['ecdownloadpermissions']['caneditallfiles']) ||
	   (($permissions['ecdownloadpermissions'] & $vbulletin->bf_ugp['ecdownloadpermissions']['caneditownfiles']) &&
	   ($file['uploaderid'] == $vbulletin->userinfo['userid'])))
			$showedit = true;
	
	if ($permissions['ecdownloadpermissions'] & $vbulletin->bf_ugp['ecdownloadpermissions']['canmanagepurgatory'])
			$showapprove = true;
			
	if ($permissions['ecdownloadpermissions'] & $vbulletin->bf_ugp['ecdownloadpermissions']['canuploadimages'])
			$showimages = true;
	
	if (($_GET['rating'] > 0) && ($vbulletin->userinfo['userid'] > 0)) 
	{
		$result = $db->query_read("SELECT COUNT(`id`) FROM " . TABLE_PREFIX . "dl_votes WHERE `user`=".$db->sql_prepare($vbulletin->userinfo['userid'])." AND `file`=".$db->sql_prepare($file['id']));
		if ($db->num_rows($result) != 0) 
		{
			$result = $db->query_write("INSERT INTO " . TABLE_PREFIX . "dl_votes (user, file, value) VALUES(".$db->sql_prepare($vbulletin->userinfo['userid']).",".$db->sql_prepare($file['id']).",".$db->sql_prepare($_GET['rating']).")");
			if ($result) 
			{
				$voteinfo = $db->query_first("SELECT COUNT(`id`) AS votes, SUM(`value`) AS total FROM " . TABLE_PREFIX . "dl_votes WHERE `file`=".$db->sql_prepare($file['id']));
				$db->query_write("UPDATE " . TABLE_PREFIX . "dl_files SET `rating`=".$db->sql_prepare($voteinfo['total']/$voteinfo['votes'])." WHERE `id`=".$db->sql_prepare($file['id']));
				eval(print_standard_redirect('ecdownloads_msg_vote_success'));
			} 
			else 
			{
				eval(print_standard_redirect('ecdownloads_msg_failure'));
			}
		} 
		else 
		{
			eval(print_standard_redirect('ecdownloads_msg_already_voted'));
		}
		$db->free_result($result);
	}
	
	if ($_GET['act'] == 'down') 
	{
		if (!($permissions['ecdownloadpermissions'] & $vbulletin->bf_ugp['ecdownloadpermissions']['candownloadfiles']) ||
		   (($file['purgatory'] == 1) && !($permissions['ecdownloadpermissions'] & $vbulletin->bf_ugp['ecdownloadpermissions']['canmanagepurgatory']))) 
		{
			print_no_permission();
		}
		else 
		{
			$db->query_write("INSERT INTO " . TABLE_PREFIX . "dl_downloads (userid, fileid, user, file) 
							VALUES(".$db->sql_prepare($vbulletin->userinfo['userid']).",".$db->sql_prepare($file['id']).",".$db->sql_prepare($vbulletin->userinfo['username']).",".$db->sql_prepare($file['name']).")");	
			$db->query_write("UPDATE " . TABLE_PREFIX . "user SET `downloads`=`downloads`+1 WHERE `userid`=".$db->sql_prepare($vbulletin->userinfo['userid']));
			$db->query_write("UPDATE " . TABLE_PREFIX . "dl_files SET `downloads`=`downloads`+1, `last`=".TIMENOW." WHERE `id`=".$db->sql_prepare($file['id']));
			$db->query_write("UPDATE " . TABLE_PREFIX . "dl_main SET `downloads`=`downloads`+1");
			$dl->update_popular_files();			
			$db->query_write("UPDATE " . TABLE_PREFIX . "dl_stats SET `downloads`=`downloads`+1, `bandwidth`=`bandwidth`+".$db->sql_prepare($file['size'])." WHERE `day`=".$db->sql_prepare((int) (TIMENOW/86400)));
			if ($db->affected_rows() == 0)
				$db->query_write("INSERT INTO " . TABLE_PREFIX . "dl_stats (day, downloads, bandwidth) VALUES (".$db->sql_prepare((int) (TIMENOW/86400)).",1,".$db->sql_prepare($file['size']).")");
			
			if ($file['link'] == 0)
			{
				$dlfilename = preg_replace('/([0-9]*-)/','dlver-',$dl->url.$file['url'],1);
				@copy($dl->url.$file['url'],$dlfilename);
				header("Location: ".$dlfilename);
			} else  {
				header("Location: ".$file['url']);
			}
		}
	}
	
	if (($_FILES['image']['name'] != '') && ($permissions['ecdownloadpermissions'] & $vbulletin->bf_ugp['ecdownloadpermissions']['canuploadimages']))
	{
		for ($i = 1; $i <= 3; $i++)
		{
			switch(rand(1,3))
			{
				case 1: $random.=chr(mt_rand(48,57)); break;  // 0-9
				case 2: $random.=chr(mt_rand(65,90)); break;  // A-Z
				case 3: $random.=chr(mt_rand(97,122)); break; // a-z
			}
		}
		$dot = strrpos($_FILES['image']['name'], '.');
		$name = strtolower(substr($_FILES['image']['name'],0,$dot));
		$ext = $ext = strtolower(substr($_FILES['image']['name'],$dot+1));
		if (strpos($dl->ixt,$ext) === false)
		{
			$forceredirect = true;
			eval(print_standard_redirect('ecdownloads_msg_ext_invalid'));
		}
		else
		{
			$forceredirect = true;
			$newfilename = $name.'_'.$random.'.'.$ext;
			move_uploaded_file($_FILES['image']['tmp_name'], $dl->url.$newfilename);
			$thumb = $name.'_'.$random.'_thumb.'.$ext;
			if (($ext == 'jpg') || ($ext == 'jpeg'))		
			{
				$destimg = @imagecreate(100,100);
				$srcimg = @imagecreatefromjpeg($dl->url.$newfilename);
				@imagecopyresized($destimg,$srcimg,0,0,0,0,100,100,imagesx($srcimg),imagesy($srcimg));
				@imagejpeg($destimg,$dl->url.$thumb);
			} 
			elseif ($ext == 'png')
			{
				$destimg = @imagecreate(100,100);
				$srcimg = @imagecreatefrompng($dl->url.$newfilename);
				@imagecopyresized($destimg,$srcimg,0,0,0,0,100,100,imagesx($srcimg),imagesy($srcimg));
				@imagepng($destimg,$dl->url.$thumb);
			}
			elseif ($ext == 'gif')
			{
				$destimg = @imagecreate(100,100);
				$srcimg = @imagecreatefromgif($dl->url.$newfilename);
				@imagecopyresized($destimg,$srcimg,0,0,0,0,100,100,imagesx($srcimg),imagesy($srcimg));
				@imagegif($destimg,$dl->url.$thumb);
			}
			elseif ($ext == 'bmp')
			{
				$destimg = @imagecreate(100,100);
				$srcimg = @imagecreatefromwbmp($dl->url.$newfilename);
				@imagecopyresized($destimg,$srcimg,0,0,0,0,100,100,imagesx($srcimg),imagesy($srcimg));
				@imagewbmp($destimg,$dl->url.$thumb);
			}
			
			$db->query_write("INSERT INTO " . TABLE_PREFIX . "dl_images (`file`,`name`,`thumb`,`uploader`,`uploaderid`,`date`) VALUES(".$db->sql_prepare($file['id']).",".$db->sql_prepare($newfilename).",".$db->sql_prepare($thumb).",".$db->sql_prepare($vbulletin->userinfo['username']).",".$db->sql_prepare($vbulletin->userinfo['userid']).",".$db->sql_prepare(TIMENOW).")");	
			eval(print_standard_redirect('ecdownloads_msg_image_added'));
		}
	}
	
	
	if ($_GET['act'] == 'delimg')
	{
		$image = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "dl_images WHERE `id`=".$db->sql_prepare($_GET['img']));
		if (($permissions['ecdownloadpermissions'] & $vbulletin->bf_ugp['ecdownloadpermissions']['caneditallfiles']) ||
		   (($permissions['ecdownloadpermissions'] & $vbulletin->bf_ugp['ecdownloadpermissions']['caneditownfiles']) &&
			 (($image['uploaderid'] == $vbulletin->userinfo['userid']) && ($file['uploaderid'] == $vbulletin->userinfo['userid']))))
		{
			$db->query_write("DELETE FROM " . TABLE_PREFIX . "dl_images WHERE `id`=".$db->sql_prepare($image['id']));
			@unlink($dl->url.$image['name']);
			@unlink($dl->url.$image['thumb']);
			eval(print_standard_redirect('ecdownloads_msg_image_deleted'));
		}
	}
	
	$date = vbdate($vbulletin->options['dateformat'],$file['date'],true);	
	if ($file['rating'] <= 0)	$grade = $vbphrase['ecdownloads_not_rated'];
		elseif ($file['rating'] > 9.6) $grade = "A+"; elseif ($file['rating'] > 9.3) $grade = "A"; elseif ($file['rating'] > 8.9) $grade = "A-";
		elseif ($file['rating'] > 8.6) $grade = "B+"; elseif ($file['rating'] > 8.3) $grade = "B"; elseif ($file['rating'] > 7.9) $grade = "B-";
		elseif ($file['rating'] > 7.6) $grade = "C+"; elseif ($file['rating'] > 7.3) $grade = "C"; elseif ($file['rating'] > 6.9) $grade = "C-";
		elseif ($file['rating'] > 6.6) $grade = "D+"; elseif ($file['rating'] > 6.3) $grade = "D"; elseif ($file['rating'] > 5.9) $grade = "D-";
		else $grade = "F";
		
	$temp = $db->query_first("SELECT `value` FROM " . TABLE_PREFIX . "dl_votes WHERE `file`=".$db->sql_prepare($file['id'])." AND `user`=".$db->sql_prepare($vbulletin->userinfo['userid']));
	$urating = $temp['value'];
	if ($urating > 0) {
		if ($urating > 9.6) $ugrade = "A+"; elseif ($urating > 9.3) $ugrade = "A"; elseif ($urating > 8.9) $ugrade = "A-";
			elseif ($urating > 8.6) $ugrade = "B+"; elseif ($urating > 8.3) $ugrade = "B"; elseif ($urating > 7.9) $ugrade = "B-";
			elseif ($urating > 7.6) $ugrade = "C+"; elseif ($urating > 7.3) $ugrade = "C"; elseif ($urating > 6.9) $ugrade = "C-"; 
			elseif ($urating > 6.6) $ugrade = "D+"; elseif ($urating > 6.3) $ugrade = "D"; elseif ($urating > 5.9) $ugrade = "D-";
			else $ugrade = "F";
		$userscore = $vbphrase['ecdownloads_your_grade'].': '.$ugrade;
	} 
	else 
	{
		if ($permissions['ecdownloadpermissions'] & $vbulletin->bf_ugp['ecdownloadpermissions']['canratefiles']) 
		{
			$gradeArray = array(
									"10" => "A+", "9.5" => "A", "9.3" => "A-",
									"8.7" => "B+", "8.5" => "B", "8.3" => "B-",
									"7.7" => "C+", "7.5" => "C", "7.3" => "C-",
									"6.7" => "D+", "6.5" => "D", "6.3" => "D-",
									"5.0" => "F"
								);
								
			foreach($gradeArray as $key => $value) 
			{
				$optionString .= '<option value="./downloads.php?do=file&id='.$file['id'].'&rating='.$key.'">'.$value.'</option>';
			}	
			$userscore = '<form name="form" enctype="multipart/form-data" action="./downloads.php?" method="post">
							<select name="grade" onChange="MM_jumpMenu(\'parent\',this,1)">
								<option value="">'.$vbphrase['ecdownloads_rate_file'].'</option>
								'.$optionString.'
							</select>
						  </form>';
		}
		else {
			$userscore = $vbdownloads['ecdownloads_cant_rate'];
		}
	}
	
	if ($file['size'] == 0)
		$size = $vbphrase['ecdownloads_unknown_size'];
	else
		$size = vb_number_format($file['size'], 0, true);
		
	$downloads = vb_number_format($file['downloads']);
		
	if (($file['purgatory'] == 0) || ($permissions['ecdownloadpermissions'] & $vbulletin->bf_ugp['ecdownloadpermissions']['canmanagepurgatory']))
	{
		if ($permissions['ecdownloadpermissions'] & $vbulletin->bf_ugp['ecdownloadpermissions']['candownloadfiles'])
		{
			if ($file['link'] == 1)
				$target = 'target="_blank"';
			else
				$target = 'target="_self"';
			
			$download = '<a href="./downloads.php?do=file&id='.$file['id'].'&act=down" '.$target.'><img src="'.$stylevar[imgdir_button].'/ip.gif" width="18" height="17" alt="DL" title="Download" alt="Download">Download Here</a>';
			
			if (($file['purgatory'] == 1) && ($permissions['ecdownloadpermissions'] & $vbulletin->bf_ugp['ecdownloadpermissions']['canmanagepurgatory']))
			{
				$download = $vbphrase['ecdownloads_file_in_purgatory'].': '.$download;
			}
		}
		else
		{
			$download = $vbphrase['ecdownloads_no_permission_download'];
		}
	}
	else
	{
		$download = $vbphrase['ecdownloads_file_in_purgatory'];
	}
		
	$description = $parser->do_parse($file['desc']);
	
	$result = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "dl_images WHERE `file`=".$db->sql_prepare($file['id']));
	if ($db->num_rows($result) > 0)
	{
		while ($image = $db->fetch_array($result))
		{
			if (($permissions['ecdownloadpermissions'] & $vbulletin->bf_ugp['ecdownloadpermissions']['caneditallfiles']) ||
			   (($permissions['ecdownloadpermissions'] & $vbulletin->bf_ugp['ecdownloadpermissions']['caneditownfiles']) &&
			    (($image['uploaderid'] == $vbulletin->userinfo['userid']) && ($file['uploaderid'] == $vbulletin->userinfo['userid']))))
				$edit = '[<a href="./downloads.php?do=file&id='.$file['id'].'&act=delimg&img='.$image['id'].'">Delete</a>]';
			{
				if (file_exists($dl->url.$image['thumb']))
					$dimages .= '<a href="'.$dl->url.$image['name'].'"><img src="'.$dl->url.$image['thumb'].'"></a> by <a href="./member.php?u='.$image['uploaderid'].'">'.$image['uploader'].'</a> on '.vbdate($vbulletin->options['dateformat'],$image['date'],true).' '.$edit.'<br>';
				else
					$dimages .= '<a href="'.$dl->url.$image['name'].'">'.$image['name'].'</a> by <a href="./member.php?u='.$image['uploaderid'].'">'.$image['uploader'].'</a> on '.vbdate($vbulletin->options['dateformat'],$image['date'],true).' '.$edit.'<br>';
			}
		}
	}
	else
	{
		$dimages = $vbphrase['ecdownloads_none'];
	}
	
	$category_array = $dl->construct_select_array(0,array('#' => $vbphrase['ecdownloads_category_jump']),'',false);
	foreach($category_array as $cat_key => $cat_value)
	{
		$category_jump .= '<option value="./downloads.php?do=cat&id='.$cat_key.'">'.$cat_value.'</option>';
	}
	
	eval('$dmain_jr = "' . fetch_template('downloads_file') . '";');
	eval('$dpanel = "' . fetch_template('downloads_panel_side') . '";');
	eval('$dmain = "' . fetch_template('downloads_wrapper_side') . '";');
}
elseif ($_GET['do'] == 'add' || $_GET['do'] == 'edit')
{
	if ($_GET['do'] == 'add')
	{
		$navbits['downloads.php?do=add'] = $vbphrase['ecdownloads_add_file'];
		if (!($permissions['ecdownloadpermissions'] & $vbulletin->bf_ugp['ecdownloadpermissions']['canuploadfiles']) &&
			!($permissions['ecdownloadpermissions'] & $vbulletin->bf_ugp['ecdownloadpermissions']['canlinktofiles'])) 
		{
			print_no_permission();
		}
	}
	elseif ($_GET['do'] == 'edit')
	{
		$file = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "dl_files WHERE `id`=".$db->sql_prepare($_GET['id']));
		if($file['id'] == 0)
			eval(print_standard_redirect('ecdownloads_msg_invalid_file'));
			
		$navbits['downloads.php?do=edit'] = $vbphrase['ecdownloads_edit_file'];
		if (!($permissions['ecdownloadpermissions'] & $vbulletin->bf_ugp['ecdownloadpermissions']['caneditallfiles']) &&
		   (!($permissions['ecdownloadpermissions'] & $vbulletin->bf_ugp['ecdownloadpermissions']['caneditownfiles']) ||
		   ($file['uploaderid'] != $vbulletin->userinfo['userid'])))
		{
			print_no_permission();
		}
	}
		
	if ($_POST['submit'] != '') 
	{
		if ($_POST['dname'] == '')
			$errors['name'] = 'color="#FF0000"';
		if ($_POST['author'] == '')
			$errors['author'] = 'color="#FF0000"';
		if ($_POST['desc'] == '')
			$errors['desc'] = 'color="#FF0000"';
		if ($_POST['category'] == '')
			$errors['category'] = 'color="#FF0000"';
			
		if (isset($errors)) 
		{
			$errors['message'] .= '<center>'.$vbphrase['ecdownloads_fill_in_fields'].'</center><br>';
		}
					
		$ext = '';
		if ($_FILES['upload']['name'] != '' && ($permissions['ecdownloadpermissions'] & $vbulletin->bf_ugp['ecdownloadpermissions']['canuploadfiles']))
		{
			$link = false;
			$upload = true;
			$ext = strtolower(substr($_FILES['upload']['name'], strrpos($_FILES['upload']['name'], '.')+1));
		}
		elseif ($_POST['link'] != '' && ($permissions['ecdownloadpermissions'] & $vbulletin->bf_ugp['ecdownloadpermissions']['canlinktofiles']))
		{
			$link = true;
			$upload = false;
			$ext = strtolower(substr($_POST['link'], strrpos($_POST['link'], '.')+1));
		}
		elseif ($_GET['do'] != 'edit')
		{			
			$errors['upload'] = 'color=#FF0000"';
			//$errors['link'] = 'color=#FF0000"';
			$errors['message'] .= '<center>'.$vbphrase['ecdownloads_must_submit_file'].'</center><br>';
		}
		
		if ($ext != '' && $_POST['link'] == '' )
		{
			if (!strstr("|".str_replace(" ","|",$dl->ext)."|",$ext))
			{
				$errors['message'] .= '<center>'.$vbphrase['ecdownloads_invalid_extension'].': '.$dl->ext.'</center><br>';
			}
		}
		
		if(!isset($errors))
		{
			if ($upload != "") 
			{
				$cat = $db->query_first("SELECT `abbr` FROM " . TABLE_PREFIX . "dl_cats WHERE `id`=".$db->sql_prepare($_POST['category']));
				$newfilename = $dl->file_prepare(strtolower(str_replace('--', '-', str_replace(' ', '-', preg_replace('/[^\sA-Za-z0-9]+/', '', (TIMENOW%100000).' '.$_POST['dname']))).'.'.$ext));


				if (move_uploaded_file($_FILES['upload']['tmp_name'], $dl->url.$newfilename)) {
					chmod($dl->url.$newfilename, 0666);
					$size = @filesize($dl->url.$newfilename);
				} else {
					$errors['message'] .= '<center><font color="#FF0000">The upload failed!  Upload error.</font></center><br>';
				}
			}
			elseif ($link)
			{
				$newfilename = $_POST['link']; 
				$size = @filesize($newfilename);
				
				// check for http on beginning of link or d/l won't work
				$checkhttp = substr($newfilename,0,3);
				if ($checkhttp != "htt" AND $checkhttp != "ftp") 
				{
					$newfilename = "http://".$newfilename;
				}
				// end of http check
			}
			elseif ($_GET['do'] == 'edit')
			{
				$cat = $db->query_first("SELECT `abbr` FROM " . TABLE_PREFIX . "dl_cats WHERE `id`=".$db->sql_prepare($_POST['category']));
				$newfilename = $dl->file_prepare(strtolower(str_replace('--', '-', str_replace(' ', '-', preg_replace('/[^\sA-Za-z0-9]+/', '', (TIMENOW%100000).' '.$_POST['dname'])))).'.'.$file['ext']);
				$size = $file['size'];
				$link = $file['link'];
			}
			
			if ($_GET['do'] == 'add' AND !isset($errors))
			{
				$result = $db->query_write("INSERT INTO " . TABLE_PREFIX . "dl_files (`name`, `desc`, `author`, `uploader`, `uploaderid`, `url`, `date`, `category`, `size`, `pin`, `purgatory`, `link`)
											VALUES(".
												$db->sql_prepare($_POST['dname']).", ".
												$db->sql_prepare($_POST['desc']).", ".
												$db->sql_prepare($_POST['author']).", ".
												$db->sql_prepare($vbulletin->userinfo['username']).", ".
												$db->sql_prepare($vbulletin->userinfo['userid']).", ".
												$db->sql_prepare($newfilename).", ".
												$db->sql_prepare(TIMENOW).", ".
												$db->sql_prepare($_POST['category']).", ".
												$db->sql_prepare($size).", ".
												$db->sql_prepare($_POST['pin']).", ".
												$db->sql_prepare($_POST['purgatory']).", ".
												$db->sql_prepare($link).
											")"
										);
			}
			elseif($_GET['do'] == 'edit')
			{
				
				if (!isset($upload))
				{
					$newfilename = $newfilename.strtolower(substr($file['url'], strrpos($file['url'], '.')+1)); // fix ext dropping problem
				}
				
				$result = $db->query_write("UPDATE " . TABLE_PREFIX . "dl_files SET `name`=".$db->sql_prepare($_POST['dname']).
												",`desc`=".$db->sql_prepare($_POST['desc']).
												",`author`=".$db->sql_prepare($_POST['author']).
												",`url`=".$db->sql_prepare($newfilename).
												",`category`=".$db->sql_prepare($_POST['category']).
												",`size`=".$db->sql_prepare($size).
												",`pin`=".$db->sql_prepare($_POST['pin']).
												",`purgatory`=".$db->sql_prepare($_POST['purgatory']).
												",`link`=".$db->sql_prepare($link)
												." WHERE `id`=".$db->sql_prepare($_GET['id']));
			}
	
			if ($_GET['do'] == 'add' AND !isset($errors)) 
			{
				$id = $db->insert_id();
				$temp = $db->query_first("SELECT COUNT(`id`) AS `uploads` FROM " . TABLE_PREFIX . "dl_files WHERE `uploaderid`=".$db->sql_prepare($vbulletin->userinfo['userid']));
				$db->query_write("UPDATE " . TABLE_PREFIX . "user SET `uploads`=".$db->sql_prepare($temp['uploads'])." WHERE `userid`=".$db->sql_prepare($vbulletin->userinfo['userid']));
				$temp = $db->query_first("SELECT COUNT(`id`) AS `files` FROM " . TABLE_PREFIX . "dl_files");
				$db->query_write("UPDATE " . TABLE_PREFIX . "dl_main SET `files`=".$db->sql_prepare($temp['files']));
				$dl->modify_filecount($_POST['category'], 1);
				$dl->update_counters();
				$vbulletin->url = './downloads.php?do=file&id='.$id;
				eval(print_standard_redirect('ecdownloads_msg_file_added'));
			}
			else
			{
				if (!isset($errors)) 
				{
					if (!isset($upload)){
						rename($dl->url.$file['url'], $dl->url.$newfilename);
					}
					if ($file['category'] != $_POST['category']) 
					{
						$dl->modify_filecount($_POST['category'], 1);
						$dl->modify_filecount_delete($file['category'], -1);
					}
					$dl->update_counters();
					$vbulletin->url = 'downloads.php?do=file&id='.$_GET['id'];
					eval(print_standard_redirect('ecdownloads_msg_file_edited'));
				}
			}
		}
	}
	
	if (($_GET['do'] == 'edit') && isset($file))
	{
		$_POST = $file;
		$_POST['dname'] = $file['name'];
	}
	
	if ($_POST['pin'] == 1)
	{
		$pinned = 'selected';
		$unpinned = '';
	}
	else
	{
		$pinned = '';
		$unpinned = 'selected';
	}
	
	$category_array = $dl->construct_select_array(0,array('' => '----------'),'',false);
	foreach($category_array as $cat_key => $cat_value)
	{
		if (($_POST['category'] == $cat_key) || ($_GET['cat'] == $cat_key))
			$selected = 'selected';
		else
			$selected = '';
		$category_select .= '<option value="'.$cat_key.'" '.$selected.'>'.$cat_value.'</option>';
	}
	
	eval('$dmain_jr = "' . fetch_template('downloads_file_addit') . '";');
	eval('$dpanel .= "' . fetch_template('downloads_panel_side') . '";');
	eval('$dmain .= "' . fetch_template('downloads_wrapper_side') . '";');
}
elseif ($_GET['do'] == 'manfiles')
{
	$navbits['downloads.php?do=manfiles'] = $vbphrase['ecdownloads_manage_files'];
	$dl->update_counters_all();
	
	$file = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "dl_files WHERE `id`=".$db->sql_prepare($_GET['id'])); 
	if (($permissions['ecdownloadpermissions'] & $vbulletin->bf_ugp['ecdownloadpermissions']['caneditallfiles']) ||
	   (($permissions['ecdownloadpermissions'] & $vbulletin->bf_ugp['ecdownloadpermissions']['caneditownfiles']) &&
	   ($file['uploaderid'] == $vbulletin->userinfo['userid'])))
		$showedit = true;	
	if ($permissions['ecdownloadpermissions'] & $vbulletin->bf_ugp['ecdownloadpermissions']['canmanagepurgatory'])
		$showapprove = true;
	if (!$showedit && !$showapprove)
		print_no_permission();
		
	if ($_GET['redir'] == 'manfiles')
	{
		$vbulletin->url = './downloads.php?do=manfiles&category='.$_GET['category'].'&pin='.$_GET['pin'].'&approval='.$_GET['approval'].'&page='.$_GET['page'];
	}
	elseif ($_GET['redir'] == 'file')
	{
		$vbulletin->url = './downloads.php?do=file&id='.$_GET['id'];
	}
	else
	{
		$vbulletin->url = './downloads.php?';
	}
	
	if ($_GET['act'] == '')
	{
	}
	elseif ($_GET['act'] == 'approve' && $showapprove)
	{
		$db->query_write("UPDATE " . TABLE_PREFIX . "dl_files SET `purgatory`='0' WHERE `id`=".$db->sql_prepare($_GET['id']));
		$dl->update_counters();
		eval(print_standard_redirect('ecdownloads_msg_file_approved'));
	}
	elseif ($_GET['act'] == 'unapprove' && $showapprove)
	{

		$db->query_write("UPDATE " . TABLE_PREFIX . "dl_files SET `purgatory`='1' WHERE `id`=".$db->sql_prepare($_GET['id']));
		$dl->update_counters();
		eval(print_standard_redirect('ecdownloads_msg_file_unapproved'));
	}
	elseif ($_GET['act'] == 'pin' && $showapprove)
	{
		$db->query_write("UPDATE " . TABLE_PREFIX . "dl_files SET `pin`='1' WHERE `id`=".$db->sql_prepare($_GET['id']));
		eval(print_standard_redirect('ecdownloads_msg_file_pinned'));
	}
	elseif ($_GET['act'] == 'unpin' && $showapprove)
	{
		$db->query_write("UPDATE " . TABLE_PREFIX . "dl_files SET `pin`='0' WHERE `id`=".$db->sql_prepare($_GET['id']));
		eval(print_standard_redirect('ecdownloads_msg_file_unpinned'));
	}
	elseif ($_GET['act'] == 'delete' && $showedit)
	{
		$file = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "dl_files WHERE `id`=".$db->sql_prepare($_GET['id']));
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "dl_files WHERE `id`=".$db->sql_prepare($_GET['id']));
		if (!$file['link'])
			@unlink($dl->url.$file['url']);

		$result = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "dl_images WHERE `file`=".$db->sql_prepare($_GET['id']));
		while ($image = $db->fetch_array($result))
		{
			@unlink($dl->url.$image['name']);
			@unlink($dl->url.$image['thumb']);
		}
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "dl_images WHERE `file`=".$db->sql_prepare($_GET['id']));
			
		$dl->modify_filecount_user($file['uploaderid']);
		$dl->update_counters();
		$dl->modify_filecount_delete($file['category'], -1);
		
		$db->query_write("UPDATE " . TABLE_PREFIX . "dl_main SET `files`=`files`-1");
		eval(print_standard_redirect('ecdownloads_msg_file_deleted'));
	}
	elseif ($_GET['act'] == 'mass' && ($showedit || $showapprove) && $_POST['id'])
	{
		if ($_POST['act'] == 'approve' && $showapprove)
		{
			foreach($_POST['id'] as $id => $value)
				$db->query_write("UPDATE " . TABLE_PREFIX . "dl_files SET `purgatory`='0' WHERE `id`=".$db->sql_prepare($id));
			$dl->update_counters();
			eval(print_standard_redirect('ecdownloads_msg_file_approved'));
		}
		elseif ($_POST['act'] == 'unapprove' && $showapprove)
		{
			foreach($_POST['id'] as $id => $value)
				$db->query_write("UPDATE " . TABLE_PREFIX . "dl_files SET `purgatory`='1' WHERE `id`=".$db->sql_prepare($id));
			$dl->update_counters();
			eval(print_standard_redirect('ecdownloads_msg_file_unapproved'));
		}
		elseif ($_POST['act'] == 'pin' && $showapprove)
		{
			foreach($_POST['id'] as $id => $value)
				$db->query_write("UPDATE " . TABLE_PREFIX . "dl_files SET `pin`='1' WHERE `id`=".$db->sql_prepare($id));
			eval(print_standard_redirect('ecdownloads_msg_file_pinned'));
		}
		elseif ($_POST['act'] == 'unpin' && $showapprove)
		{
			foreach($_POST['id'] as $id => $value)
				$db->query_write("UPDATE " . TABLE_PREFIX . "dl_files SET `pin`='0' WHERE `id`=".$db->sql_prepare($id));
			eval(print_standard_redirect('ecdownloads_msg_file_unpinned'));
		}
		elseif ($_POST['act'] == 'delete' && $showedit)
		{
			foreach($_POST['id'] as $id => $value) 
			{
				$file = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "dl_files WHERE `id`=".$db->sql_prepare($id));
				if ($file['id'] > 0)
				{
					$db->query("DELETE FROM " . TABLE_PREFIX . "dl_files WHERE id=".$db->sql_prepare($id));
					if (!$file['link'])
						@unlink($dl->url.$file['url']);
						
					$result = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "dl_images WHERE `file`=".$db->sql_prepare($_GET['id']));
					while ($image = $db->fetch_array($result))
					{
						@unlink($dl->url.$image['name']);
						@unlink($dl->url.$image['name']);
					}
					$db->query_write("DELETE FROM " . TABLE_PREFIX . "dl_images WHERE `file`=".$db->sql_prepare($_GET['id']));
			
					$dl->modify_filecount($file['category'],-1);
				}
				else
				{
					unset($_POST[$id]);
				}
			}
			$dl->update_counters();
			$db->query_write("UPDATE " . TABLE_PREFIX . "dl_main SET `downloads`=`downloads`-".$db->sql_prepare(sizeof($_POST['id'])));
			eval(print_standard_redirect('ecdownloads_msg_file_deleted'));
		}
		elseif ($_POST['act'] == 'move' && $showedit)
		{
			$cat = $db->query_first("SELECT `abbr` FROM " . TABLE_PREFIX . "dl_cats WHERE `id`=".$db->sql_prepare($_POST['category']));
			foreach($_POST['id'] as $id => $value)
			{
				$file = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "dl_files WHERE `id`=".$db->sql_prepare($id));
				if ($file['id'] > 0)
				{
					if (!$file['link'])
					{
						$ext = substr($file['url'], strrpos($file['url'], '.')+1);
						$newfilename = $dl->file_prepare(strtolower(str_replace('--', '-', str_replace(' ', '-', preg_replace('/[^\sA-Za-z0-9]+/', '', (TIMENOW%100000).' '.$file['name'])))).'.'.$ext);
						if (!@rename($dl->url.$file['url'],$dl->url.$newfilename))
							$newfilename = $file['url'];
					}
					else
						$newfilename = $file['url'];
					
					$db->query_write("UPDATE " . TABLE_PREFIX . "dl_files SET `category`=".$db->sql_prepare($_POST['category']).",`url`=".$db->sql_prepare($newfilename)." WHERE `id`=".$db->sql_prepare($id));
					$dl->modify_filecount($file['category'],-1);
				}
				else
				{
					unset($_POST[$id]);
				}
			}
			$dl->modify_filecount($_POST['category'],sizeof($_POST['id']));
			eval(print_standard_redirect('ecdownloads_msg_file_moved'));
		}
	}
	
	$category_array = $dl->construct_select_array(0,array('' => '[Category]'),'',true);
	foreach($category_array as $cat_key => $cat_value)
	{
		$category_select .= '<option value="'.$cat_key.'">'.$cat_value.'</option>';
	}	
	
	$params = '&redir=manfiles';
	
	if($_GET['category'] != '')
	{
		$category = 'category = '.$db->sql_prepare($_GET['category']);
		$params .= '&category='.$_GET['category'];
	}
	else
	{
		$category = 'category != '.$db->sql_prepare(-1);
	}
		
	if($_GET['pin'] == '0')
	{
		$pin = 'AND pin = '.$db->sql_prepare(0);
		$params .= '&pin=0';
	}
	elseif($_GET['pin'] == '1')
	{
		$pin = 'AND pin = '.$db->sql_prepare(1);
		$params .= '&pin=1';
	}
	else
		$pin = '';

	if($_GET['approval'] == '0')
	{
		$approval = 'AND purgatory = '.$db->sql_prepare(1);
		$params .= '&approval=0';
	}
	elseif($_GET['approval'] == '1')
	{
		$approval = 'AND purgatory = '.$db->sql_prepare(0);
		$params .= '&approval=1';
	}
	else
		$approval = '';
		
	$temp = $db->query_first("SELECT COUNT(`id`) AS files FROM " . TABLE_PREFIX . "dl_files WHERE ".$category.$pin.$approval);
	if ($_GET['page'] == '')
		$_GET['page'] = 1;
	$limit = ($_GET['page']-1)*$dl->perpage;
	$navigation = construct_page_nav($_GET['page'], $dl->perpage, $temp['files'], 'downloads.php?do=manfiles&pin='.$_GET['pin'].'&category='.$_GET['category'].'&approved='.$_GET['approved']);
	
	$params .= '&page='.$_GET['page'];
	
	$result = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "dl_files WHERE ".$category.$pin.$approval." ORDER BY `id` DESC LIMIT ".$db->sql_prepare($limit).",".$dl->perpage);
	if ($db->num_rows($result) > 0) 
	{ 
		while($file = $db->fetch_array($result))
		{
			exec_switch_bg();
			if ($file['purgatory'] == 0)
				$info = ' <font color="#0000FF">Approved</font>';
			else
				$info = ' <font color="#FF0000">Unapproved</font>';
			if ($file['pin'] == 1)
				$info .= ', Pinned';

			eval('$dfilebits .= "' . fetch_template('downloads_man_bit') . '";');
		}
	}
	
	$db->free_result($result);
	eval('$dmain_jr .= "' . fetch_template('downloads_man') . '";');
	eval('$dpanel .= "' . fetch_template('downloads_panel_side') . '";');
	eval('$dmain .= "' . fetch_template('downloads_wrapper_side') . '";');
}
elseif ($_GET['do'] == 'stats') 
{
	$navbits['downloads.php?do=stats'] = $vbphrase['ecdownloads_stats'];
	
	$temp = $db->query_first("SELECT COUNT(`day`) AS days FROM " . TABLE_PREFIX . "dl_stats");
	if ($_GET['page'] == '')
		$_GET['page'] = 1;
	$limit = ($_GET['page']-1)*$dl->perpage;
	$navigation = construct_page_nav($_GET['page'], $dl->perpage, $temp['days'], 'downloads.php?do=stats');
	
	$result = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "dl_stats ORDER BY `day` DESC LIMIT ".$db->sql_prepare($limit).",".$dl->perpage);
	while ($stat = $db->fetch_array($result)) 
	{
		$date = vbdate($vbulletin->options['dateformat'],$stat['day']*86400,true);
		$bandwidth = (int) ($stat['bandwidth']/1000);
		if ($bandwidth == 0)
			$bandwidth = $vbphrase['ecdownloads_unknown'];
		else
			$bandwidth .= ' KB';
		exec_switch_bg();
		eval('$dstatbits .= "' . fetch_template('downloads_stats_bit') . '";');
	}
	
	eval('$dmain_jr .= "' . fetch_template('downloads_stats') . '";');
	eval('$dpanel .= "' . fetch_template('downloads_panel_top') . '";');
	eval('$dmain .= "' . fetch_template('downloads_wrapper_top') . '";');
}
elseif ($_GET['do'] == 'search')
{
	$navbits['downloads.php?do=search'] = $vbphrase['ecdownloads_search'];
	
	if ($_POST['search'] != '') 
	{
		$keyword = explode(",",$_POST['search']);
		foreach ($keyword as $text)
		{
			$text = trim($text);
			if (strlen($text) >= 4)
				$query .= " OR `author` LIKE ".$dl->like($text).
						  " OR `name` LIKE ".$dl->like($text).
						  " OR `desc` LIKE ".$dl->like($text);
		}
		
		if (strlen($query) > 0)
			$query = substr($query,4);
		else
			$query = "`id`=".$db->sql_prepare(-1);
		
		$result = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "dl_files WHERE ".$query);
		if ($db->num_rows($result) > 0) 
		{
			while ($file = $db->fetch_array($result)) 
			{
				$date = vbdate($vbulletin->options['dateformat'],$file['date'],true);
				
				if ($file['rating'] <= 0)	$grade = 'Not Rated';
					elseif ($file['rating'] > 9.6) $grade = "A+"; elseif ($file['rating'] > 9.3) $grade = "A"; elseif ($file['rating'] > 8.9) $grade = "A-";
					elseif ($file['rating'] > 8.6) $grade = "B+"; elseif ($file['rating'] > 8.3) $grade = "B"; elseif ($file['rating'] > 7.9) $grade = "B-";
					elseif ($file['rating'] > 7.6) $grade = "C+"; elseif ($file['rating'] > 7.3) $grade = "C"; elseif ($file['rating'] > 6.9) $grade = "C-";
					elseif ($file['rating'] > 6.6) $grade = "D+"; elseif ($file['rating'] > 6.3) $grade = "D"; elseif ($file['rating'] > 5.9) $grade = "D-";
					else $grade = "F";
				
				exec_switch_bg();
				eval('$dresultbits .= "' . fetch_template('downloads_search_result_bit') . '";');
			}
		}
		else 
		{
			$dresultbits .= '<tr><td class="alt2" colspan="5" align="center">No files matched your query.</td></tr>';
		}
		eval('$dresult .= "' . fetch_template('downloads_search_result') . '";');
	}
	
	eval('$dmain_jr .= "' . fetch_template('downloads_search') . '";');
	eval('$dpanel .= "' . fetch_template('downloads_panel_top') . '";');
	eval('$dmain .= "' . fetch_template('downloads_wrapper_top') . '";');
}
elseif ($_GET['do'] == 'my')
{
	$navbits['downloads.php?do=my'] = $vbphrase['ecdownloads_my_files'];
	
	$temp = $db->query_first("SELECT COUNT(`id`) AS files FROM " . TABLE_PREFIX . "dl_files WHERE `uploaderid`=".$db->sql_prepare($vbulletin->userinfo['userid']));
	
	if ($temp['files'] > 0) 
	{
		if ($_GET['page'] == '')
			$_GET['page'] = 1;
		$limit = ($_GET['page']-1)*$dl->perpage;
		$navigation = construct_page_nav($_GET['page'], $dl->perpage, $temp['files'], 'downloads.php?do=my');
		
	
		$result = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "dl_files WHERE `uploaderid`=".$db->sql_prepare($vbulletin->userinfo['userid'])." LIMIT ".$db->sql_prepare($limit).",".$dl->perpage);
		while ($file = $db->fetch_array($result)) 
		{
			$date = vbdate($vbulletin->options['dateformat'],$file['date'],true);
			
			if ($file['rating'] <= 0)	$grade = $vbphrase['ecdownloads_not_rated'];
				elseif ($file['rating'] > 9.6) $grade = "A+"; elseif ($file['rating'] > 9.3) $grade = "A"; elseif ($file['rating'] > 8.9) $grade = "A-";
				elseif ($file['rating'] > 8.6) $grade = "B+"; elseif ($file['rating'] > 8.3) $grade = "B"; elseif ($file['rating'] > 7.9) $grade = "B-";
				elseif ($file['rating'] > 7.6) $grade = "C+"; elseif ($file['rating'] > 7.3) $grade = "C"; elseif ($file['rating'] > 6.9) $grade = "C-";
				elseif ($file['rating'] > 6.6) $grade = "D+"; elseif ($file['rating'] > 6.3) $grade = "D"; elseif ($file['rating'] > 5.9) $grade = "D-";
				else $grade = "F";
		
			if ($file['purgatory'] == 1)
				$status = $vbphrase['ecdownloads_unapproved'];
			else
				$status = $vbphrase['ecdownloads_approved'];
			
			exec_switch_bg();
			eval('$dmyfilebits .= "' . fetch_template('downloads_my_bit') . '";');
		}
	}
	else {
		$myfilebits .= '<tr><td class="alt2" colspan="6" align="center">'.$vbphrase['ecdownloads_you_have_no_uploads'].'</td></tr>';
	}
	
	eval('$dmain_jr .= "' . fetch_template('downloads_my') . '";');
	eval('$dpanel .= "' . fetch_template('downloads_panel_top') . '";');
	eval('$dmain .= "' . fetch_template('downloads_wrapper_top') . '";');
}
else
{
	$result = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "dl_cats WHERE parent = '0' ORDER BY ".$dl->order);
	while ($cat = $db->fetch_array($result))
	{
		$subcats = $dl->grab_subcats_by_name_client($cat['id']);
		exec_switch_bg();
		eval('$dcatbits .= "' . fetch_template('downloads_main_catbit') . '";');
	}
	
	// secure upload, delete the files in the downloads folder that contain dlver when the main page is loaded
		  // open directory and parse file list

		  if (is_dir($dl->url))
		  {
			  if ($dh = opendir($dl->url))
			  {
				  // iterate over file list
				  while (($filename = readdir($dh)) !== false)
				  {
					  if (preg_match("/dlver-/",$filename))
					  {
					  @unlink($dl->url.$filename); // secure download, delete the files
					  }
				  }
				  // close directory
				  closedir($dh);
			  }
		  }
	
	// secure upload end	
	
	$db->free_result($result);
	
	eval('$dmain_jr .= "' . fetch_template('downloads_main') . '";');
	eval('$dpanel .= "' . fetch_template('downloads_panel_top') . '";');
	eval('$dmain .= "' . fetch_template('downloads_wrapper_top') . '";');
}

$navbits = construct_navbits($navbits);
eval('$navbar = "' . fetch_template('navbar') . '";');
eval('print_output("' . fetch_template('DOWNLOADS') . '");');
?>