<?php
/* 	
 * ecDownloads 3.3 by Ronin of EliteCoders.org
 *
 *	Human License (non-binding, for the actual license please view licence.txt)
 *	Attribution-NonCommercial-ShareAlike 2.5
 *	You are free:
 *	   * to copy, distribute, display, and perform the work
 * 	   * to make derivative works
 *
 *	Under the following conditions:
 *		by: Attribution. You must attribute the work in the manner specified by the author or licensor.
 *		nc: Noncommercial. You may not use this work for commercial purposes.
 *		sa: Share Alike. If you alter, transform, or build upon this work, you may distribute the resulting work only under a license identical to this one.
 *
 *		* For any reuse or distribution, you must make clear to others the license terms of this work.
 *		* Any of these conditions can be waived if you get permission from the copyright holder.
 */
 
// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);
@set_time_limit(0);

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array();
$specialtemplates = array();
$globaltemplates = array();
$actiontemplates = array();

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
require_once('./includes/class_downloads.php');
$dl = new vB_Downloads();
$categories = $dl->construct_select_array(0,array(0 => 'None'), false);

// ########################################################
// ################## category Functions ##################
// ########################################################
if ($_GET['do'] == 'category') 
{
	print_cp_header('Manage Download Categories');
	print_form_header('downloadadmin', 'doaddcat');
	print_table_header('Add a Download category');
	print_input_row('Name<dfn>This will become the name of the category.</dfn>', 'name', '');
	print_input_row('Description<dfn>This is a description of the files in the category.</dfn>', 'desc', '');
	print_input_row('Abbreviation<dfn>This is the abbreviated name of the category.</dfn>', 'abbr', '');
	print_select_row('Parent category <dfn>If you want this category to be a sub-category, select the category you want it to be a sub-category of.</dfn>', 'parent', $categories);
	print_input_row('Weight<dfn>This is the weight used in sorting your categories.</dfn>', 'weight', '');
	print_submit_row('Add category', 0);
	
	print_form_header('downloadadmin', 'editcat');
	print_table_header('Edit a Download category');
	print_select_row('Edit category<dfn>Select the category you wish to edit.</dfn>', 'edit', $categories);
	print_submit_row('Edit category', 0);
	
	print_form_header('downloadadmin', 'dodelcat');
	print_table_header('Delete a Download category');
	unset($categories[0]);
	print_select_row('Delete category<dfn>Select the category you wish to delete.</dfn>', 'delete', $categories);
	$categories[0] = 'Delete';
	print_select_row('Delete/Move Files<dfn>Chose to delete or move files to a different category (this includes subcategories).</dfn>', 'destination', $categories);
	print_yes_no_row('Confirm Delete<dfn>You must confirm the delete, you will not be asked again.</dfn>', 'confirm', '');
	print_submit_row('Delete category', 0);

	print_cp_footer();
}

// ########################################################
// #################### Do Add category ###################
// ########################################################
if ($_POST['do'] == 'doaddcat')
{
	if($_POST['name'] == '' || $_POST['abbr'] == '')
	{
		print_stop_message('ecdownloads_category_info_missing');
	} 
	else 
	{
		if ($_POST['parent'] > 0)
		{
			$dl->modify_subcount($_POST['parent'], 1);
			$isSubcat = true;
		}
		$db->query_write("INSERT INTO " . TABLE_PREFIX . "dl_cats(`name`, `abbr`, `desc`, `parent`, `weight`) VALUES(".$db->sql_prepare($_POST['name']).", ".$db->sql_prepare($_POST['abbr']).", ".$db->sql_prepare($_POST['desc']).", ".$db->sql_prepare($_POST['parent']).", ".$db->sql_prepare($_POST['weight']).")");
		if ($db->insert_id() > 0)
		{
			$db->query_write("UPDATE " . TABLE_PREFIX . "dl_main SET `categories` = `categories`+1");
			header('location: downloadadmin.php?do=category');
		}
		else
		{
			if ($isSubcat)
			{
				$dl->modify_subcount($_POST['parent'], -1);
			}
			print_stop_message('ecdownloads_category_add_failed');
		}
	}
}

// ########################################################
// ################### Do Edit Cat Form ###################
// ########################################################
if ($_POST['do'] == 'editcat') 
{
	$cat = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "dl_cats WHERE `id`=".$db->sql_prepare($_POST['edit']));
	$dl->unset_subcats($cat['id']);
	
	print_cp_header('Edit a Download category');
	print_form_header('downloadadmin', 'doeditcat');
	print_table_header('Edit a Download category');
	print_input_row('Name<dfn>This will become the name of the category.</dfn>', 'name', $cat['name']);
	print_input_row('Abbreviation<dfn>This will become category abreviation.</dfn>', 'abbr', $cat['abbr']);
	print_input_row('Description<dfn>This is a description of the files in the category.</dfn>', 'desc', $cat['desc']);
	print_select_row('Parent category <dfn>If you want this category to be a sub-category, select the category you want it to be a sub-category of.</dfn>', 'parent', $categories, $cat['parent']);

	$subcats = $dl->grab_subcats_by_name($cat['id']);
	if ($subcats != '')
	{
		$subcats = substr($subcats,0,-2);
	}
	else
	{
		$subcats = 'None';
	}
	
	print_label_row('<input type="hidden" name="cid" value="'.$cat['id'].'"><input type="hidden" name="pid" value="'.$cat['parent'].'">'.'Subcats<dfn>Categories that are subcategories of this category.</dfn>',$subcats);
	
	print_input_row('Weight<dfn>This is the weight used in sorting your categories.</dfn>', 'weight', $cat['weight']);
	print_submit_row('Edit category', 0);
}

// ########################################################
// ################### Do Edit category ###################
// ########################################################
if ($_POST['do'] == 'doeditcat') 
{
	if ($_POST['cid'] == '')
	{
		print_stop_message('ecdownloads_no_cat_to_edit');
	}
	else
	{
		if ($_POST['parent'] != $_POST['pid'])
		{
			$isDifferent = true;
			if ($_POST['pid'] > 0)
			{
				$dl->modify_subcount($_POST['pid'], -1);
			}
			if ($_POST['parent'] > 0)
			{
				$dl->modify_subcount($_POST['parent'], 1);
			}
		}
		$db->query_write("UPDATE " . TABLE_PREFIX . "dl_cats SET 
			`name`=".$db->sql_prepare($_POST['name']).", 
			`abbr`=".$db->sql_prepare($_POST['abbr']).", 
			`desc`=".$db->sql_prepare($_POST['desc']).", 
			`parent`=".$db->sql_prepare($_POST['parent']).",
			`weight`=".$db->sql_prepare($_POST['weight'])." 
			WHERE `id`=".$db->sql_prepare($_POST['cid']));
		if ($db->affected_rows() > 0)
		{
			header('location: downloadadmin.php?do=category');
		}
		else
		{
			print_stop_message('ecdownloads_category_not_edited');
		}
	}		
}

// ########################################################
// #################### Do Delete Cat #####################
// ########################################################
if ($_POST['do'] == "dodelcat") 
{
	if (!$_POST['confirm']) 
	{
		print_stop_message('ecdownloads_did_not_confirm');
	}
	elseif ($_POST['delete'] == '' || $_POST['delete'] == 0)
	{
		print_stop_message('ecdownloads_cant_delete_air');
	}
	elseif ($_POST['delete'] == $_POST['destination'])
	{
		print_stop_message('ecdownloads_cant_move_into_self');
	}
	elseif (!$dl->validate_move($_POST['delete'],$_POST['destination']))
	{
		print_stop_message('ecdownloads_cant_move_into_subcat');
	}
	else
	{
		$cat = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "dl_cats WHERE `id`=".$db->sql_prepare($_POST['delete']));
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "dl_cats WHERE `id`=".$db->sql_prepare($_POST['delete']));
		if ($db->affected_rows() > 0)
		{
			if ($_POST['destination'] == 0)
			{
				$db->query_write("DELETE FROM " . TABLE_PREFIX . "dl_cats WHERE `parent`=".$db->sql_prepare($_POST['delete']));
			}
			else
			{
				$db->query_write("UPDATE " . TABLE_PREFIX . "dl_cats SET `parent`=".$db->sql_prepare($_POST['destination'])." WHERE `parent`=".$db->sql_prepare($_POST['delete']));
			}
			
			$dl->modify_subcount($cat['parent'], -$db->affected_rows()+$cat['subs']);
			$dl->modify_subcount($_POST['destination'], $db->affected_rows()+$cat['subs']);
			
			if ($_POST['destination'] == 0)
			{
				$db->query_write("DELETE FROM " . TABLE_PREFIX . "dl_files WHERE `category`=".$db->sql_prepare($_POST['delete']));
			}
			else
			{
				$db->query_write("UPDATE " . TABLE_PREFIX . "dl_files SET `category`=".$db->sql_prepare($_POST['destination'])." WHERE `category`=".$db->sql_prepare($_POST['delete']));
			}
			
			$dl->modify_filecount($cat['parent'], -$db->affected_rows()+$cat['files']);
			$dl->modify_filecount($_POST['destination'], $db->affected_rows()+$cat['files']);

			if ($_POST['destination'] == 0)
			{
				$db->query_write("UPDATE " . TABLE_PREFIX . "dl_main SET `files` = `files`-".$db->sql_prepare($cat['files']));
				$db->query_write("UPDATE " . TABLE_PREFIX . "dl_main SET `categories` = `categories`-".$db->sql_prepare($cat['subs']+1));
				header('location: downloadadmin.php?do=category');
			}
			else
			{
				$db->query_write("UPDATE " . TABLE_PREFIX . "dl_main SET `categories` = `categories`-1");
				header('location: downloadadmin.php?do=category');
			}
			
			$dl->update_counters();
		}
		else
		{
			print_stop_message('ecdownloads_nothing_to_delete');
		}
	}
}
?>