<?php
// ++=========================================================================++
// || vBadvanced CMPS v2.0 RC1 - 5840
// ||  2003-2004 vBadvanced.com & PlurPlanet, LLC - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// || Downloaded 13:15, Sat Jun 4th 2005
// || 
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);
define('NO_REGISTER_GLOBALS', 1);

require_once('./global.php');
require_once('./includes/adminfunctions_template.php');
require_once('./includes/adminfunctions_language.php');
require_once('./includes/adminfunctions_vba_cmps.php');

$scriptname = 'CMPS';
$version = '2.0 RC1';
$scriptfile = 'vbacmps_install';

print_cp_header('vBadvanced ' . $scriptname . ' Install', '', '<style type="text/css">
<!--
.redalert
{
	background: #FF0000;
	color: #000000;
}
-->
</style>');

if (empty($_REQUEST['do']))
{
  $_REQUEST['do'] = 'install';
}

// ##################### Make Template Function #####################
function insert_template($name, $content, $printphrase = 0)
{
  global $DB_site;

	$template = compile_template($content);

	$DB_site->query("DELETE FROM " . TABLE_PREFIX . "template WHERE title = '$name' AND styleid = '-1'");

  $DB_site->query("INSERT INTO " . TABLE_PREFIX . "template (templateid, title, template, template_un, styleid, templatetype, dateline, username, version) VALUES (NULL, '$name', '" . addslashes($template) . "', '" . addslashes($content) ."', '-1', 'template', '" . time() . "', 'vBadvanced', '3.0.1')");

	if ($printphrase)
	{
		echo '<span class="smallfont">Created Template - ' . $name . '</span><br />';
	}
}

// ##################### Update Template Function #####################
function update_template($name, $content)
{
  global $DB_site;

	$template = compile_template($content);

  $DB_site->query("UPDATE " . TABLE_PREFIX . "template SET title = '$name', template = '" . addslashes($template) ."', template_un = '" . addslashes($content) . "' WHERE title = '$name'");

	echo '<span class="smallfont">Updated Template - ' . $name . '</font><br />';
}

// ##################### Delete Template Function #####################
function kill_template($title, $printphrase = 0)
{
	global $DB_site;
	
	$DB_site->query("DELETE FROM " . TABLE_PREFIX . "template WHERE title = '$title'");

	if ($printphrase)
	{
		echo '<span class="smallfont">Removed template ' . $title . '</span><br />';
	}
}

// ##################### Insert Settings Function #####################
function insert_setting($title, $description, $varname, $value, $defaultvalue, $optioncode, $displayorder, $grouptitle, $phraseonly = 0, $printphrase = 0)
{
	global $DB_site;

	$checksetting = $DB_site->query_first("SELECT varname FROM " . TABLE_PREFIX . "adv_setting WHERE varname = '$varname' AND grouptitle = '$grouptitle'");
	if ($checksetting['varname'])
	{
		return;
	}

	$checkphrase = $DB_site->query_first("SELECT varname FROM " . TABLE_PREFIX . "phrase WHERE varname = 'setting_" . $varname . "_title'");

	if (!$checkphrase['varname'])
	{
		$DB_site->query("INSERT INTO " . TABLE_PREFIX . "phrase (languageid, varname, text, phrasetypeid) VALUES (0, 'setting_" . $varname . "_title', '" . addslashes($title) ."', 5000)");
		$DB_site->query("INSERT INTO " . TABLE_PREFIX . "phrase (languageid, varname, text, phrasetypeid) VALUES (0,  'setting_" . $varname . "_desc', '" . addslashes($description) . "', 5000)");
	}

	$DB_site->query("INSERT INTO " . TABLE_PREFIX . "adv_setting (varname, grouptitle, value, defaultvalue, optioncode, displayorder) VALUES ('$varname', '$grouptitle', '$value', '$defaultvalue', '" . addslashes($optioncode) . "', '$displayorder')");

	if ($printphrase)
	{
		echo '<span class="smallfont">Added Setting - ' . $title . '</span><br />';
	}
}

// ##################### Update Settings Function #####################
function update_setting($varname, $oldgrouptitle, $title = '', $description = '', $value = '', $defaultvalue = '', $optioncode = '', $displayorder = '', $grouptitle, $printphrase = false)
{
  global $DB_site;

	if ($title)
	{
		$DB_site->query("UPDATE " . TABLE_PREFIX . "phrase SET text = '" . addslashes($title) . "' WHERE varname = 'setting_" . $varname . "_title'");
	}
	if ($description)
	{
		$DB_site->query("UPDATE " . TABLE_PREFIX . "phrase SET text = '" . addslashes($description) . "' WHERE varname = 'setting_" . $varname . "_desc'");
	}

	if ($value OR $defaultvalue OR $optioncode OR $displayorder)
	{
		$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_setting SET defaultvalue = '" . addslashes($defaultvalue) . "', optioncode = '" . addslashes($optioncode) . "', displayorder = '$displayorder', grouptitle = '$grouptitle' WHERE varname = '$varname' AND grouptitle = '$oldgrouptitle'");
	}

	if ($printphrase)
	{
		echo '<span class="smallfont">Updated Setting - ' . $varname . '</span><br />';
	}
}

// ##################### Delete Setting Function #####################
function kill_setting($title)
{
  global $DB_site;

	$DB_site->query("DELETE FROM " . TABLE_PREFIX . "phrase WHERE varname = 'setting_" . $title . "_title'");
	$DB_site->query("DELETE FROM " . TABLE_PREFIX . "phrase WHERE varname = 'setting_" . $title . "_desc'");
	$DB_site->query("DELETE FROM " . TABLE_PREFIX . "adv_setting WHERE varname = '$title'");
	echo '<span class="smallfont">Removed Setting - ' . $title . '</span><br />';
}

// ##################### Insert Phrase Function #####################
function insert_phrase($varname, $text, $type, $printphrase = 0)
{
	global $DB_site;

	$DB_site->query("DELETE FROM " . TABLE_PREFIX . "phrase WHERE varname = '$varname' AND phrasetypeid = '$type' AND languageid = '0'");

	$DB_site->query("INSERT INTO " . TABLE_PREFIX . "phrase (phraseid, languageid, varname, text, phrasetypeid) VALUES (NULL, '0', '" . $varname . "', '" . addslashes($text) ."', '$type')");

	if ($printphrase)
	{
		echo '<span class="smallfont">Added Phrase - ' . $varname . '</span><br />';
	}
}

// ##################### Update Phrase Function #####################
function update_phrase($varname, $text)
{
	global $DB_site;
	
	$DB_site->query("UPDATE " . TABLE_PREFIX . "phrase SET text = '" . addslashes($text) ."' WHERE varname = '$varname'");
	echo '<span class="smallfont">Updated Phrase - ' . $varname . '</span><br />';
}

// ##################### Delete Phrase Function #####################
function kill_phrase($varname, $type, $printphrase = 0)
{
	global $DB_site;
	$DB_site->query("DELETE FROM " . TABLE_PREFIX . "phrase WHERE varname = '$varname' AND phrasetypeid = '$type'");

	if ($printphrase)
	{
		echo '<font size="1">Removed phrase ' . $varname . '</font><br />';
	}
}

// ####################### Templates ################################
$maintemplates = array(
'adv_portal' => 
'$stylevar[htmldoctype]
<html dir="$stylevar[textdirection]" lang="$stylevar[languagecode]">
<head>
<title>$vboptions[hometitle] <if condition="$pages[\'name\'] == \'home\'"> - Home</if> <if condition="$pagetitle">- $pagetitle</if></title>

$headinclude

</head>
<body>

$header

$navbar

<table align="center" class="page" cellspacing="0" cellpadding="0"width="100%">
<tr valign="top">

<if condition="$show[\'left_column\']">

<td width="$vba_style[portal_leftcolwidth]">

$home[leftblocks]
	
</td>

<!-- Spacer Cell -->
<td width="$vba_style[portal_colspacing]"><img alt="" src="$vboptions[bburl]/$vboptions[cleargifurl]" width="$vba_style[portal_colspacing]" /></td>
<!-- / Spacer Cell -->

</if>


<if condition="$show[\'center_column\']">
<td valign="top">

$home[centerblocks]	

</td>
</if>


<if condition="$show[\'right_column\']">	

<!-- Spacer Cell -->
<td width="$vba_style[portal_colspacing]"><img alt="" src="$vboptions[bburl]/$vboptions[cleargifurl]" width="$vba_style[portal_colspacing]" /></td>
<!-- / Spacer Cell -->

<td valign="top" width="$vba_style[portal_rightcolwidth]">

$home[rightblocks]

</td>
</if>

</tr>
</table>

$footer

</body>
</html>',

'adv_portal_buddylistbits' => 
'<div class="smallfont" style="margin-bottom:2px">
	<span style="float:$stylevar[right]">
	<a href="$vboptions[bburl]/private.php?$session[sessionurl]do=newpm&amp;u=$loggedin[userid]" title="<phrase 1="$loggedin[username]">$vbphrase[send_private_message_to_x]</phrase>">$vbphrase[pm]</a>
	<a href="$vboptions[bburl]/profile.php?$session[sessionurl]do=removelist&amp;userlist=buddy&amp;u=$loggedin[userid]" title="$vbphrase[remove_from_buddy_list]">X</a>
	</span>
	<a href="$vboptions[bburl]/member.php?$session[sessionurl]u=$loggedin[userid]">$loggedin[username]</a> $loggedin[invisiblemark]
</div>',

'adv_portal_calendar_day' => 
'<td class="<if condition="$show[\'highlightweek\']">alt2<else />alt1</if>"<if condition="$show[\'highlighttoday\']"> style="border:solid 1px red; font-weight:bold" title="$vbphrase[today]"</if>>
	<if condition="$show[\'daylink\']">
		<span class="smallfont"><a href="calendar.php?$session[sessionurl]do=getinfo&amp;day=$year-$month-$day&amp;c=$calendarid" title="$eventdesc">$day</a></span>
	<else />
		<span class="smallfont">$day</span>
	</if>
</td>',

'adv_portal_calendar_day_other' => 
'<td class="smallfont"><em>$day</em></td>',

'adv_portal_calendar_header' => 
'<tr>
	<if condition="$show[\'day1\']"><td align="center" class="thead">$day1</td></if>
	<if condition="$show[\'day2\']"><td align="center" class="thead">$day2</td></if>
	<if condition="$show[\'day3\']"><td align="center" class="thead">$day3</td></if>
	<if condition="$show[\'day4\']"><td align="center" class="thead">$day4</td></if>
	<if condition="$show[\'day5\']"><td align="center" class="thead">$day5</td></if>
	<if condition="$show[\'day6\']"><td align="center" class="thead">$day6</td></if>
	<if condition="$show[\'day7\']"><td align="center" class="thead">$day7</td></if>
</tr>
$calendarrowbits
',

'adv_portal_calendar_week' => 
'<tr align="center">
	$calendardaybits
</tr>
',

'adv_portal_footer' => 
'<!-- Do NOT remove this copyright notice. Doing so is a violation of your user agreement! -->

<div align="center" class="smallfont"><phrase 1="$vba_options[portal_version]">$vbphrase[powered_by_vbadvanced_cmps]</phrase></div>',

'adv_portal_latestthreads_head' => 
'<tr>
	<if condition="$mod_options[\'portal_threads_showicon\']">
		<td class="thead" width="5">&nbsp;</td>
	</if>
	<td class="thead" width="100%">$vbphrase[title_username_date]</td>
	<if condition="$mod_options[\'portal_threads_lastpost\']">		
		<td align="center" class="thead" nowrap="nowrap" width="25%">$vbphrase[last_post]</td>
	</if>
	<td class="thead" width="15">$vbphrase[replies]</td>
	<td class="thead" width="15">$vbphrase[views]</td>
	<if condition="$mod_options[\'portal_threads_showforum\']">
		<td align="center" class="thead" width="10%">$vbphrase[forum]</td>
	</if>
</tr>',

'adv_portal_latesttopicbits' => 
'<if condition="$mods[\'modcol\'] == 1">

	<tr>
		<if condition="$mod_options[\'portal_threads_showicon\']">
			<td class="alt2"><if condition="$show[\'threadicon\']"><img alt="" border="0" src="$thread[threadiconpath]" title="$thread[threadicontitle]" /></if></td>
		</if>
		
		<td class="alt1">
			<if condition="$thread[\'subscribed\']">
				<span style="float:$stylevar[right]"><img alt="" class="inlineimg" src="$stylevar[imgdir_misc]/subscribed.gif" title="$vbphrase[you_are_subscribed_to_this_thread]" /></span>
			</if>
		<b><a href="$vboptions[bburl]/showthread.php?t=$thread[threadid]" title="$thread[preview]">$thread[title]</a></b>

			<if condition="$thread[\'rating\']">
				<span style="float:$stylevar[right]"><img alt="" src="$stylevar[imgdir_rating]/rating_$thread[rating].gif" title="<phrase 1="$thread[votenum]" 2="$thread[voteavg]">$vbphrase[thread_rating_x_votes_y_average]</phrase>" /></span>
			</if>
		
		<div class="smallfont"><span style="cursor:pointer" onclick="window.open(\'$vboptions[bburl]/member.php?$session[sessionurl]u=$thread[postuserid]\')">$thread[postusername]</span>

		</div>
		</td>
		<if condition="$show[\'lastpost\']">
			<td class="alt2">
				<div class="smallfont" style="text-align:right; white-space:nowrap">$thread[lastpostdate] <span class="time">$thread[lastposttime]</span><br /><phrase 1="$vboptions[bburl]/member.php?$session[sessionurl]find=lastposter&amp;t=$thread[threadid]" 2="$thread[lastposter]">$vbphrase[by_x]</phrase> <a href="$vboptions[bburl]/showthread.php?$session[sessionurl]goto=lastpost&amp;t=$thread[threadid]"><img alt="" border="0" src="$stylevar[imgdir_button]/lastpost.gif" title="$vbphrase[go_to_last_post]" /></a></div>
			</td>
		</if>
		<td align="center" class="<if condition="$show[\'lastpost\']">alt1<else />alt2</if>"><span class="smallfont">$thread[replycount]</span></td>

		<td align="center" class="<if condition="$show[\'lastpost\']">alt2<else />alt1</if>"><span class="smallfont">$thread[views]</span></td>
			<if condition="$mod_options[\'portal_threads_showforum\']">
				<td class="<if condition="$show[\'lastpost\']">alt1<else />alt2</if>"><span class="smallfont"><a href="$vboptions[bburl]/forumdisplay.php?$session[sessionurl]f=$thread[forumid]">$thread[forumtitle]</a></span></td>
			</if>		
	</tr>

<else />

	<tr>
		<td class="$bgclass">
			<if condition="$show[\'threadicon\']">
				<img alt="" src="$thread[threadiconpath]" border="0" title="$thread[threadicontitle]" />
			</if>
			<if condition="$thread[\'subscribed\']">
				<img alt="" class="inlineimg" src="$stylevar[imgdir_misc]/subscribed.gif" title="$vbphrase[you_are_subscribed_to_this_thread]" />
			</if>
			<span class="smallfont"><strong><a href="$vboptions[bburl]/showthread.php?t=$thread[threadid]" title="<if condition="$thread[preview]">$thread[preview]

</if>$vbphrase[by] $thread[postusername] <if condition="$mod_options[\'portal_threads_showdate\']">$thread[postdate] $thread[posttime]</if>">$thread[title]</a></strong></span>

			<if condition="$thread[\'rating\']">
				<div style="margin-top:4px"><img alt="" src="$stylevar[imgdir_rating]/rating_$thread[rating].gif" title="<phrase 1="$thread[votenum]" 2="$thread[voteavg]">$vbphrase[thread_rating_x_votes_y_average]</phrase>" /></div>
			</if>
			<if condition="$show[\'lastpost\']">
				<div class="smallfont" style="margin-top:4px"><a href="$vboptions[bburl]/showthread.php?$session[sessionurl]goto=lastpost&amp;t=$thread[threadid]"><img alt="" border="0" src="$stylevar[imgdir_button]/lastpost.gif" title="$vbphrase[go_to_last_post]" /></a> $vbphrase[last_post_by] <a href="$vboptions[bburl]/member.php?find=lastposter&amp;t=$thread[threadid]">$thread[lastposter]</a></div>
			</if>
			<div class="smallfont">$thread[lastpostdate] <span class="time">$thread[lastposttime]</span></div>
			<if condition="$mod_options[\'portal_threads_showforum\']">
				<div class="smallfont"><a href="$vboptions[bburl]/forumdisplay.php?$session[sessionurl]f=$thread[forumid]">$thread[forumtitle]</a></div>
			</if>
		<div class="smallfont">$thread[replycount] $vbphrase[replies], $thread[views] $vbphrase[views]</div></td>
	</tr>
</if>',

'adv_portal_moderation' => 
'<tr>
<td class="$bgclass">
			<if condition="$show[\'threads\']">
				<div><phrase 1="$threads[count]" 2="$vboptions[bburl]/$modcpdir/moderate.php?do=posts">$vbphrase[x_threads]</phrase></div>
			</if>
			<if condition="$show[\'posts\']">
				<div><phrase 1="$posts[count]" 2="$vboptions[bburl]/$modcpdir/moderate.php?do=posts#postlist">$vbphrase[x_posts]</phrase></div>
			</if>
			<if condition="$show[\'events\']">
				<div><phrase 1="$events[count]" 2="$vboptions[bburl]/$modcpdir/moderate.php?do=events">$vbphrase[x_events]</phrase></div>
			</if>
			<if condition="$show[\'attachments\']">
				<div><phrase 1="$attachments[count]" 2="$vboptions[bburl]/$modcpdir/moderate.php?do=attachments">$vbphrase[x_attachment]</phrase></div>
			</if>
				<div><phrase 1="$users[count]" 2="$vboptions[bburl]/$admincpdir/user.php?do=moderate">$vbphrase[x_users]</phrase></div>
</td>
</tr>',

'adv_portal_module_shell' => 
'$mods[formcode]
<table align="center" border="0" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" class="tborder" width="100%">
	<thead>
		<tr>
			<td class="tcat" colspan="$mods[colspan]">
			<if condition="$vba_style[\'portal_collapsemods\']">
				<a href="#top" onclick="return toggle_collapse(\'module_$mods[collapse]\')" style="float:$stylevar[right]"><img alt="" border="0" id="collapseimg_module_$mods[collapse]" src="$stylevar[imgdir_button]/collapse_tcat$modimgcollapse.gif" /></a>
			</if>
			<span class="smallfont"><strong>$vba_style[portal_blockbullet] <if condition="$mods[\'link\']"><a href="$mods[link]">$mods[title]</a><else />$mods[title]</if></strong></span></td>
		</tr>
	</thead>
	<tbody id="collapseobj_module_$mods[collapse]" style="$modcollapse">
		<if condition="$show[\'tablerow\']">
			<tr>
				<td class="$bgclass">
					$modulehtml
				</td>
			</tr>
		<else />
			$modulehtml
		</if>
	</tbody>
</table>
<div><img src="$vboptions[bburl]/$vboptions[cleargifurl]" height="$vba_style[portal_vspace]" alt="" /></div>

<if condition="$mods[\'formcode\']"></form></if>',

'adv_portal_navigation' => 
'<tr>
	<td class="$bgclass">
		$navigationbits
		$customnavigationbits
	</td>
</tr>',

'adv_portal_navigationbits' => 
'<div class="smallfont">$navmark <if condition="$link"><a href="$link">$title</a><else />$title</if></div>',

'adv_portal_newsbits' => 
'<if condition="!$mod_options[\'portal_news_legacy\']">
	<tr>
		<td class="thead"><a href="$vboptions[bburl]/showthread.php?t=$news[threadid]">$news[title]</a></td>
	</tr>
</if>
<tr>
	<td class="<if condition="$mod_options[\'portal_news_legacy\']">thead<else />alt2</if>">
		<if condition="$mod_options[\'portal_news_showrating\'] AND $news[\'votenum\']">
			<span style="float:$stylevar[right]"><img alt="" src="$stylevar[imgdir_rating]/rating_$news[rating].gif" title="<phrase 1="$news[votenum]" 2="$news[voteavg]">$vbphrase[thread_rating_x_votes_y_average]</phrase>" /></span>
		</if>
		$news[dateposted] - <phrase 1="$vboptions[bburl]/member.php?$session[sessionurl]u=$news[postuserid]" 2="$news[postusername]">$vbphrase[by_x]</phrase>
	</td>
</tr>
<tr>
	<td align="$stylevar[left]" class="alt1" valign="top">
		<if condition="$news[\'avatarpath\']">
			<img align="$stylevar[left]" style="padding:6px" alt="" border="0" src="$news[avatarpath]" title="$news[postusername]\'s $vbphrase[avatar]" />
		</if>
		$news[message]

		<if condition="$show[\'signature\']">
		<div>__________________<br />
		$news[signature]</div>
		</if>

		</td>
	</tr>

	<if condition="$news[\'attachment\']">
		<tr class="alt1">
			<td>
				<fieldset class="fieldset">
				<legend>Attached Files</legend>
				<div style="padding:$stylevar[formspacer]px">
					$news[attachment]
				</div>
				</fieldset>
			</td>
		</tr>
	</if>

	<tr class="alt2" valign="middle">
	<td valign="middle">
		<span style="float:right">
		<if condition="$show[\'editbutton\']">
			<a href="$vboptions[bburl]/editpost.php?$session[sessionurl]do=editpost&amp;p=$news[postid]"><img alt="$vbphrase[edit_this_post]" border="0" src="$stylevar[imgdir_button]/edit.gif" /></a>
		</if>

		<if condition="$show[\'replybutton\']">
			<a href="$vboptions[bburl]/newreply.php?$session[sessionurl]do=newreply&amp;t=$news[threadid]"><img alt="$vbphrase[reply_to_this_post]" border="0" src="$stylevar[imgdir_button]/reply_small.gif" /></a>
		</if>

		<if condition="$mod_options[\'portal_news_showsendfriend\']">
			<a href="$vboptions[bburl]/sendmessage.php?$session[sessionurl]do=sendtofriend&amp;t=$news[threadid]"><img alt="" border="0" src="$stylevar[imgdir_button]/sendtofriend.gif" title="$vbphrase[send_to_friend]" /></a>
		</if>

		<if condition="$mod_options[\'portal_news_showprintable\']">
			<a href="$vboptions[bburl]/printthread.php?$session[sessionurl]t=$news[threadid]"><img alt="" border="0" src="$stylevar[imgdir_button]/printer.gif" title="$vbphrase[show_printable_version]" /></a>
		</if>
		</span>

		<span class="smallfont">
		<if condition="$mod_options[\'portal_news_allowreplies\']">$news[replycount] <if condition="$news[\'replycount\'] == 1">$vbphrase[reply]<else />$vbphrase[replies]</if> | </if> $news[views] $vbphrase[views]</span>
	</td>
</tr>',

'adv_portal_news_archivebits' => 
'<if condition="$mods[\'modcol\'] == 1">
	<tr>
		<if condition="$mod_options[\'portal_news_showicon\']">
			<td class="alt2"><if condition="$show[\'threadicon\']"><img alt="" border="0" src="$news[threadiconpath]" title="$news[threadicontitle]" /></if>
			</td>
		</if>
		
		<td class="alt1" align="$stylevar[left]">
			<if condition="$news[\'subscribed\']">
				<span style="float:$stylevar[right]"><img alt="" class="inlineimg" src="$stylevar[imgdir_misc]/subscribed.gif" title="$vbphrase[you_are_subscribed_to_this_thread]" /></span>
			</if>
			<b><a href="$vboptions[bburl]/showthread.php?t=$news[threadid]" title="$news[preview]">$news[title]</a></b>
			
			<div class="smallfont"><phrase 1="$vboptions[bburl]/member.php?$session[sessionurl]u=$news[postuserid]" 2="$news[postusername]">$vbphrase[by_x]</phrase>
				<if condition="$news[\'rating\']">
					<span style="float:$stylevar[right]"><img alt="" src="$stylevar[imgdir_rating]/rating_$news[rating].gif" title="<phrase 1="$news[votenum]" 2="$news[voteavg]">$vbphrase[thread_rating_x_votes_y_average]</phrase>" /></span>
				</if>
			</div>
			
			<div class="smallfont">$news[postdate] <span class="time">$news[posttime]</span></div>

		</td>
		
		<td align="center" class="alt2"><span class="smallfont">$news[replycount]</span></td>
		<td align="center" class="alt1"><span class="smallfont">$news[views]</span></td>
		<if condition="$mod_options[\'portal_newsarchive_showforum\']">
			<td class="alt2"><span class="smallfont"><a href="$vboptions[bburl]/showthread.php?$session[sessionurl]t=$news[threadid]">$news[forumtitle]</a></span></td>
		</if>
	</tr>

<else />

	<tr>
		<td class="$bgclass">
			<if condition="$news[threadiconpath]">
				<img alt="" src="$news[threadiconpath]" border="0" title="$news[threadicontitle]" />
			</if>
			<if condition="$news[\'subscribed\']">
				<img alt="" class="inlineimg" src="$stylevar[imgdir_misc]/subscribed.gif" title="$vbphrase[you_are_subscribed_to_this_thread]" />
			</if>
			<span class="smallfont"><b><a href="$vboptions[bburl]/showthread.php?t=$news[threadid]" title="<if condition="$news[preview]">$news[preview]

</if>$vbphrase[by] $news[postusername] $news[postdate] $news[posttime]">$news[title]</a></b></span>
			<div class="smallfont">$vbphrase[last_post_by] <a href="$vboptions[bburl]/member.php?find=lastposter&amp;t=$news[threadid]">$news[lastposter]</a></div>
			<div class="smallfont">$news[lastpostdate] <span class="time">$news[lastposttime]</span></div>
		<if condition="$mod_options[\'portal_newsarchive_showforum\']">
			<div class="smallfont"><a href="$vboptions[bburl]/showthread.php?$session[sessionurl]t=$news[threadid]">$news[forumtitle]</a></div>
		</if>
		<div class="smallfont">$news[replycount] $vbphrase[replies], $news[views] $vbphrase[views]</div></td>
	</tr>
</if>
',

'adv_portal_news_archive_head' => 
'<tr>
	<if condition="$mod_options[\'portal_news_showicon\']">
		<td class="thead" width="15">&nbsp;</td>
	</if>
	<td class="thead" width="100%">$vbphrase[title_username_date]</td><td class="thead" width="15">$vbphrase[replies]</td><td class="thead" width="15">$vbphrase[views]</td>
</tr>
',

'adv_portal_onlineusers' => 
'<tr>
<td class="thead"><span class="smallfont"><phrase 1="$numberregistered" 2="$numberguest">$vbphrase[x_members_and_y_guests]</phrase></span></td>
	</tr>
	<tr>
		<td class="$altbgclass"><span class="smallfont">$activeusers</span></td>
	</tr>
	
	<tr>
		<td class="$bgclass"><span class="smallfont"><phrase 1="$recordusers" 2="$recorddate" 3="$recordtime">$vbphrase[most_users_ever_online_was_x_y_at_z]</phrase></span></td>
</tr>',

'adv_portal_poll' => 
'<tr>
	<td class="thead">$pollinfo[question]</td>
</tr>

$pollbits

<tr>
	<td align="$stylevar[left]" class="$altbgclass">
		<if condition="$pollinfo[\'showresults\']">
			<span class="smallfont"><b>$vbphrase[total_votes]: $pollinfo[nvotes]</b><br />$pollinfo[message].</span>
		<else />
			<input name="s" type="hidden" value="$session[dbsessionhash]" />
			<input name="do" type="hidden" value="pollvote" />
			<input name="pollid" type="hidden" value="$pollinfo[pollid]" />
			<input class="button" name="button" type="submit" value="$vbphrase[vote_now]" />
		</if>
	</td>
</tr>
<tr>
	<td class="$bgclass">
		<div class="smallfont">&raquo; <a href="$vboptions[bburl]/poll.php?$session[sessionurl]do=showresults&amp;pollid=$pollinfo[pollid]">$vbphrase[view_poll_results]</a></div>
		<if condition="$mod_options[\'portal_poll_allowreplies\']">
			<div class="smallfont">&raquo; <a href="$vboptions[bburl]/newreply.php?$session[sessionurl]t=$pollinfo[threadid]">$vbphrase[discuss_this_poll]</a></div>
			<div class="smallfont">&raquo; <a href="$vboptions[bburl]/showthread.php?$sddession[sessionurl]t=$pollinfo[threadid]">$vbphrase[this_poll_has] $pollinfo[replycount] <if condition="$pollinfo[\'replycount\'] == 1">$vbphrase[reply]<else />$vbphrase[replies]</if></a></div>
		</if>

		<if condition="$show[\'editpoll\']">
			<div class="smallfont">&raquo; <a href="$vboptions[bburl]/poll.php?$session[sessionurl]do=polledit&amp;pollid=$pollinfo[pollid]">$vbphrase[edit_poll]</a></div>
		</if>
	</td>
</tr>',

'adv_portal_polloption' => 
'<tr>
	<td class="$bgclass" valign="middle"><label for="pollchoice_$option[number]"><input id="pollchoice_$option[number]" name="optionnumber" type="radio" value="$option[number]" /><span class="smallfont">$option[question]</span></label></td>
</tr>',

'adv_portal_polloption_multiple' => 
'<tr>
<td class="$bgclass"><label for="pollchoice_$option[number]"><input id="pollchoice_$option[number]" name="optionnumber[$option[number]]" type="checkbox" value="yes" /> <span class="smallfont">$option[question]</span></label></td>
</tr>',

'adv_portal_pollresult' => 
'<tr>
	<td class="$bgclass"><span class="smallfont">$option[question] - $option[percent]%</span><br />
<img alt="" height="10" src="$stylevar[imgdir_poll]/bar$option[graphicnumber]-l.gif" width="3" /><img alt="$option[votes] <if condition="$option[\'votes\'] <> 1">$vbphrase[votes]<else />$vbphrase[vote]</if>" height="10" src="$stylevar[imgdir_poll]/bar$option[graphicnumber].gif" width="$option[barnumber]" /><img alt="" height="10" src="$stylevar[imgdir_poll]/bar$option[graphicnumber]-r.gif" width="3" /></td>
</tr>',

'adv_portal_search' => 
'<tr>
<td class="$bgclass">
	<input class="bginput" name="query" size="13" type="text" /> $gobutton
	<div class="smallfont">&raquo; <a href="$vboptions[bburl]/search.php?">$vbphrase[advanced_search]</a></div>
</td>
</tr>',

'adv_portal_stats' => 
'<tr>
	<td class="$bgclass">
		<span class="smallfont">$vbphrase[members]: $numbermembers<br />
		$vbphrase[threads]: $totalthreads<br />
		$vbphrase[posts]: $totalposts<br />
		$vbphrase[top_poster]: <a href="$vboptions[bburl]/member.php?$session[sessionurl]u=$topposter[userid]">$topposter[username]</a> ($topposter[posts])<br /></span>
	</td>
</tr>
<tr>
	<td class="$altbgclass"><span class="smallfont"><phrase 1="$vboptions[bburl]/member.php?$session[sessionurl]u=$newuserid" 2="$newusername">$vbphrase[welcome_to_our_newest_member_x]</phrase></span></td>
</tr>',

'adv_portal_welcomeblock' => 
'<tr>
<td class="$bgclass">

	<if condition="$mods[\'modcol\'] == 1">
		<if condition="$bbuserinfo[\'userid\']">

			<a href="$vboptions[bburl]/profile.php?do=editavatar"><img src="$avatarurl" border="0" alt="$vbphrase[edit_avatar]" /></a>
			</td>
			<td class="$altbgclass" valign="top" width="100%">
		
				<if condition="$bbuserinfo[\'reputationdisplay\'] OR $bbuserinfo[\'rank\']">
					<div class="smallfont" style="float:$stylevar[right]">
					<if condition="$bbuserinfo[\'reputationdisplay\']">
						$vbphrase[rep_power]: $reppower
						<div align="$stylevar[right]" style="margin-bottom:5px">$bbuserinfo[reputationdisplay]</div>
					</if>
					<if condition="$bbuserinfo[\'rank\']">
						<div align="$stylevar[right]" style="margin-top:5px; margin-bottom:5px">$bbuserinfo[rank]</div>
					</if>
					</div>
				</if>
		
				<span class="smallfont"><phrase 1="$bbuserinfo[username]">$vbphrase[welcome_back_x]</phrase><br />
				<phrase 1="$lastvisitdate" 2="$lastvisittime">$vbphrase[last_visited_x_at_y]</phrase><br />
				<if condition="$mod_options[\'portal_welcome_newposts\']">
					<a href="$vboptions[bburl]/search.php?$session[sessionurl]do=getnew">$vbphrase[new_posts]</a>: $newposts<br />
				</if>
			
				<a href="$vboptions[bburl]/login.php?$session[sessionurl]do=logout&amp;u=$bbuserinfo[userid]" onclick="return log_out()">$vbphrase[log_out]</a></span>
			
				<if condition="$mod_options[\'portal_welcome_newpms\'] AND $show[\'pmstats\']">
						</td>
					</tr>
					<tr>
						<td class="thead" colspan="2"><a href="$vboptions[bburl]/private.php?$session[sessionurl]">$vbphrase[private_messages]</a></td>
					</tr>
					<tr>
						<td class="$bgclass" colspan="2"><span class="smallfont"><phrase 1="$bbuserinfo[pmunread]" 2="$bbuserinfo[pmtotal]" 3="$permissions[pmquota]">$vbphrase[x_new_have_y_of_z_allowed]</phrase></span>
				</if>
		<else />

			<table width="100%" cellspacing="3" cellpadding="0">
				<tr>
					<td nowrap="nowrap"><span class="smallfont">$vbphrase[user_name]</span></td>
					<td nowrap="nowrap"><input class="bginput" name="vb_login_username" size="12" type="text" /></td>
					<td nowrap="nowrap"><span class="smallfont"><input checked="checked" class="bginput" name="cookieuser" id="cb_cookieuser" type="checkbox" value="1" />$vbphrase[remember_me]</span></td>
					<td align="center" rowspan="2" width="100%"><phrase 1="$vboptions[bburl]">$vbphrase[not_a_member_yet_register_now]</phrase></td>
				</tr>
				<tr>
					<td><span class="smallfont">$vbphrase[password]</span></td>
					<td><input class="bginput" name="vb_login_password" size="12" type="password" /></td>
					<td><input class="button" type="submit" value="$vbphrase[log_in]" /></td>
				</tr>
			</table>

		</if>
	
	<else />

		<if condition="$bbuserinfo[\'userid\']">
			<span class="smallfont"><phrase 1="$bbuserinfo[username]">$vbphrase[welcome_back_x]</phrase></span><br />
		
		<if condition="$mod_options[\'portal_welcome_avatar\']">
			<div style="padding:4px">
				<a href="$vboptions[bburl]/profile.php?do=editavatar"><img src="$avatarurl" border="0" alt="$vbphrase[edit_avatar]" /></a>
			</div>
		</if>
		<div class="smallfont">
		<phrase 1="$lastvisitdate" 2="$lastvisittime">$vbphrase[last_visited_x_at_y]</phrase><br />
		<if condition="$mod_options[\'portal_welcome_newposts\']">
			<a href="$vboptions[bburl]/search.php?$session[sessionurl]do=getnew">$vbphrase[new_posts]</a>: $newposts<br />
		</if>
	
		<if condition="$bbuserinfo[\'reputationdisplay\']">
			<div style="margin-top:5px; margin-bottom:5px">$vbphrase[rep_power]: $reppower<br />
			$bbuserinfo[reputationdisplay]</div>
		</if>
		<if condition="$bbuserinfo[\'rank\']">
			<div style="margin-top:5px; margin-bottom:5px">$bbuserinfo[rank]</div>
		</if>
		
		<a href="$vboptions[bburl]/login.php?$session[sessionurl]do=logout&amp;u=$bbuserinfo[userid]" onclick="return log_out()">$vbphrase[log_out]</a></div>
	
		<if condition="$mod_options[\'portal_welcome_newpms\'] AND $show[\'pmstats\']">
			</td>
			</tr>
			<tr>
			<td class="thead"><a href="$vboptions[bburl]/private.php?$session[sessionurl]">$vbphrase[private_messages]</a></td>
			</tr>
			<tr>
			<td class="$altbgclass"><span class="smallfont"><phrase 1="$bbuserinfo[pmunread]" 2="$bbuserinfo[pmtotal]" 3="$permissions[pmquota]">$vbphrase[x_new_have_y_of_z_allowed]</phrase></span>
		</if>
		
		<else />
			<div class="smallfont" style="padding:2px">$vbphrase[user_name]:<br />
				<input class="bginput" name="vb_login_username" size="12" type="text" /><br />
				$vbphrase[password]:<br />
				<input class="bginput" name="vb_login_password" size="12" type="password" /><br />
				<input checked="checked" class="bginput" name="cookieuser" id="cb_cookieuser" type="checkbox" value="1" />$vbphrase[remember_me]
	
				<div style="margin-top:3px; margin-bottom:6px;">
					<input class="button" type="submit" value="$vbphrase[log_in]" />
				</div>
	
			<phrase 1="$vboptions[bburl]">$vbphrase[not_a_member_yet_register_now]</phrase>
			</div>
	
	</if>
</if>
</td>
</tr>'

); 

// ########################### Phrases ################################
$mainphrases = array(
'2' => array('varname' => 'active_users', 'ptype' => '569', 'text' => 
'Active Users'),
'3' => array('varname' => 'buddies', 'ptype' => '569', 'text' => 
'buddies'),
'4' => array('varname' => 'by', 'ptype' => '569', 'text' => 
'By'),
'5' => array('varname' => 'discuss_this_poll', 'ptype' => '569', 'text' => 
'Discuss This Poll'),
'6' => array('varname' => 'edit_this_post', 'ptype' => '569', 'text' => 
'Edit This Post'),
'7' => array('varname' => 'last_post_by', 'ptype' => '569', 'text' => 
'Last post by'),
'8' => array('varname' => 'latest_forum_topics', 'ptype' => '569', 'text' => 
'Latest Forum Topics'),
'9' => array('varname' => 'new_pms', 'ptype' => '569', 'text' => 
'New PMs'),
'10' => array('varname' => 'news_archive', 'ptype' => '569', 'text' => 
'News Archive'),
'11' => array('varname' => 'no_x_online', 'ptype' => '569', 'text' => 
'<span class="smallfont">No {1} online</span>'),
'12' => array('varname' => 'no_x_to_display', 'ptype' => '569', 'text' => 
'No {1} to Display.'),
'13' => array('varname' => 'not_a_member_yet_register_now', 'ptype' => '569', 'text' => 
'Not a member yet?<br />
<a href="{1}/register.php">Register Now!</a>'),
'14' => array('varname' => 'on', 'ptype' => '569', 'text' => 
'on'),
'15' => array('varname' => 'online_buddies', 'ptype' => '569', 'text' => 
'Online Buddies'),
'16' => array('varname' => 'pm', 'ptype' => '569', 'text' => 
'PM'),
'17' => array('varname' => 'poll_results', 'ptype' => '569', 'text' => 
'Poll Results'),
'18' => array('varname' => 'powered_by_vbadvanced_cmps', 'ptype' => '569', 'text' => 
'Powered by <a href="http://vbadvanced.com" target="_blank">vBadvanced</a> CMPS v{1}'),
'19' => array('varname' => 'quick_moderation', 'ptype' => '569', 'text' => 
'Quick Moderation'),
'20' => array('varname' => 'read_more', 'ptype' => '569', 'text' => 
' <span class="smallfont">[<a href="{1}/showthread.php?{3}t={2}">Read More</a>]</span>'),
'21' => array('varname' => 'remove_from_buddy_list', 'ptype' => '569', 'text' => 
'Remove from buddy list'),
'22' => array('varname' => 'rep_power', 'ptype' => '569', 'text' => 
'Rep Power'),
'23' => array('varname' => 'reply_to_this_post', 'ptype' => '569', 'text' => 
'Reply to This Post'),
'24' => array('varname' => 'send_to_friend', 'ptype' => '569', 'text' => 
'Send to Friend'),
'25' => array('varname' => 'shout_now', 'ptype' => '569', 'text' => 
'Shout Now!'),
'26' => array('varname' => 'show_printable_verison', 'ptype' => '569', 'text' => 
'Show Printable Version'),
'27' => array('varname' => 'show_printable_version', 'ptype' => '569', 'text' => 
'Show Printable Version'),
'28' => array('varname' => 'this_poll_has', 'ptype' => '569', 'text' => 
'This Poll Has'),
'29' => array('varname' => 'title_username_date', 'ptype' => '569', 'text' => 
'Title, Username, &amp; Date'),
'30' => array('varname' => 'top_poster', 'ptype' => '569', 'text' => 
'Top Poster'),
'31' => array('varname' => 'vote', 'ptype' => '569', 'text' => 
'Vote'),
'32' => array('varname' => 'welcome_back_x', 'ptype' => '569', 'text' => 
'Welcome back <strong>{1}</strong>'),
'33' => array('varname' => 'x_attachment', 'ptype' => '569', 'text' => 
'<a href="{2}" target="_blank">Attachments</a> ({1})'),
'34' => array('varname' => 'x_events', 'ptype' => '569', 'text' => 
'<a href="{2}" target="_blank">Events</a> ({1})'),
'35' => array('varname' => 'x_new_have_y_of_z_allowed', 'ptype' => '569', 'text' => 
'{1} New PMs. You have {2} total out of {3} allowed.'),
'36' => array('varname' => 'x_posts', 'ptype' => '569', 'text' => 
'<a href="{2}" target="_blank">Posts</a> ({1})'),
'37' => array('varname' => 'x_threads', 'ptype' => '569', 'text' => 
'<a href="{2}" target="_blank">Threads</a> ({1})'),
'38' => array('varname' => 'x_users', 'ptype' => '569', 'text' => 
'<a href="{2}" target="_blank">Users</a> ({1})'),

// Admin Phrases
'51' => array('varname' => 'active_set_to_no_disable', 'ptype' => '570', 'text' => 
'Active
<div class="smallfont">Setting this option to \'No\' will prevent this module from being shown on any pages.</div>'),
'52' => array('varname' => 'add_module', 'ptype' => '570', 'text' => 
'Add Module'),
'53' => array('varname' => 'add_page', 'ptype' => '570', 'text' => 
'Add Page'),
'54' => array('varname' => 'add_setting', 'ptype' => '570', 'text' => 
'Add Setting'),
'55' => array('varname' => 'advanced_options', 'ptype' => '570', 'text' => 
'Advanced Options'),
'56' => array('varname' => 'advanced_options_description', 'ptype' => '570', 'text' => 
'Here you may specify a different value for each module\'s settings that will apply only to this page. If no option is specified here, this page will use the default value. If you wish to revert a setting so that it will use the default, simply check the "Use Default" checkbox to the right of the setting\'s title and then save the settings.'),
'57' => array('varname' => 'allow_html', 'ptype' => '570', 'text' => 
'Allow HTML'),
'58' => array('varname' => 'allow_image_code', 'ptype' => '570', 'text' => 
'Allow [IMG] code'),
'59' => array('varname' => 'allow_smilies', 'ptype' => '570', 'text' => 
'Allow Smilies'),
'60' => array('varname' => 'are_you_sure_delete_module_called_x', 'ptype' => '570', 'text' => 
'Are you sure you want to delete the module called <b>{1}</b>?<br />
This action can <b>NOT</b> be undone.'),
'61' => array('varname' => 'are_you_sure_delete_page_called_x', 'ptype' => '570', 'text' => 
'Are you sure you want to delete the page called <strong>{1}</strong>?'),
'62' => array('varname' => 'bb_code', 'ptype' => '570', 'text' => 
'BB Code'),
'63' => array('varname' => 'bb_code_to_display', 'ptype' => '570', 'text' => 
'BB code to be displayed'),
'64' => array('varname' => 'bbcode_allows_bbcode', 'ptype' => '570', 'text' => 
'A BB Code {1} will allow you to enter BB Code which will be displayed as the content for {2}.'),
'65' => array('varname' => 'center_column', 'ptype' => '570', 'text' => 
'Center Column'),
'66' => array('varname' => 'change_x_type', 'ptype' => '570', 'text' => 
'Change {1} Type'),
'67' => array('varname' => 'change_x_type_note', 'ptype' => '570', 'text' => 
'You are about to change this {1} from a {2} {1} to a {3} {1}. Please note that once you hit the \'Save\' button below any previous information that was stored in the \'{2} {1} Type Options\' will be lost. However, you may change the type of this {1} back at any time.'),
'68' => array('varname' => 'change_x_type_to', 'ptype' => '570', 'text' => 
'Change {1} Type To'),
'69' => array('varname' => 'choose_a_file', 'ptype' => '570', 'text' => 
'Choose a File'),
'70' => array('varname' => 'clean_file_output', 'ptype' => '570', 'text' => 
'Clean File Output
<div class="smallfont">If your are trying to include a PHP file that was not written specifically for vBulletin or vBadvanced, it may be necessary to "clean" the output of this file. If you add a module and the content prints out as the first thing on the top your page, this is a good indication that it needs to be cleaned.</div>'),
'71' => array('varname' => 'column', 'ptype' => '570', 'text' => 
'Column'),
'72' => array('varname' => 'copy', 'ptype' => '570', 'text' => 
'Copy'),
'73' => array('varname' => 'current_selected_threads', 'ptype' => '570', 'text' => 
'Current Selected Threads'),
'74' => array('varname' => 'currently_running_latest_available', 'ptype' => '570', 'text' => 
'You are currently running vBadvanced CMPS v{1}.<br />
<br />
The latest version available is {2}.<br />
<br />
{3}'),
'75' => array('varname' => 'custom_content_title', 'ptype' => '570', 'text' => 
'Custom Content Title
<div class="smallfont">This is what will be placed in the header row of your \'adv_portal_module_shell\' template.'),
'76' => array('varname' => 'custom_page_content_description', 'ptype' => '570', 'text' => 
'This module is used to display the various types of content from your pages. For example, if you add a Template Page, the content of the template specified on that page will be output within this module.'),
'77' => array('varname' => 'custom_style_for_this_page', 'ptype' => '570', 'text' => 
'Custom Style for this Page'),
'78' => array('varname' => 'download_module', 'ptype' => '570', 'text' => 
'Download Module'),
'79' => array('varname' => 'duplicate_filename', 'ptype' => '570', 'text' => 
'Duplicate Filename'),
'80' => array('varname' => 'duplicate_filename_desc', 'ptype' => '570', 'text' => 
'<div class="smallfont">You already have a file called <b>{1}</b> in your modules folder. Please choose a different name for the file.'),
'81' => array('varname' => 'duplicate_module_identifier', 'ptype' => '570', 'text' => 
'Duplicate Module Identifier
'),
'82' => array('varname' => 'duplicate_module_identifier_desc', 'ptype' => '570', 'text' => 
'<div class="smallfont">You already have a module with an identifier of \'{1}\'. Please select a different identifier.</div>'),
'83' => array('varname' => 'edit_module', 'ptype' => '570', 'text' => 
'Edit Module'),
'84' => array('varname' => 'edit_modules', 'ptype' => '570', 'text' => 
'Edit Modules'),
'85' => array('varname' => 'edit_page', 'ptype' => '570', 'text' => 
'Edit Page'),
'86' => array('varname' => 'edit_pages', 'ptype' => '570', 'text' => 
'Edit Pages'),
'87' => array('varname' => 'edit_setting', 'ptype' => '570', 'text' => 
'Edit Setting'),
'88' => array('varname' => 'edit_template', 'ptype' => '570', 'text' => 
'Edit Template'),
'89' => array('varname' => 'edit_template_in_style', 'ptype' => '570', 'text' => 
'Edit the template for this page in the following style: '),
'90' => array('varname' => 'edit_threads', 'ptype' => '570', 'text' => 
'Edit Threads'),
'91' => array('varname' => 'file_allows_file', 'ptype' => '570', 'text' => 
'A File {1} will allow you to specify a file from your modules directory which will be displayed as the content for {2}.'),
'92' => array('varname' => 'file_to_include', 'ptype' => '570', 'text' => 
'File to Include'),
'93' => array('varname' => 'form_code', 'ptype' => '570', 'text' => 
'Form Code
<div class="smallfont">If your module requires a &lt;form&gt; tag, you may enter the code for that form tag here. This allows for the code to be placed above the table and comply with XHTML standards.'),
'94' => array('varname' => 'here_specify_which_usergroups_access_page', 'ptype' => '570', 'text' => 
'Here you may specifiy which usergroups will have access to this page.'),
'95' => array('varname' => 'here_specify_which_usergroups_view_module', 'ptype' => '570', 'text' => 
'Here you may specifiy which usergroups will be able to view this module.'),
'96' => array('varname' => 'html_file', 'ptype' => '570', 'text' => 
'HTML File'),
'97' => array('varname' => 'identifier', 'ptype' => '570', 'text' => 
'Identifier'),
'98' => array('varname' => 'inactive', 'ptype' => '570', 'text' => 
'Inactive'),
'99' => array('varname' => 'left_column', 'ptype' => '570', 'text' => 
'Left Column'),
'100' => array('varname' => 'main_options', 'ptype' => '570', 'text' => 
'Main Options'),
'101' => array('varname' => 'module', 'ptype' => '570', 'text' => 
'Module'),
'102' => array('varname' => 'module_allows_module', 'ptype' => '570', 'text' => 
'A Module Page will allow you to select only modules which you would like to display on this page.'),
'103' => array('varname' => 'module_identifier', 'ptype' => '570', 'text' => 
'Module Identifier
<div class="smallfont">This is what will be used to identify this module and it\'s settings. Please note that this cannot be changed later and each module must have a unique identifier.</div>'),
'104' => array('varname' => 'module_parent', 'ptype' => '570', 'text' => 
'Module Parent
<div class="smallfont">With some modules (such as the News Archive) it may be necessary to specify a parent module. If this module requires a parent module you may specify that parent here.</div>'),
'105' => array('varname' => 'module_shell_template_options', 'ptype' => '570', 'text' => 
'Module Shell Template Options'),
'106' => array('varname' => 'module_title', 'ptype' => '570', 'text' => 
'Module Title'),
'107' => array('varname' => 'module_type', 'ptype' => '570', 'text' => 
'Module Type'),
'108' => array('varname' => 'modules_enabled', 'ptype' => '570', 'text' => 
'Modules Enabled'),
'109' => array('varname' => 'move_to', 'ptype' => '570', 'text' => 
'Move to'),
'110' => array('varname' => 'newer_version_available', 'ptype' => '570', 'text' => 
'<b>There is a newer version of vBadvanced CMPS available!</b><br />
<br />
Please check <a href="http://vbadvanced.com/" target="_blank">vBadvanced.com</a> for more info.
'),
'111' => array('varname' => 'no_modules', 'ptype' => '570', 'text' => 
'No Modules'),
'112' => array('varname' => 'no_x_to_display', 'ptype' => '570', 'text' => 
'No {1} to Display.'),
'113' => array('varname' => 'option_code', 'ptype' => '570', 'text' => 
'Option Code'),
'114' => array('varname' => 'options_apply_to_module_shell', 'ptype' => '570', 'text' => 
'This section deals with options that may be applied to your \'adv_portal_module_shell\' template. Please note that the options are only applicable if the \'Use Module Shell Template\' option below is set to \'Yes\'.'),
'115' => array('varname' => 'or_template_to_include', 'ptype' => '570', 'text' => 
'<b>OR</b> Template to Include'),
'116' => array('varname' => 'overwrite_templates', 'ptype' => '570', 'text' => 
'Overwrite Templates
'),
'117' => array('varname' => 'overwrite_templates_desc', 'ptype' => '570', 'text' => 
'<div class="smallfont">The following template(s) already exist in this style:
<div style="margin-top:5px; margin-bottom:5px">{1}</div>
Select \'yes\' to overwrite your current templates with the new ones, or select no to keep your current templates.</div>'),
'118' => array('varname' => 'page_active', 'ptype' => '570', 'text' => 
'Page Active
<div class="smallfont">When set to \'No\', this page will only be viewable by moderators and admins.</div>'),
'119' => array('varname' => 'page_identifier', 'ptype' => '570', 'text' => 
'Page Identifier'),
'120' => array('varname' => 'page_identifier_example', 'ptype' => '570', 'text' => 
'This is the variable that will be used in the URL to link to this page. For example, if this option is set to \'games\', then the link to this page would look like this: {1}?{2}=games</div>'),
'121' => array('varname' => 'page_template', 'ptype' => '570', 'text' => 
'Page Template'),
'122' => array('varname' => 'page_template_description', 'ptype' => '570', 'text' => 
'This is the template that will replace your "Custom Page Content" module. If you don\'t wish to have a custom template on this page, simply leave this field blank.'),
'123' => array('varname' => 'page_title', 'ptype' => '570', 'text' => 
'Page Title'),
'124' => array('varname' => 'page_type', 'ptype' => '570', 'text' => 
'Page Type'),
'125' => array('varname' => 'parent_page', 'ptype' => '570', 'text' => 
'Parent Page'),
'126' => array('varname' => 'path_to_file', 'ptype' => '570', 'text' => 
'Path to File
<div class="smallfont">Here you may specify the path to a file to include which will replace the content of your \'Custom Page Content\' module.</div>'),
'127' => array('varname' => 'php_file', 'ptype' => '570', 'text' => 
'PHP File'),
'128' => array('varname' => 'please_select_type_of_x_to_add', 'ptype' => '570', 'text' => 
'Please select which type of {1} you would like to add.'),
'129' => array('varname' => 'random', 'ptype' => '570', 'text' => 
'Random'),
'130' => array('varname' => 'remove_module', 'ptype' => '570', 'text' => 
'Remove Module'),
'131' => array('varname' => 'right_column', 'ptype' => '570', 'text' => 
'Right Column'),
'132' => array('varname' => 'select_an_action', 'ptype' => '570', 'text' => 
'Select an action'),
'133' => array('varname' => 'select_module_upload', 'ptype' => '570', 'text' => 
'Please select a module from your computer to upload'),
'134' => array('varname' => 'select_new_threads', 'ptype' => '570', 'text' => 
'Select New Threads'),
'135' => array('varname' => 'setting', 'ptype' => '570', 'text' => 
'setting'),
'136' => array('varname' => 'setting_customized_pages', 'ptype' => '570', 'text' => 
'This setting has been customized in the following pages: '),
'137' => array('varname' => 'style_to_install_to', 'ptype' => '570', 'text' => 
'Style to install templates to
<div class="smallfont">If this module has any templates included, you must choose which style you would like to install these templates to here.</div>'),
'138' => array('varname' => 'template', 'ptype' => '570', 'text' => 
'Template'),
'139' => array('varname' => 'template_allows_template', 'ptype' => '570', 'text' => 
'A Template {1} will allow you to specify the name of a template which will be displayed as the content for {2}.'),
'140' => array('varname' => 'template_content', 'ptype' => '570', 'text' => 
'Template Content
<div class="smallfont">If you are adding a new {1} and the template does not already exist, you may enter the content for that template here. If the template already exists, simply leave this field blank. Please note as well that any changes to this template will need to be made via your \'Style Manager\'.</div>'),
'141' => array('varname' => 'template_note_prefixes', 'ptype' => '570', 'text' => 
'Please note that templates should have the prefix "adv_portal". It is not necessary to enter that prefix with the template name, so if the template you would like to include is named "adv_portal_search" then you would simply enter "search" for the template to include.'),
'142' => array('varname' => 'template_title', 'ptype' => '570', 'text' => 
'Template Title'),
'143' => array('varname' => 'template_to_include', 'ptype' => '570', 'text' => 
'Template to Include'),
'144' => array('varname' => 'templates_used', 'ptype' => '570', 'text' => 
'Templates Used
<div class="smallfont">Here you may enter a list of any templates that will be used for this module. This is used to cache the templates as well as figure out which templates belong to this module when downloading modules.'),
'145' => array('varname' => 'templates_used_note', 'ptype' => '570', 'text' => 
'List all templates (seperated by comma\'s) that your module will use here in order to cache them and prevent unnecessary queries.<br />Note: This is only necessary when including files, but not when including templates.'),
'146' => array('varname' => 'this_module', 'ptype' => '570', 'text' => 
'this module'),
'147' => array('varname' => 'this_what_used_identify_module', 'ptype' => '570', 'text' => 
' This is what will be used to identify this particular module. Unless you have a use for this it should be left blank.'),
'148' => array('varname' => 'title_row_colspan', 'ptype' => '570', 'text' => 
'Title Row Colspan
<div class="smallfont">If the module will have more than one table cell in the code which is output, you may set a colspan value here that will be placed in the title row of the \'adv_portal_module_shell\' template.</div>'),
'149' => array('varname' => 'to_begin_selecting_threads', 'ptype' => '570', 'text' => 
'To begin selecting threads to display, first choose a forum to browse.'),
'150' => array('varname' => 'to_remove_this_module', 'ptype' => '570', 'text' => 
'To remove this module click the \'Remove Module\' button below.'),
'151' => array('varname' => 'tool_downloads_module', 'ptype' => '570', 'text' => 
'This tool will allow you to download a .module file which will contain all information (settings, templates, files, etc) that is associated with this module. This allows you to easily make backups of your modules and/or share your custom modules with others.'),
'152' => array('varname' => 'update_all_pages', 'ptype' => '570', 'text' => 
'Update All Pages
<div class="smallfont">Set this option to \'Yes\' if you would like to update all of your pages to include this module. Otherwise, you will need to manually edit each page that you would like the module to appear on.</div>'),
'153' => array('varname' => 'upload_module', 'ptype' => '570', 'text' => 
'Upload Module'),
'154' => array('varname' => 'use_default', 'ptype' => '570', 'text' => 
'Use Default'),
'155' => array('varname' => 'use_default_style', 'ptype' => '570', 'text' => 
'Use Default Style'),
'156' => array('varname' => 'use_module_shell_template', 'ptype' => '570', 'text' => 
'Use Module Shell Template
<div class="smallfont">This option will dispaly the output of this {1} within your \'adv_portal_module_shell\' template. </div>'),
'157' => array('varname' => 'vbadvanced_cmps', 'ptype' => '570', 'text' => 
'vBadvanced CMPS'),
'158' => array('varname' => 'version_info_unavailable', 'ptype' => '570', 'text' => 
'vBadvanced version information is currently unavailable.'),
'159' => array('varname' => 'welcome_to_vba_cmps_control_panel', 'ptype' => '570', 'text' => 
'Welcome to the vBadvanced CMPS Admin Control Panel'),
'160' => array('varname' => 'x_link', 'ptype' => '570', 'text' => 
'{1} Link
<div class="smallfont">If you would like the title of this {1} to link to another page on your site you may enter the file that this {1} should link to here.</div>'),
'161' => array('varname' => 'x_options', 'ptype' => '570', 'text' => 
'<b>{1} Options</b>'),
'162' => array('varname' => 'x_tools', 'ptype' => '570', 'text' => 
'{1} Tools'),
'163' => array('varname' => 'x_y_options', 'ptype' => '570', 'text' => 
'{2} {1} Options'),
'164' => array('varname' => 'your_custom_content', 'ptype' => '570', 'text' => 
'your \'Custom Page Content\' module'),
'165' => array('varname' => 'your_vba_version_up_to_date', 'ptype' => '570', 'text' => 
'Your version of vBadvanced CMPS is up to date.'),
'166' => array('varname' => 'show_module_settings', 'ptype' => '570', 'text' => 
'Show Module Settings'),
'167' => array('varname' => 'hide_module_settings', 'ptype' => '570', 'text' => 
'Hide Module Settings'),
'168' => array('varname' => 'modules', 'ptype' => '570', 'text' => 
'Modules'),
'169' => array('varname' => 'level', 'ptype' => '570', 'text' => 
'Level'),
'170' => array('varname' => 'link', 'ptype' => '570', 'text' => 
'Link'),
'171' => array('varname' => 'order', 'ptype' => '570', 'text' => 
'Order'),
'172' => array('varname' => 'module_name', 'ptype' => '570', 'text' => 
'Module Name'),
'173' => array('varname' => 'html_allows_html', 'ptype' => '570', 'text' => 
'An HTML Page will allow you to specify a HTML file on your server to include which will be displayed as the content for your \'Custom Page Content\' module.'),


// CP Stop Messages
'201' => array('varname' => 'adv_portal_cant_remove_default', 'ptype' => '9000', 'text' => 
'You can\'t remove your default page!'),
'202' => array('varname' => 'adv_portal_choose_style', 'ptype' => '9000', 'text' => 
'You must choose the style in which you wish to install the templates for this module to.'),
'203' => array('varname' => 'adv_portal_duplicate_identifier', 'ptype' => '9000', 'text' => 
'You already have a {1} with an identifier of \'{2}\'. Please select a different identifier.'),
'204' => array('varname' => 'adv_portal_invalid_modfile', 'ptype' => '9000', 'text' => 
'The file you have uploaded is not a valid module file.'),
'205' => array('varname' => 'adv_portal_must_choose_file_include', 'ptype' => '9000', 'text' => 
'You must choose a file to include!'),
'206' => array('varname' => 'adv_portal_must_choose_include', 'ptype' => '9000', 'text' => 
'You must choose either a file or a template to include!'),
'207' => array('varname' => 'adv_portal_must_choose_template_include', 'ptype' => '9000', 'text' => 
'You must choose a template to include!'),
'208' => array('varname' => 'adv_portal_must_choose_title_for_module', 'ptype' => '9000', 'text' => 
'You must choose a title for your module!'),
'209' => array('varname' => 'adv_portal_must_enter_x_for_page', 'ptype' => '9000', 'text' => 
'You must choose a {1} for your page!'),
'210' => array('varname' => 'adv_portal_template_exists', 'ptype' => '9000', 'text' => 
'A template named {1} already exists in this style. Please choose a different name for your template, a different style to install this template to, or simply leave the \'Template Content\' field blank. Please note that you may also edit this template through your \'Style Manager\'.'),
'211' => array('varname' => 'adv_portal_moddir_notwritable', 'ptype' => '9000', 'text' => 
'Your modules directory is not writable. Please chmod your modules directory to 777 and try again.'),


// CP Home Page
'230' => array('varname' => 'vba_cmps', 'ptype' => '9', 'text' => 
'vBa CMPS'),
'231' => array('varname' => 'edit_modules', 'ptype' => '9', 'text' => 
'Edit Modules'),
'232' => array('varname' => 'edit_pages', 'ptype' => '9', 'text' => 
'Edit Pages'),
'233' => array('varname' => 'add_module', 'ptype' => '9', 'text' => 
'Add Module'),
'234' => array('varname' => 'add_page', 'ptype' => '9', 'text' => 
'Add Page'),
'235' => array('varname' => 'default_settings', 'ptype' => '9', 'text' => 
'Default Settings'),
'236' => array('varname' => 'download_upload_module', 'ptype' => '9', 'text' => 
'Download / Upload Module'),
'237' => array('varname' => 'quick_permissions_editor', 'ptype' => '9', 'text' => 
'Quick Permissions Editor')

);

// ########################## Settings ##############################
$mainsettings = array(

'global_navbar_replace' => array('title' => 'Navbar Replacements', 'description' => 'Here you may enter a list of filenames that should be prefixed with your Forum\'s URL.', 'value' => 
'memberlist.php
usercp.php
register.php
faq.php
calendar.php
search.php
login.php
forumdisplay.php
profile.php
private.php
subscription.php
member.php
online.php', 'optioncode' => 'textarea', 'displayorder' => '2', 'grouptitle' => 'adv_global'),

'global_footer_replace' => array('title' => 'Footer Replacements', 'description' => 'Here you may enter a list of filenames that may appear in your footer that should be prefixed with your Forum\'s URL.', 'value' => 
'archive
sendmessage.php', 'optioncode' => 'textarea', 'displayorder' => '3', 'grouptitle' => 'adv_global'),

'global_header_replace' => array('title' => 'Header Replacements', 'description' => 'Here you may enter a list of filenames that may appear in your header that should be prefixed with your Forum\'s URL.', 'value' => 
'', 'optioncode' => 'textarea', 'displayorder' => '1', 'grouptitle' => 'adv_global'),

'portal_news_archivepreview' => array('title' => 'Show Preview in Archive?', 'description' => 'This option will allow you to show a preview of the archived thread, the same as on the forumdisplay page.', 'value' => 
'1', 'optioncode' => 'yesno', 'displayorder' => '2', 'grouptitle' => 'adv_portal_newsarchive'),

'portal_threads_maxthreads' => array('title' => 'Number of Threads to Display', 'description' => 'The maximum number of latest threads that you would like to display.', 'value' => 
'10', 'optioncode' => '', 'displayorder' => '3', 'grouptitle' => 'adv_portal_latestthreads'),

'portal_threads_maxchars' => array('title' => 'Maximum Characters of Thread Title to Display', 'description' => 'The maximum number of characters that should be displayed before the rest of a thread\'s title is replaced by \'...\'. Set this to 0 to disable it.', 'value' => 
'25', 'optioncode' => '', 'displayorder' => '4', 'grouptitle' => 'adv_portal_latestthreads'),

'portal_threads_showdate' => array('title' => 'Show Date & Time', 'description' => 'Shows the time and date the thread was created.', 'value' => 
'1', 'optioncode' => 'yesno', 'displayorder' => '6', 'grouptitle' => 'adv_portal_latestthreads'),

'portal_news_enablearchive' => array('title' => 'Number of Archived News Posts to Display', 'description' => 'Set this to the number of news posts you would like to displayin the News Archive. Set this to 0 to disable the News Archive.', 'value' => 
'5', 'optioncode' => '', 'displayorder' => '1', 'grouptitle' => 'adv_portal_newsarchive'),

'portal_threads_showicon' => array('title' => 'Show Thread Icons', 'description' => 'Displays the icon that was selected for the thread.', 'value' => 
'1', 'optioncode' => 'yesno', 'displayorder' => '10', 'grouptitle' => 'adv_portal_latestthreads'),

'portal_threads_showsubscribed' => array('title' => 'Show Subscribed Icon', 'description' => 'Displays the \'subscribed\' icon next tothe thread title if a user is subscribed to that thread.', 'value' => 
'1', 'optioncode' => 'yesno', 'displayorder' => '11', 'grouptitle' => 'adv_portal_latestthreads'),

'portal_threads_showpreview' => array('title' => 'Show Preview of Threads', 'description' => 'This option will allow you to show a preview of the thread, the same as on the forumdisplay page.', 'value' => 
'1', 'optioncode' => 'yesno', 'displayorder' => '9', 'grouptitle' => 'adv_portal_latestthreads'),

'portal_threads_showforum' => array('title' => 'Show Forum', 'description' => 'This option will display the name of and a link to the forum that the post was made in.', 'value' => 
'1', 'optioncode' => 'yesno', 'displayorder' => '8', 'grouptitle' => 'adv_portal_latestthreads'),

'portal_welcome_newpms' => array('title' => 'Show Private Message Info', 'description' => 'Displays a user\'s private message info.', 'value' => 
'1', 'optioncode' => 'yesno', 'displayorder' => '3', 'grouptitle' => 'adv_portal_welcomeblock'),

'portal_threads_showrating' => array('title' => 'Show Thread Ratings', 'description' => 'Shows the thread\'s rating', 'value' => 
'1', 'optioncode' => 'yesno', 'displayorder' => '12', 'grouptitle' => 'adv_portal_latestthreads'),

'portal_threads_lastpost' => array('title' => 'Show Last Post Info', 'description' => 'This option will display the last poster and time at which the last post was made.', 'value' => 
'1', 'optioncode' => 'yesno', 'displayorder' => '7', 'grouptitle' => 'adv_portal_latestthreads'),

'portal_calendarid' => array('title' => 'Calendar to Display', 'description' => 'Please select which calendar you would like to display.', 'value' => 
'-1', 'optioncode' => 'calendarselect', 'displayorder' => '1', 'grouptitle' => 'adv_portal_calendar'),

'portal_threads_forumids' => array('title' => 'Recent Threads Forums', 'description' => 'Here you may select the forum(s) in which you would like to display recent threads from. To select more than one forum, hold down your \'ctrl\' key while selecting the forums with your mouse. Leave this option blank to select threads from all forums.', 'value' => 
'', 'optioncode' => 'forumselect', 'displayorder' => '2', 'grouptitle' => 'adv_portal_latestthreads'),

'portal_shownavbar' => array('title' => 'Enable Navbar', 'description' => 'This option will enable the vBulletin navbar on the page.', 'value' => 
'1', 'optioncode' => 'yesno', 'displayorder' => '6', 'grouptitle' => 'adv_portal_style'),

'portal_colspacing' => array('title' => 'Horizontal Spacing Between Columns', 'description' => 'This is the amount of space (in pixels) that is between the different columns.', 'value' => 
'15', 'optioncode' => '', 'displayorder' => '3', 'grouptitle' => 'adv_portal_style'),

'portal_rightcolwidth' => array('title' => 'Right Column Width', 'description' => 'The width (in pixels or percentage) of your right column.', 'value' => 
'175', 'optioncode' => '', 'displayorder' => '2', 'grouptitle' => 'adv_portal_style'),

'portal_leftcolwidth' => array('title' => 'Left Column Width', 'description' => 'The width (in pixels or percentage) of your left column.', 'value' => 
'175', 'optioncode' => '', 'displayorder' => '1', 'grouptitle' => 'adv_portal_style'),

'portal_blockbullet' => array('title' => 'Module Title Bullet', 'description' => 'Here you may enter any HTML code which you would like to appear next to the title of each block.', 'value' => 
'&raquo;', 'optioncode' => '', 'displayorder' => '5', 'grouptitle' => 'adv_portal_style'),

'portal_pagevar' => array('title' => 'Page Variable', 'description' => 'This is the variable that will be used in the URL to link to your new pages. For example, if this option is set to \'page\', then a link to a new page would look like this: http://yoursite.com/index.php?page=yourpage', 'value' => 
'page', 'optioncode' => '', 'displayorder' => '2', 'grouptitle' => 'adv_portal_main'),

'portal_welcome_newposts' => array('title' => 'Show New Posts', 'description' => 'This option will display the number of new posts since a user\'s last visit, along with a link to the posts.', 'value' => 
'1', 'optioncode' => 'yesno', 'displayorder' => '5', 'grouptitle' => 'adv_portal_welcomeblock'),

'portal_welcome_avatar' => array('title' => 'Show User\'s Avatar', 'description' => 'Displays the user\'s avatar.', 'value' => 
'1', 'optioncode' => 'yesno', 'displayorder' => '4', 'grouptitle' => 'adv_portal_welcomeblock'),

'portal_welcome_lastvisit_date' => array('title' => 'Last Visit Date Format', 'description' => 'The format that you would like the date of the user\'s last visit displayed in.', 'value' => 
'm-d-y', 'optioncode' => '', 'displayorder' => '1', 'grouptitle' => 'adv_portal_welcomeblock'),

'portal_welcome_lastvisit_time' => array('title' => 'Last Visit Time Format', 'description' => 'The format that you would like the time of the user\'s last visit displayed in.', 'value' => 
'g:i a', 'optioncode' => '', 'displayorder' => '2', 'grouptitle' => 'adv_portal_welcomeblock'),

'portal_applypermissions' => array('title' => 'Apply Forum Permissions', 'description' => 'When set to \'Yes\', this option will take your forum permissions into account and only show threads which the user has permission to view. ', 'value' => 
'', 'optioncode' => 'yesno', 'displayorder' => '6', 'grouptitle' => 'adv_portal_news'),

'portal_threadids' => array('title' => 'Threads', 'description' => 'Here you may select specific threads to be displayed with this module. Please note that this setting will override the setting below for a forum to pull these threads from.', 'value' => 
'', 'optioncode' => 'threadselect', 'displayorder' => '1', 'grouptitle' => 'adv_portal_poll'),

'portal_version' => array('title' => 'vBadvanced CMPS version', 'description' => 'Leave this setting alone.', 'value' => 
'2.0 RC1', 'optioncode' => 'hidden', 'displayorder' => '0', 'grouptitle' => 'adv_portal_main'),

'portal_outputglobals' => array('title' => 'Portal Output Global Variables', 'description' => 'If you have other hacks installed on your forums, it may be necessary to globalize some of the variables used in those hacks for use with the CMPS. You may enter a list of variables to globalize here. Separate each variable with a carrage return. Please note as well that it is NOT necessary to add the $ mark before the variable name.', 'value' => 
'', 'optioncode' => 'textarea', 'displayorder' => '3', 'grouptitle' => 'adv_portal_main'),

'portal_poll_direction' => array('title' => 'Polls Display Direction', 'description' => 'The direction in which the poll should be selected.', 'value' => 
'DESC', 'optioncode' => '<select name=\\"$name\\"> <option " . iif($setting[value] == \'ASC\', \'selected=\\"selected\\"\'). " value=\\"ASC\\">Ascending</option> <option " . iif($setting[value] == \'DESC\', \'selected=\\"selected\\"\'). " value=\\"DESC\\">Descending</option></select>', 'displayorder' => '7', 'grouptitle' => 'adv_portal_poll'),

'portal_news_allowreplies' => array('title' => 'Show Reply Info', 'description' => 'Displays the number of replies that have been made to each post.', 'value' => 
'1', 'optioncode' => 'yesno', 'displayorder' => '8', 'grouptitle' => 'adv_portal_news'),

'portal_threadids' => array('title' => 'Threads', 'description' => 'Here you may select specific threads to be displayed with this module. Please note that this setting will override the setting below for a forum to pull these threads from.', 'value' => 
'', 'optioncode' => 'threadselect', 'displayorder' => '1', 'grouptitle' => 'adv_portal_latestthreads'),

'portal_replaceadmin' => array('title' => 'Replace Admin CP Link', 'description' => 'This option will replace the \'Admin CP\' link in your footer template with a link to the CMPS admin file. If you have modified your admincp/index.php file to add the CMPS options you may turn this option off to have it link to the vBulletin Admin CP.', 'value' => 
'0', 'optioncode' => 'yesno', 'displayorder' => '4', 'grouptitle' => 'adv_portal_main'),

'portal_applypermissions' => array('title' => 'Apply Forum Permissions', 'description' => 'When set to \'Yes\', this option will take your forum permissions into account and only show threads which the user has permission to view. ', 'value' => 
'', 'optioncode' => 'yesno', 'displayorder' => '3', 'grouptitle' => 'adv_portal_poll'),

'portal_homeurl' => array('title' => 'CMPS URL', 'description' => 'The full URL to the CMPS file.', 'value' => 
'http://localhost/cmps_index.php', 'optioncode' => '', 'displayorder' => '1', 'grouptitle' => 'adv_portal_main'),

'portal_poll_orderby' => array('title' => 'Polls Display Order', 'description' => 'The order in which the poll should be selected.', 'value' => 
'dateline', 'optioncode' => '<select name=\\"$name\\"> <option " . iif($setting[value] == \'dateline\', \'selected=\\"selected\\"\'). " value=\\"dateline\\">Date Created</option> <option " . iif($setting[value] == \'votedate\', \'selected=\\"selected\\"\'). " value=\\"votedate\\">Laste Vote</option> <option " . iif($setting[value] == \'rand\', \'selected=\\"selected\\"\'). " value=\\"rand\\">Random</option> </select>', 'displayorder' => '6', 'grouptitle' => 'adv_portal_poll'),

'portal_news_showattachments' => array('title' => 'Enable Attachments', 'description' => 'Display attachments associated with each post.', 'value' => 
'1', 'optioncode' => 'yesno', 'displayorder' => '7', 'grouptitle' => 'adv_portal_news'),

'portal_news_showsignature' => array('title' => 'Show Signatures', 'description' => 'This option will show the poster\'s signature with the post. Note that the \'Show your signature\' option when making a post can still be used to disable signatures in selected posts.', 'value' => 
'1', 'optioncode' => 'yesno', 'displayorder' => '15', 'grouptitle' => 'adv_portal_news'),

'portal_news_maxposts' => array('title' => 'Maximum Number of Threads to Display', 'description' => 'The maximum number of threads to display. Set this option to 0 to show all.', 'value' => 
'3', 'optioncode' => '', 'displayorder' => '3', 'grouptitle' => 'adv_portal_news'),

'portal_news_maxchars' => array('title' => 'Maximum Characters to Display', 'description' => 'The maximum number of characters that you would like to display in a news post before it is replaced by the \'[read more]\' link. Set this option to \'0\' for no limit.', 'value' => 
'5000', 'optioncode' => '', 'displayorder' => '4', 'grouptitle' => 'adv_portal_news'),

'portal_news_forumid' => array('title' => 'News Forum(s)', 'description' => 'Here you may select the forum(s) in which you would like to display recent threads from in your news module. To select more than one forum, hold down your \'ctrl\' key while selecting the forums with your mouse.', 'value' => 
'', 'optioncode' => 'forumselect', 'displayorder' => '2', 'grouptitle' => 'adv_portal_news'),

'portal_news_showavatar' => array('title' => 'Show Avatars', 'description' => 'Displays the poster\'s avatar with each post.', 'value' => 
'1', 'optioncode' => 'yesno', 'displayorder' => '9', 'grouptitle' => 'adv_portal_news'),

'portal_news_showicon' => array('title' => 'Show Post Icons', 'description' => 'Displays the icon selected for each post.', 'value' => 
'1', 'optioncode' => 'yesno', 'displayorder' => '10', 'grouptitle' => 'adv_portal_news'),

'portal_news_showrating' => array('title' => 'Show Ratings', 'description' => 'Shows the rating of each post.', 'value' => 
'1', 'optioncode' => 'yesno', 'displayorder' => '11', 'grouptitle' => 'adv_portal_news'),

'portal_news_showprintable' => array('title' => 'Show Printable Version Link', 'description' => 'Displays the \'printable version\' icon with a link to allow users to quickly print the thread.', 'value' => 
'1', 'optioncode' => 'yesno', 'displayorder' => '13', 'grouptitle' => 'adv_portal_news'),

'portal_news_showsendfriend' => array('title' => 'Show Send to Friend Link', 'description' => 'Displays the \'send to friend\' icon to allow users to quickly email a link to the thread to friends.', 'value' => 
'1', 'optioncode' => 'yesno', 'displayorder' => '14', 'grouptitle' => 'adv_portal_news'),

'portal_news_enablehtml' => array('title' => 'Allow HMTL', 'description' => 'This allows HTML to be parsed in posts.', 'value' => 
'0', 'optioncode' => 'yesno', 'displayorder' => '18', 'grouptitle' => 'adv_portal_news'),

'portal_news_enablevbcode' => array('title' => 'Allow BB Code', 'description' => 'Allow BB code tags in posts.', 'value' => 
'1', 'optioncode' => 'yesno', 'displayorder' => '19', 'grouptitle' => 'adv_portal_news'),

'portal_news_enablevbimage' => array('title' => 'Allow [IMG] Code', 'description' => 'Allow the [IMG] code tag in posts.', 'value' => 
'1', 'optioncode' => 'yesno', 'displayorder' => '20', 'grouptitle' => 'adv_portal_news'),

'portal_news_enablesmilies' => array('title' => 'Allow Smilies', 'description' => 'Allows smilies in posts.', 'value' => 
'1', 'optioncode' => 'yesno', 'displayorder' => '21', 'grouptitle' => 'adv_portal_news'),

'portal_news_dateformat' => array('title' => 'Date & Time Format', 'description' => 'The format in which the date and time will presented in your news posts. Leave this blank if you do not wish to display the date/time a post was made.', 'value' => 
'M d, Y - g:i A', 'optioncode' => '', 'displayorder' => '5', 'grouptitle' => 'adv_portal_news'),

'portal_news_showsubscribed' => array('title' => 'Show Subscribed Thread Icon', 'description' => 'Displays the \'subscribed\' icon next to the thread title for threads which a user is subscribed to.', 'value' => 
'1', 'optioncode' => 'yesno', 'displayorder' => '12', 'grouptitle' => 'adv_portal_news'),

'portal_poll_forumid' => array('title' => 'Polls Forum(s)', 'description' => 'Here you may select the forum(s) in which you would like to display polls from. To select more than one forum, hold down your \'ctrl\' key while selecting the forums with your mouse.', 'value' => 
'', 'optioncode' => 'forumselect', 'displayorder' => '2', 'grouptitle' => 'adv_portal_poll'),

'portal_poll_allowreplies' => array('title' => 'Show Reply Info', 'description' => 'This option will show the \'Reply to this poll\' link on your poll giving users a link to quickly post a reply about the poll.', 'value' => 
'1', 'optioncode' => 'yesno', 'displayorder' => '4', 'grouptitle' => 'adv_portal_poll'),

'portal_poll_allowsmilies' => array('title' => 'Allow Smilies', 'description' => 'Allows smilies in poll options.', 'value' => 
'1', 'optioncode' => 'yesno', 'displayorder' => '5', 'grouptitle' => 'adv_portal_poll'),

'portal_welcome_rep' => array('title' => 'Show Reputation', 'description' => 'This option will allow you to display the user\'s current reputation image and reputation power.', 'value' => 
'0', 'optioncode' => 'yesno', 'displayorder' => '6', 'grouptitle' => 'adv_portal_welcomeblock'),

'portal_welcome_rank' => array('title' => 'Show User Rank', 'description' => 'This option will allow you to display the user\'s rank image.', 'value' => 
'0', 'optioncode' => 'yesno', 'displayorder' => '7', 'grouptitle' => 'adv_portal_welcomeblock'),

'portal_news_sticky' => array('title' => 'Show Sticky Posts on Top', 'description' => 'This option will allow threads that have been made sticky to appear at the top of the news section.', 'value' => 
'1', 'optioncode' => 'yesno', 'displayorder' => '16', 'grouptitle' => 'adv_portal_news'),

'portal_vspace' => array('title' => 'Verticle Spacing Between Modules', 'description' => 'The amount of space (in pixels) between the different columns.', 'value' => 
'15', 'optioncode' => '', 'displayorder' => '4', 'grouptitle' => 'adv_portal_style'),

'portal_collapsemods' => array('title' => 'Enable Collapsable Modules', 'description' => 'This option will allow your modules to be collapsed/expanded by your users.', 'value' => 
'1', 'optioncode' => 'yesno', 'displayorder' => '7', 'grouptitle' => 'adv_portal_style'),

'portal_news_legacy' => array('title' => 'Separate News Posts', 'description' => 'This option will display the posts separately rather than grouped together.', 'value' => 
'1', 'optioncode' => 'yesno', 'displayorder' => '17', 'grouptitle' => 'adv_portal_news'),

'portal_applypermissions' => array('title' => 'Apply Forum Permissions', 'description' => 'When set to \'Yes\', this option will take your forum permissions into account and only show threads which the user has permission to view. ', 'value' => 
'1', 'optioncode' => 'yesno', 'displayorder' => '5', 'grouptitle' => 'adv_portal_latestthreads'),

'portal_threadids' => array('title' => 'Threads', 'description' => 'Here you may select specific threads to be displayed with this module. Please note that this setting will override the setting below for a forum to pull these threads from.', 'value' => 
'', 'optioncode' => 'threadselect', 'displayorder' => '1', 'grouptitle' => 'adv_portal_news'),

'portal_navigation_excludepages' => array('title' => 'Pages to Exclude', 'description' => 'Here you may select any pages which you do not wish to display with this module.', 'value' => 
'', 'optioncode' => 'pageselect', 'displayorder' => '1', 'grouptitle' => 'adv_portal_navigation'),

'portal_navigation_mark1' => array('title' => 'Level 1 Mark', 'description' => 'This is what will be displayed next to a page\'s title if the page does not have a parent.', 'value' => 
'&raquo;', 'optioncode' => '', 'displayorder' => '2', 'grouptitle' => 'adv_portal_navigation'),

'portal_navigation_mark2' => array('title' => 'Level 2+ Mark', 'description' => 'This is what will be displayed next to a page\'s title if the page does have a parent.', 'value' => 
'&gt;', 'optioncode' => '', 'displayorder' => '3', 'grouptitle' => 'adv_portal_navigation'),

'portal_navigation_addpages' => array('title' => 'Additional Pages', 'description' => 'Here you may enter any additional pages which you would like to display a link to in this module. Simply enter the title of the page in the first column and the URL it should link to in the second.', 'value' => 
'', 'optioncode' => 'pageselect_add', 'displayorder' => '4', 'grouptitle' => 'adv_portal_navigation')

); 

// ###### Setting Groups #########
$sgarray = array(
	'adv_global' => 1,
	'adv_portal_main' => 2,
	'adv_portal_style' => 3
);

// ############################### Modules ####################################
$vba_modules = array(
1 => array('title' => 'Online Users', 'identifier' => 'onlineusers', 'filename' => 'onlineusers.php', 'inctype' => 'php_file', 'modcol' => '0', 'displayorder' => '4', 'templatelist' => 'adv_portal_onlineusers, forumhome_loggedinuser', 'userperms' => '', 'parent' => '', 'active' => '1', 'colspan' => '0', 'formcode' => '', 'cleanoutput' => '0', 'useshell' => '1', 'link' => '$vboptions[bburl]/online.php?$session[sessionurl]', 'options' => ''),

2 => array('title' => 'Buddy List', 'identifier' => 'buddylist', 'filename' => 'onlineusers.php', 'inctype' => 'php_file', 'modcol' => '0', 'displayorder' => '3', 'templatelist' => 'adv_portal_buddylistbits', 'userperms' => '', 'parent' => '', 'active' => '1', 'colspan' => '0', 'formcode' => '', 'cleanoutput' => '0', 'useshell' => '1', 'link' => '$vboptions[bburl]/profile.php?$session[sessionurl]do=editlist', 'options' => ''),

3 => array('title' => 'Mini Calendar', 'identifier' => 'calendar', 'filename' => 'minicalendar.php', 'inctype' => 'php_file', 'modcol' => '2', 'displayorder' => '1', 'templatelist' => 'adv_portal_calendar_week,adv_portal_calendar_header,adv_portal_calendar_day,adv_portal_calendar_day_other, calendar_smallmonth_day', 'userperms' => '', 'parent' => '', 'active' => '1', 'colspan' => '7', 'formcode' => '', 'cleanoutput' => '0', 'useshell' => '1', 'link' => '$vboptions[bburl]/calendar.php?$session[sessionurl]c=$mod_options[portal_calendarid]', 'options' => ''),

4 => array('title' => 'News', 'identifier' => 'news', 'filename' => 'news.php', 'inctype' => 'php_file', 'modcol' => '1', 'displayorder' => '3', 'templatelist' => 'adv_portal_newsbits, bbcode_quote, bbcode_php, postbit_attachment, postbit_attachmentimage, postbit_attachmentthumbnail', 'userperms' => '', 'parent' => '', 'active' => '1', 'colspan' => '0', 'formcode' => '', 'cleanoutput' => '0', 'useshell' => '1', 'link' => '', 'options' => ''),

5 => array('title' => 'Recent Threads', 'identifier' => 'latestthreads', 'filename' => 'latesttopics.php', 'inctype' => 'php_file', 'modcol' => '1', 'displayorder' => '4', 'templatelist' => 'adv_portal_latesttopicbits, adv_portal_latestthreads_head', 'userperms' => '', 'parent' => '', 'active' => '1', 'colspan' => '0', 'formcode' => '', 'cleanoutput' => '0', 'useshell' => '1', 'link' => '', 'options' => ''),

6 => array('title' => 'Stats', 'identifier' => 'stats', 'filename' => 'stats.php', 'inctype' => 'php_file', 'modcol' => '2', 'displayorder' => '3', 'templatelist' => 'adv_portal_stats', 'userperms' => '', 'parent' => '', 'active' => '1', 'colspan' => '0', 'formcode' => '', 'cleanoutput' => '0', 'useshell' => '1', 'link' => '', 'options' => ''),

7 => array('title' => 'Current Poll', 'identifier' => 'poll', 'filename' => 'currentpoll.php', 'inctype' => 'php_file', 'modcol' => '0', 'displayorder' => '6', 'templatelist' => 'adv_portal_poll, adv_portal_pollresult, adv_portal_polloption, adv_portal_polloption_multiple', 'userperms' => '', 'parent' => '', 'active' => '1', 'colspan' => '0', 'formcode' => '<form action="$vboptions[bburl]/poll.php" method="post">', 'cleanoutput' => '0', 'useshell' => '1', 'link' => '', 'options' => ''),

8 => array('title' => 'Quick Moderation', 'identifier' => '', 'filename' => 'moderate.php', 'inctype' => 'php_file', 'modcol' => '0', 'displayorder' => '2', 'templatelist' => 'adv_portal_moderation', 'userperms' => '', 'parent' => '', 'active' => '1', 'colspan' => '0', 'formcode' => '', 'cleanoutput' => '0', 'useshell' => '1', 'link' => '', 'options' => ''),

9 => array('title' => 'Welcome Block', 'identifier' => 'welcomeblock', 'filename' => 'welcomeblock.php', 'inctype' => 'php_file', 'modcol' => '1', 'displayorder' => '1', 'templatelist' => 'adv_portal_welcomeblock, postbit_reputation', 'userperms' => '', 'parent' => '', 'active' => '1', 'colspan' => '2', 'formcode' => '<script src="$vboptions[bburl]/clientscript/vbulletin_md5.js" type="text/javascript"></script> <form action="$vboptions[bburl]/login.php" method="post" onsubmit="md5hash(vb_login_password,vb_login_md5password)"> <input name="vb_login_md5password" type="hidden" /> <input name="s" type="hidden" value="" /> <input name="do" type="hidden" value="login" />', 'cleanoutput' => '0', 'useshell' => '1', 'link' => '$vboptions[bburl]/usercp.php?$session[sessionurl]', 'options' => ''),

10 => array('title' => 'Search Forums', 'identifier' => '', 'filename' => 'search', 'inctype' => 'template', 'modcol' => '0', 'displayorder' => '5', 'templatelist' => '', 'userperms' => '', 'parent' => '', 'active' => '1', 'colspan' => '0', 'formcode' => '<form action="$vboptions[bburl]/search.php" method="post" name="search"> <input name="s" type="hidden" value="" /> <input name="do" type="hidden" value="process" /> <input name="sortby" type="hidden" value="lastpost" /> <input name="forumchoice" type="hidden" value="0" />', 'cleanoutput' => '0', 'useshell' => '1', 'link' => '$vboptions[bburl]/search.php?$session[sessionurl]', 'options' => ''),

11 => array('title' => 'News Archive', 'identifier' => 'newsarchive', 'filename' => 'news.php', 'inctype' => 'php_file', 'modcol' => '1', 'displayorder' => '4', 'templatelist' => 'adv_portal_news_archive_head, adv_portal_news_archivebits', 'userperms' => '', 'parent' => 'news', 'active' => '1', 'colspan' => '5', 'formcode' => '', 'cleanoutput' => '0', 'useshell' => '1', 'link' => '', 'options' => ''),

12 => array('title' => 'Custom Page Content', 'identifier' => 'custompage', 'filename' => '', 'inctype' => 'custom', 'modcol' => '1', 'displayorder' => '2', 'templatelist' => '', 'userperms' => '', 'parent' => '', 'active' => '1', 'colspan' => '0', 'formcode' => '', 'cleanoutput' => '0', 'useshell' => '1', 'link' => '', 'options' => ''),

13 => array('title' => 'Today\'s Birthdays', 'identifier' => 'birthdays', 'filename' => 'birthdays.php', 'inctype' => 'php_file', 'modcol' => '2', 'displayorder' => '2', 'templatelist' => '', 'userperms' => '', 'parent' => '', 'active' => '1', 'colspan' => '0', 'formcode' => '', 'cleanoutput' => '0', 'useshell' => '1', 'link' => '', 'options' => ''),

14 => array('title' => 'Site Navigation', 'identifier' => 'navigation', 'filename' => 'navigation.php', 'inctype' => 'php_file', 'modcol' => '0', 'displayorder' => '1', 'templatelist' => 'adv_portal_navigation, adv_portal_navigationbits', 'userperms' => '', 'parent' => '', 'active' => '1', 'colspan' => '0', 'formcode' => '', 'cleanoutput' => '0', 'useshell' => '1', 'link' => '', 'options' => '')

);

// ########################### Start Install Table ############################
function print_install_table_start($title = '', $reqdo = '')
{
	global $scriptfile, $scriptname;

	if ($reqdo)
	{
		print_form_header($scriptfile, $reqdo);
	}
	else
	{
		echo '<form action="' . $scriptfile . '.php" method="post">';
		print_table_start();
	}

	if (!$title)
	{
		$title = 'vBadvanced ' . $scriptname . ' Install';
	}

	print_table_header($title);
}

// ############################ End Install Table #############################
function print_install_table_end()
{
	global $stepphrase, $scriptname, $step, $nextstep, $nextdo, $rebuildtemp, $nocontinue;

	print_description_row('<div style="padding:12px;">' . $stepphrase . '</div>');

	if (!$step)
	{
		print_radio_row('', 'do', array('install' => 'Begin the installation process.', 'upgrade' => 'Upgrade.', 'install_templates' => 'Reinstall the templates.', 'install_phrases' => 'Reinstall the phrases.', 'doimages' => 'Update your image paths.', 'uninstall' => 'Uninstall vBadvanced ' . $scriptname . '.'), 'install');
	}

	construct_hidden_code('step', iif($nextstep, $nextstep, $step + 1));

	if ($nextdo)
	{
		construct_hidden_code('do', $nextdo);
	}

	print_table_break();

	if ($rebuildtemp)
	{
		build_all_styles(0, 0);
	}

	if ($step == 'finished' OR $nocontinue)
	{
		print_table_footer();
	}
	else
	{
		print_submit_row('Continue', '');
	}
}

if ($_REQUEST['do'] == 'closeforums')
{
	$DB_site->query("UPDATE " . TABLE_PREFIX . "setting SET value = 0 WHERE varname = 'bbactive'");
	$DB_site->query("UPDATE " . TABLE_PREFIX . "setting SET value = '" . addslashes($_POST['closedmessage']) . "' WHERE varname = 'bbclosedreason'");

	build_options();

	print_cp_redirect($scriptfile . '.php?do=' . $_POST['redirect'] . '&step=' . $_POST['step']);
}

// ############################### Install ####################################
if (substr($_REQUEST['do'], '', 7) == 'install')
{
	globalize($_REQUEST, array('step' => STR_NOHTML));

	print_install_table_start();

	$only = substr($_REQUEST['do'], 8);

	if ($only)
	{
		$step = $only;
	}

	switch ($step)
	{
		case 1:

		  $DB_site->reporterror = 0;
			$check = $DB_site->query_first("SELECT varname FROM " . TABLE_PREFIX . "adv_setting WHERE varname = 'portal_version'");
			if ($check['varname'])
			{
				$stepphrase = 'vBadvanced ' . $scriptname . ' is already installed!';
				print_description_row('<div style="padding:12px;">' . $stepphrase . '</div>');
				print_table_footer();
				exit;
			}

			if ($vboptions['bbactive'])
			{
				print_description_row('Please turn your forums off before proceeding', '', 2, 'thead');
				print_textarea_row('Forums closed message:', 'closedmessage', $vboptions['bbclosedreason'], 4, 40, 1, 0);
				construct_hidden_code('redirect', 'install');
				$nextdo = 'closeforums';
			}
			else
			{
				print_cp_redirect($scriptfile . '.php?do=install&amp;step=2');
			}
		break;

		case 2:

			$DB_site->query("
			CREATE TABLE IF NOT EXISTS " . TABLE_PREFIX . "adv_setting (
			  varname varchar(100) NOT NULL default '',
			  grouptitle varchar(50) NOT NULL default '',
			  value mediumtext NOT NULL default '',
			  defaultvalue varchar(250) NOT NULL default '',
			  optioncode mediumtext NOT NULL,
			  displayorder smallint(3) unsigned NOT NULL default '0'
		  ) TYPE=MyISAM");
			
			$stepphrase = 'Created table adv_setting.<br />';
		
			$DB_site->query("
				CREATE TABLE IF NOT EXISTS " . TABLE_PREFIX . "adv_settinggroup (
				  grouptitle varchar(50) NOT NULL default '',
				  displayorder smallint(3) unsigned NOT NULL default '0',
				  PRIMARY KEY  (grouptitle)
				) TYPE=MyISAM
			");
		
			$stepphrase .= 'Created table adv_settinggroup.<br />';
		
			$DB_site->query("
				CREATE TABLE " . TABLE_PREFIX . "adv_modules (
				  modid smallint(5) unsigned NOT NULL auto_increment,
				  title varchar(100) NOT NULL default '',
				  identifier varchar(100) NOT NULL default '',
				  filename text NOT NULL,
				  inctype varchar(20) NOT NULL default '',
				  modcol smallint(3) unsigned NOT NULL default '0',
				  displayorder smallint(5) unsigned NOT NULL default '0',
				  templatelist varchar(255) NOT NULL default '',
				  userperms varchar(255) NOT NULL default '',
				  parent varchar(255) NOT NULL default '',
				  active smallint(3) unsigned NOT NULL default '1',
				  colspan smallint(3) unsigned NOT NULL default '0',
				  formcode text NOT NULL,
				  cleanoutput smallint(3) unsigned NOT NULL default '0',
				  useshell smallint(3) unsigned NOT NULL default '0',
				  link varchar(255) NOT NULL default '',
				  options text NOT NULL,
				  PRIMARY KEY  (modid),
				  KEY identifier (identifier)
				) TYPE=MyISAM
			");
		
			$stepphrase .= 'Created table adv_modules.<br />';
		
			$DB_site->query("
				CREATE TABLE " . TABLE_PREFIX . "adv_pages (
					pageid int(10) unsigned NOT NULL auto_increment,
					title varchar(100) NOT NULL default '',
					name varchar(100) NOT NULL default '',
					type varchar(50) NOT NULL default '',
					template text NOT NULL,
					parentid int(10) unsigned NOT NULL default '0',
					parentlist varchar(255) NOT NULL default '',
					modules mediumtext NOT NULL,
					advanced mediumtext NOT NULL,
					userperms varchar(255) NOT NULL default '',
					styleid smallint(5) unsigned NOT NULL default '0',
					active smallint(3) unsigned NOT NULL default '0',
					colspan smallint(3) unsigned NOT NULL default '0',
					formcode text NOT NULL,
					cleanoutput smallint(3) unsigned NOT NULL default '0',
					useshell smallint(34) unsigned NOT NULL default '0',
					custom_title varchar(255) NOT NULL default '',
					PRIMARY KEY  (pageid),
					UNIQUE KEY name (name)
				) TYPE=MyISAM
			");
		
			$stepphrase .= 'Created table adv_pages.<br /><br />';
		
			$DB_site->query("INSERT INTO " . TABLE_PREFIX . "datastore VALUES ('adv_portal_opts', '')");
			$DB_site->query("INSERT INTO " . TABLE_PREFIX . "datastore VALUES ('adv_modules', '')");
			$DB_site->query("INSERT INTO " . TABLE_PREFIX . "datastore VALUES ('adv_portal_page', '')");
		
			$stepphrase .= 'Added fields into the datastore table.<br /><br />';
		
			// Insert phrases
			$DB_site->query("ALTER TABLE " . TABLE_PREFIX . "language ADD phrasegroup_adv_portal MEDIUMTEXT NOT NULL");
			$DB_site->query("ALTER TABLE " . TABLE_PREFIX . "language ADD phrasegroup_adv_portal_cp MEDIUMTEXT NOT NULL");
		
			$DB_site->query("INSERT INTO " . TABLE_PREFIX . "phrasetype VALUES (569, 'adv_portal', 'vBadvanced CMPS', 3)");
			$DB_site->query("INSERT INTO " . TABLE_PREFIX . "phrasetype VALUES (570, 'adv_portal_cp', 'vBadvanced CMPS CP', 3)");


			foreach ($mainphrases AS $phrase)
			{
				insert_phrase($phrase['varname'], $phrase['text'], $phrase['ptype']);
			}
			
			build_language(-1);
		
			$stepphrase .= 'Added phrases.<br /><br />';

			// Insert templates
			foreach ($maintemplates AS $name => $content)
			{
				insert_template($name, $content);
			}

			$stepphrase = 'Added templates.<br /><br />';

			// Insert settings
			$checkglobal = $DB_site->query_first("SELECT grouptitle FROM " . TABLE_PREFIX . "adv_settinggroup WHERE grouptitle = 'adv_global'");
			
			if ($checkglobal['grouptitle'])
			{
				unset($sgarray['adv_global']);
			}
		
			foreach ($sgarray AS $grouptitle => $order)
			{
				$DB_site->query("INSERT INTO " . TABLE_PREFIX . "adv_settinggroup (grouptitle, displayorder) VALUES ('$grouptitle', '$order')");
			}
		
			foreach ($mainsettings AS $varname => $setting)
			{
				if ($varname == 'portal_threadids')
				{

					insert_setting($setting['title'], $setting['description'], $varname, $setting['value'], $setting['value'], $setting['optioncode'], $setting['displayorder'], 'adv_portal_latestthreads');

					insert_setting($setting['title'], $setting['description'], $varname, $setting['value'], $setting['value'], $setting['optioncode'], $setting['displayorder'], 'adv_portal_poll');

					insert_setting($setting['title'], $setting['description'], $varname, $setting['value'], $setting['value'], $setting['optioncode'], $setting['displayorder'], 'adv_portal_news');
				}
				else
				{
					insert_setting($setting['title'], $setting['description'], $varname, $setting['value'], $setting['value'], $setting['optioncode'], $setting['displayorder'], $setting['grouptitle']);
				}
			}
			build_adv_settings();
		
			$stepphrase .= 'Added settings.<br /><br />';
		
			// Insert modules
			foreach ($vba_modules AS $modid => $module)
			{
				$module['modid'] = $modid;
				$DB_site->query(fetch_query_sql($module, 'adv_modules'));
			}
		
			$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_modules SET userperms = '" . implode(',', array_keys($usergroupcache)) . "'");
		
			$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_modules SET userperms = '5,6' WHERE modid = 8");
		
			$module = array();
			$modids = array();
			$mods = $DB_site->query("SELECT * FROM " . TABLE_PREFIX . "adv_modules WHERE active = 1");
			while ($mod = $DB_site->fetch_array($mods))
			{
				$modids[] = $mod['modid'];
				$module[] = $mod;
			}
			build_datastore('adv_modules', serialize($module));
		
			$stepphrase .= 'Added modules.<br /><br />';
		
			$DB_site->query("INSERT INTO " . TABLE_PREFIX . "adv_pages (pageid, title, name, type, template, parentid, parentlist, modules, advanced, userperms, styleid, active, colspan, formcode, cleanoutput, useshell, custom_title) VALUES (1, 'Default / Homepage', 'home', 'module', '', 0, '1', '', '', '" . implode(',', (array_keys($usergroupcache))) . "', 0, 1, 0, '', 0, 0, '')");

			$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_pages SET modules = '" . implode(',', $modids) . "'");
		
			$stepphrase .= 'Added default/home page<br />';
			$rebuildtemp = true;
		break;

		case 3:

			$DB_site->reporterror = 0;
			$stepphrase = 'Adding index on user table.<br />';
			flush();
			$DB_site->query("ALTER TABLE " . TABLE_PREFIX . "user ADD INDEX (posts)");
	
		break;

		case 4:
			$DB_site->reporterror = 0;
			$stepphrase = 'Adding index on thread table.<br />';
			flush();
			$DB_site->query("ALTER TABLE " . TABLE_PREFIX . "thread ADD INDEX (lastpost)");
			
		break;

		case 5:
			$DB_site->reporterror = 0;
			$stepphrase = 'Adding index on post table.<br />';
			flush();
			$DB_site->query("ALTER TABLE " . TABLE_PREFIX . "post ADD INDEX (dateline)");
			$nextdo = 'doimages';

		break;

		case 'templates':

			foreach ($maintemplates AS $name => $content)
			{
				insert_template($name, $content);
			}

			$stepphrase = 'Templates updated.';
			$rebuildtemp = true;
			$nextdo = 'finished';

		break;
		
		case 'phrases':
			foreach ($mainphrases AS $phrase)
			{
				insert_phrase($phrase['varname'], $phrase['text'], $phrase['ptype']);
			}
			
			update_setting($varname, $setting['grouptitle'], $setting['title'], $setting['description'], '', $setting['value'], $setting['optioncode'], $setting['displayorder'], $setting['grouptitle']);

			build_language(-1);

			$stepphrase = 'Phrases updated.';
			$nextdo = 'finished';

		break;

		default:

			$stepphrase = '<b>Welcome to vBadvanced ' . $scriptname . ' version ' . $version . '.</b><br />Please select an action and click the \'Continue\' button.';
	}

	print_install_table_end();

}

if ($_REQUEST['do'] == 'finished')
{

	print_install_table_start();

	$DB_site->query("UPDATE " . TABLE_PREFIX . "setting SET value = 1 WHERE varname = 'bbactive'");

	build_options();

	@chmod('./modules', 0777);

	$stepphrase = 'vBadvanced ' . $scriptname . ' installation complete!<br /><br />Your forums have now been turned back on.<br /><br /><span style="color:red"><b>You should now delete this file from your admincp directory.<br />Leaving this file here could be a security risk!</b></span><br /><br /><a href="index.php"><b>Log Into Admin CP --&gt;</b></a>';
	$step = 'finished';

	print_install_table_end();

}

// ######################### Update Image Paths #######################
if ($_REQUEST['do'] == 'doimages')
{
	$perpage = 50;

	globalize($_REQUEST, array('type' => STR_NOHTML, 'pagenumber' => INT));

	if (!isset($type))
	{
		$type = 'icons';
	}

	function do_path_check($imageurl)
	{
		global $vboptions;

		if (@getimagesize($vboptions['bburl'] . '/' . $imageurl))
		{
			return 2;
		}
		if (@getimagesize('../' . $imageurl))
		{
			return 1;
		}
		if (@fopen($imageurl, "r"))
		{
			return 1;
		}

		return 0;
	}

	print_form_header($scriptfile, 'updateimages');
	print_table_header('Image Paths', 5);
	print_description_row('For this part of the installation process, we will attempt to update all of your images for use with vBadvanced. Please check each image here to make sure that it is displayed properly!<br /><br />
	In most cases, it should not be necessary to make any changes here. If the current image already has the correct path then the "Update" box beside it will not be checked since no changes are necessary. If the current image does not have the correct path, but this script is able to determine the correct path, then the "Update" box will be checked and the correct URL entered into the text box. If neither of the above applies, then you will see the entire box outlined in <font color="red">red</font> and it will be necessary to modify the path yourself.', 0, 5);
	print_table_break();

	if (!intval($pagenumber))
	{
		$pagenumber = 1;
	}

	$minlimit = intval(($pagenumber - 1) * $perpage + 1);
	$maxlimit = intval($pagenumber * $perpage);

	switch ($type)
	{
		case 'styleimages':

			$scache = array();
			$styleimages = $DB_site->query("
					SELECT * FROM " . TABLE_PREFIX . "template
					WHERE title IN('imgdir_attach', 'imgdir_button', 'imgdir_editor', 'imgdir_misc', 'imgdir_poll', 'imgdir_rating', 'imgdir_reputation', 'imgdir_statusicon', 'titleimage')
			");
			while ($simage = $DB_site->fetch_array($styleimages))
			{
				$scache["$simage[styleid]"]["$simage[title]"] = $simage['template'];
			}

			print_table_header('Update Style Paths', 5);	
			print_cells_row(array('Update?', 'Style Var', 'New URL', 'Image Check'), 'thead');
			$styles = $DB_site->query("SELECT styleid, title FROM " . TABLE_PREFIX . "style WHERE styleid != '-1' ORDER BY styleid, title");
			while ($style = $DB_site->fetch_array($styles))
			{
				print_table_header($style['title'], 4, 0, '', $stylevar['left']);

				if (empty($scache["$style[styleid]"]))
				{
					$scache["$style[styleid]"] = $scache['-1'];
				}

				foreach ($scache["$style[styleid]"] AS $varname => $imgpath)
				{
					$imgcheck = '';
					switch ($varname)
					{
						case 'imgdir_attach':
							$imgcheck = '/attach.gif';
							break;
						case 'imgdir_button':
							$imgcheck = '/reply_small.gif';
							break;
						case 'imgdir_editor':
							$imgcheck = '/quote.gif';
							break;
						case 'imgdir_misc':
							$imgcheck = '/stats.gif';
							break;
						case 'imgdir_poll':
							$imgcheck = '/bar6-l.gif';
							break;
						case 'imgdir_rating':
							$imgcheck = '/rating_5.gif';
							break;
						case 'imgdir_reputation':
							$imgcheck = '/reputation_pos.gif';
							break;
						case 'imgdir_statusicon':
							$imgcheck = '/forum_new.gif';
							break;
					}
					
					$pathcheck = do_path_check($imgpath . $imgcheck);

					switch ($pathcheck)
					{
						case 1:
							$paths['checked'] = '';
							$paths['class'] = fetch_row_bgclass();
							$paths['newpath'] = $imgpath;
							break;
		
						case 2:
							$paths['checked'] = 'checked="checked"';
							$paths['class'] = fetch_row_bgclass();
							$paths['newpath'] = $vboptions['bburl'] . '/' . $imgpath;
							break;
		
						case 0:
							$paths['class'] = 'redalert';
							$paths['newpath'] = $imgpath;
							break;
					}
		
					echo '<tr class="' . $paths['class'] . '"><td align="center"><input type="checkbox" name="updatepath[' . $style['styleid'] . '][' . $varname . ']" ' . $paths['checked'] . ' value="1" /></td><td>' . $varname . '</td><td align="center"><input name="stylepath[' . $style['styleid'] . '][' . $varname . ']" type="text" value="' . $paths['newpath'] . '" size="50" /></td><td align="center"><img src="' . $paths['newpath'] . $imgcheck . '" /></td></tr>';
				}
			}
			break;

		case 'icons':
			if ($vboptions['cleargifurl'] != 'clear.gif' AND $pagenumber == 1)
			{
				print_table_break();
				print_table_header('Clear Gif URL', 5);
				print_yes_no_row('It has been determined that your "cleargifurl" option has been changed from the default to "' . $vboptions['cleargifurl'] . '". This is <i>most likely</i> from a previous installation of vBadvanced. Since then a problem has been discovered with using full URL to this image. If you would like to change this option back to it\'s original value of "clear.gif", simply make sure that \'Yes\' is checked on the box to the right. If you do not wish to update this image, simply check \'No\' on the box to the right.', 'updateclear', 1);
				print_table_break();
			}
	
			if ($vboptions['showdeficon'] AND $pagenumber == 1)
			{
				print_table_break();
	
				print_table_header('Default Post Icon', 5);
	
				print_cells_row(array('Update?', 'Image Title', 'New URL', 'Current Image', 'New Image'), 'thead');
	
				$diconcheck = do_path_check($vboptions['showdeficon']);
	
				switch($diconcheck)
				{
					case 1:
					$checked = '';
					$class = fetch_row_bgclass();
					$newdiconpath = $vboptions['showdeficon'];
					break;
	
					case 2:
					$checked = 'checked="checked"';
					$class = fetch_row_bgclass();
					$newdiconpath = $vboptions['bburl'] . '/' . $vboptions['showdeficon'];
					break;
	
					case 0:
					$class = 'redalert';
					$newdiconpath = $vboptions['showdeficon'];
					break;
				}
	
				echo '<tr class="' . $class . '"><td align="center"><input type="checkbox" name="updatedicon" ' . $checked . ' value="1" /></td><td>deficon</td><td align="center"><input name="deficon" type="text" value="' . $newdiconpath . '" size="50" /></td><td align="center"><img src="' . $vboptions['showdeficon'] . '" /></td><td align="center"><img src="' . $newdiconpath . '" /></td></tr>';
				print_table_break();
			}
	
			print_table_header('Update Icon Paths', 5);
			print_cells_row(array('Update?', 'Image Title', 'New URL', 'Current Image', 'New Image'), 'thead');
	
			$counticons = $DB_site->query_first("SELECT COUNT(*) AS count FROM " . TABLE_PREFIX . "icon");
	
			$nextpage = $pagenumber + 1;
	
			if ($maxlimit > $counticons['count'])
			{
				$maxlimit = $counticons['count'];
				$nextpage = 1;
				$type = 'smilies';
			}
			if ($minlimit > $counticons['count'])
			{
			  $minlimit = $counticons['count'] - $perpage;
			}
	
			if ($minlimit < 0)
			{
			  $minlimit = 0;
			}
	
			$icons = $DB_site->query("
					SELECT *
					FROM " . TABLE_PREFIX . "icon
					ORDER BY iconid
					LIMIT " . ($minlimit - 1) . ", $perpage
			");
			while ($icon = $DB_site->fetch_array($icons))
			{
				construct_hidden_code('title[' . $icon['iconid'] . ']', $icon['title']);
				$icontitle = stripslashes($icon['title']);
	
				$iconcheck = do_path_check($icon['iconpath']);
	
				switch($iconcheck)
				{
					case 1:
					$checked = '';
					$class = fetch_row_bgclass();
					$newiconpath = $icon['iconpath'];
					break;
	
					case 2:
					$checked = 'checked="checked"';
					$class = fetch_row_bgclass();
					$newiconpath = $vboptions['bburl'] . '/' . $icon['iconpath'];
					break;
	
					case 0:
					$class = 'redalert';
					$newiconpath = $icon['iconpath'];
					break;
				}
	
				echo '<tr class="' . $class . '"><td align="center"><input type="checkbox" name="updateicon[' . $icon['iconid'] . ']" ' . $checked . ' value="1" /></td><td>' . $icontitle . '</td><td align="center"><input name="iconpath[' . $icon['iconid'] . ']" type="text" value="' . $newiconpath . '" size="50" /></td><td align="center"><img src="' . $icon['iconpath'] . '" /></td><td align="center"><img src="' . $newiconpath . '" /></td></tr>';
	
			}
			print_table_break();
			
			break;
			
		case 'smilies':

			print_table_header('Update Smilie Paths', 5);
	
	
			$countsmilies = $DB_site->query_first("SELECT COUNT(*) AS count FROM " . TABLE_PREFIX . "smilie");
	
			$nextpage = $pagenumber + 1;
	
			if ($maxlimit > $countsmilies['count'])
			{
				$maxlimit = $countsmilies['count'];
				$nextpage = 1;
				$type = 'styleimages';
			}
			if ($minlimit > $countsmilies['count'])
			{
			  $minlimit = $countsmilies['count'] - $perpage;
			}
	
			if ($minlimit < 0)
			{
			  $minlimit = 0;
			}
	
			print_cells_row(array('Update?', 'Image Title', 'New URL', 'Current Image', 'New Image'), 'thead');
	
			$smilies = $DB_site->query("
					SELECT * FROM " . TABLE_PREFIX . "smilie
					ORDER BY smilieid
					LIMIT " . ($minlimit - 1) . ", $perpage
			");
			while ($smilie = $DB_site->fetch_array($smilies))
			{
		  	construct_hidden_code('title[' . $smilie['smilieid'] . ']', $smilie['title']);
	
				$smiliecheck = do_path_check($smilie['smiliepath']);
	
				switch($smiliecheck)
				{
					case 1:
					$checked = '';
					$class = fetch_row_bgclass();
					$newsmiliepath = $smilie['smiliepath'];
					break;
	
					case 2:
					$checked = 'checked="checked"';
					$class = fetch_row_bgclass();
					$newsmiliepath = $vboptions['bburl'] . '/' . $smilie['smiliepath'];
					break;
	
					case 0:
					$class = 'redalert';
					$newsmiliepath = $smilie['smiliepath'];
					break;
				}
	
				echo '<tr class="' . $class . '"><td align="center"><input type="checkbox" name="updatesmilie[' . $smilie['smilieid'] . ']" ' . $checked . 'value="1" /></td><td>' . $smilie['title'] . '</td><td align="center"><input name="smiliepath[' . $smilie['smilieid'] . ']" type="text" value="' . $newsmiliepath . '" size="50" /></td><td align="center"><img src="' . $smilie['smiliepath'] . '" /></td><td align="center"><img src="' . $newsmiliepath . '" /></td></tr>';
		}

		print_table_break();
		break;
	}

	construct_hidden_code('type', $type);
	construct_hidden_code('nextpage', $nextpage);
	print_submit_row('Save', 'Reset', 5);
}

// ########################## Do Update Image Paths ####################
if ($_POST['do'] == 'updateimages')
{

	globalize($_POST, array('updateicon', 'iconpath', 'updatesmilie', 'smiliepath', 'updatepath', 'stylepath', 'type' => STR_NOHTML, 'nextpage' => INT));

	if (is_array($updatepath))
	{
		foreach ($updatepath AS $sid => $values)
		{
			foreach ($values AS $var => $update)
			{
				if ($update)
				{
					$newtemp = $stylepath["$sid"]["$var"];
					if ($checkit = $DB_site->query_first("SELECT title FROM " . TABLE_PREFIX . "template WHERE title = '$var' AND styleid = '$sid'"))
					{
						$DB_site->query("UPDATE " . TABLE_PREFIX . "template SET template = '$newtemp' WHERE title = '$var' AND styleid = '$sid'");
					}
					else
					{
						$DB_site->query("INSERT INTO " . TABLE_PREFIX . "template (styleid, title, template, templatetype, dateline, username) VALUES ('$sid', '$var', '$newtemp', 'stylevar', '" . TIMENOW . "', '$bbuserinfo[username]')");
					}
				}
			}
		}
		build_all_styles(0, 0, $scriptfile . '.php?do=install&step=finished');
	}

	// Update Icons
	if (is_array($updateicon))
	{
		echo '<b>Updating Icons...</b><br />';
		foreach ($iconpath AS $key => $val)
		{
			if ($updateicon[$key])
			{
				$DB_site->query("UPDATE " . TABLE_PREFIX . "icon SET iconpath = '$val' WHERE iconid = '$key'");
				echo '<span class="smallfont">Updated Image: ' . $title[$key] . ' (' . $val . ')</span><br />';
			}
		}
		build_image_cache('icon');
	}

	// Update Smilies
	if (is_array($updatesmilie))
	{
		echo '<br /><br /><b>Updating Smilies...</b><br />';
		foreach ($smiliepath AS $key => $val)
		{
			if ($updatesmilie[$key])
			{
				$DB_site->query("UPDATE " . TABLE_PREFIX . "smilie SET smiliepath = '$val' WHERE smilieid = '$key'");
				echo '<span class="smallfont">Updated Image: ' . $title[$key] . ' (' . $val . ')</span><br />';
			}
		}
		build_image_cache('smilie');
	}

	if ($_POST['updateclear'])
	{
		$DB_site->query("UPDATE " . TABLE_PREFIX . "setting SET value = 'clear.gif' WHERE varname = 'cleargifurl'");
		echo '<br />clear.gif updated.<br />';
	}

	if ($_POST['updatedicon'])
	{
		$DB_site->query("UPDATE " . TABLE_PREFIX . "setting SET value = '$deficon' WHERE varname = 'showdeficon'");
		echo '<br />showdeficon updated.<br />';
	}

	if ($_POST['updateclear'] OR $_POST['updatedicon'])
	{
		build_options();
	}

	if ($nextpage)
	{
		print_cp_redirect($scriptfile . '.php?do=doimages&type=' . $type . '&pagenumber=' . $nextpage);
	}
	else
	{
		print_cp_redirect($scriptfile . '.php?do=finished');
	}
}

// ########################### Upgrade ###############################
if ($_REQUEST['do'] == 'upgrade')
{
	globalize($_REQUEST, array('step' => INT));

	print_install_table_start('vBadvanced ' . $scriptname . ' Upgrade', 'upgrade');

	$vcheck = $DB_site->query_first("SELECT * FROM " . TABLE_PREFIX . "adv_setting WHERE varname = 'portal_version'");

	if ($vcheck['value'] == $version AND $step == 1)
	{
		$stepphrase = 'You are already running the current version of vBadvanced ' . $scriptname . '!';
		$nocontinue = 1;
	}
	else if (!$vcheck['value'])
	{
		$stepphrase =  'vBadvanced ' . $scriptname . ' is not installed! Please choose the option to install from the main page.';
		$nocontinue = 1;
	}
	else
	{
		switch ($step)
		{
			case 1:
				if ($vboptions['bbactive'])
				{
					print_description_row('Please turn your forums off before proceeding', '', 2, 'thead');
					print_textarea_row('Forums closed message:', 'closedmessage', $vboptions['bbclosedreason'], 4, 40, 1, 0);
					construct_hidden_code('redirect', 'upgrade');
					$nextdo = 'closeforums';
				}
				else
				{
					print_cp_redirect($scriptfile . '.php?do=upgrade&amp;step=2');
				}
				break;

			case 2:
				switch ($vcheck['value'])
				{
					case '1.0.0':

						$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_settinggroup SET displayorder = displayorder+1 WHERE grouptitle LIKE 'adv_portal%'");
			
						$checkglobal = $DB_site->query_first("SELECT grouptitle FROM " . TABLE_PREFIX . "adv_settinggroup WHERE grouptitle = 'adv_global'");
						
						if ($checkglobal['grouptitle'])
						{
							$DB_site->query("INSERT INTO " . TABLE_PREFIX . "adv_settinggroup VALUES ('adv_global', 1)");
							insert_phrase('settinggroup_adv_global', 'Global vBadvanced Settings', 5000);
						}


					case '1.0.1':

					// Alter module table
					$DB_site->query("
						ALTER TABLE " . TABLE_PREFIX . "adv_modules
						ADD parent varchar(255) NOT NULL default '',
						ADD colspan smallint(3) unsigned NOT NULL default '0',
				  	ADD formcode text NOT NULL,
				  	ADD cleanoutput smallint(3) unsigned NOT NULL default '0',
				  	ADD useshell smallint(3) unsigned NOT NULL default '0',
					  ADD link varchar(255) NOT NULL default '',
					  ADD options text NOT NULL,
						CHANGE filename filename text NOT NULL,
						CHANGE inctype inctype varchar(20) NOT NULL default ''
					");
					$stepphrase .= 'Altered adv_modules table to include new fields.<br />';
		
					// Alter page table
					$DB_site->query("
						ALTER TABLE " . TABLE_PREFIX . "adv_pages ADD type varchar(50) NOT NULL default '' AFTER name,
						ADD parentid int(10) unsigned NOT NULL default '0' AFTER template,
						ADD parentlist varchar(255) NOT NULL default '' AFTER template,
						ADD active smallint(3) unsigned NOT NULL default '0',
						ADD colspan smallint(3) unsigned NOT NULL default '0',
						ADD formcode text NOT NULL,
						ADD cleanoutput smallint(3) unsigned NOT NULL default '0',
						ADD useshell smallint(34) unsigned NOT NULL default '0',
						ADD custom_title varchar(255) NOT NULL default '',
						CHANGE template template text NOT NULL
					");
					$stepphrase .= 'Altered adv_pages table to include new fields.<br /><br />';
		
					$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_pages SET active = 1");
					$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_pages SET type = 'template' WHERE template != ''");
					$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_pages SET type = 'module' WHERE type = ''");

					$getpsetting = $DB_site->query("SELECT pageid, advanced FROM " . TABLE_PREFIX . "adv_pages WHERE advanced != ''");
					while ($psetting = $DB_site->fetch_array($getpsettings))
					{
						$psetting['advanced'] = unserialize($psetting['advanced']);
						$pagesettings = array();
						if (!empty($psetting['advanced']))
						{
							foreach ($psetting['advanced'] AS $varname => $value)
							{
								$sgroup = $DB_site->query_first("SELECT grouptitle FROM " . TABLE_PREFIX . "adv_setting WHERE varname = '$varname'");
								$pagesettings["$sgroup[grouptitle]"]["$varname"] = $value;
							}
						}
						$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_pages SET advanced = '" . serialize($pagesettings) . "' WHERE pageid = '$psetting[pageid]'");
					}

					$stepphrase = 'Updated page settings.<br /><br />';

					$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_modules SET inctype = 'php_file' WHERE inctype = 0");
					$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_modules SET inctype = 'template' WHERE inctype = 1");
					$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_modules SET inctype = 'custom' WHERE inctype = 2");
		
					$DB_site->query("INSERT INTO " . TABLE_PREFIX . "datastore VALUES ('adv_portal_page', '')");
		
					// Update module usergroup perms
					$getoldmods = $DB_site->query("SELECT modid, userperms FROM " . TABLE_PREFIX . "adv_modules");
					while ($oldmod = $DB_site->fetch_array($getoldmods))
					{
						if (!$oldmod['userperms'])
						{
							$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_modules SET userperms = '" . implode(',', array_keys($usergroupcache)) . "' WHERE modid = '$oldmod[modid]'");
						}
					}
		
					// Update Modules
					foreach ($vba_modules AS $modid => $module)
					{
						if (in_array($module['identifier'], array('navigation', 'birthdays')))
						{
							if ($module['identifier'] == 'navigation')
							{
								$module['active'] = 0;
							}
							$module['userperms'] = implode(',', array_keys($usergroupcache));
							$DB_site->query(fetch_query_sql($module, 'adv_modules'));
						}
						else
						{
		
							$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_modules SET identifier = '$module[identifier]', inctype = '$module[inctype]', templatelist = '$module[templatelist]', parent = '$module[parent]', colspan = '$module[colspan]', formcode = '$module[formcode]', useshell = '$module[useshell]', link = '$module[link]' WHERE filename = '$module[filename]' " . iif(in_array($module['filename'], array('news.php', 'onlineusers.php')), "AND identifier = '$module[identifier]'"));
						}
					}
	
					update_module_cache();
	
					$stepphrase .= 'Updated modules.<br /><br />';
		
					// Update settings
		
					$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_setting SET grouptitle = 'adv_portal_calendar' WHERE varname = 'portal_calendarid'");
					$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_setting SET grouptitle = 'adv_portal_style' WHERE varname IN('portal_shownavbar', 'portal_colspacing', 'portal_rightcolwidth', 'portal_leftcolwidth', 'portal_blockbullet')");
		
					$DB_site->query("INSERT INTO " . TABLE_PREFIX . "adv_settinggroup VALUES ('adv_portal_style', 3)");

					$DB_site->query("DELETE FROM " . TABLE_PREFIX . "template WHERE title IN('adv_portal', 'adv_portal_buddylist', 'adv_portal_buddylistbits', 'adv_portal_calendar', 'adv_portal_footer', 'adv_portal_latesttopicbits', 'adv_portal_latesttopics', 'adv_portal_moderation', 'adv_portal_newsbits', 'adv_portal_news_archive', 'adv_portal_news_archivebits', 'adv_portal_onlineusers', 'adv_portal_poll', 'adv_portal_polloption', 'adv_portal_polloption_multiple', 'adv_portal_pollresult', 'adv_portal_search', 'adv_portal_stats', 'adv_portal_welcomeblock')");
		
					$chpoll = $DB_site->query_first("SELECT value FROM " . TABLE_PREFIX . "adv_setting WHERE varname = 'portal_poll_forumid'");

					// Check poll value
					if ($chpoll['value'] == 'RAND')
					{
						$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_setting SET value = '" . implode(',', array_keys($forumcache)) . "' WHERE varname = 'portal_poll_forumid'");
						$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_setting SET value = 'rand' WHERE varname = 'portal_poll_orderby'");
					}
	

				case '2.0 Beta 1':

					insert_phrase('html_allows_html', 'An HTML Page will allow you to specify a HTML file on your server to include which will be displayed as the content for your \'Custom Page Content\' module.', 570);

				case '2.0 Beta 2':

					foreach ($mainsettings AS $varname => $setting)
					{
						$checksetting = $DB_site->query_first("SELECT varname FROM " . TABLE_PREFIX . "adv_setting WHERE varname = '$varname' AND grouptitle = '$setting[grouptitle]'");
						if ($checksetting['varname'])
						{
							update_setting($varname, $setting['grouptitle'], $setting['title'], $setting['description'], '', $setting['value'], $setting['optioncode'], $setting['displayorder'], $setting['grouptitle']);
		
						}
						else
						{
							if ($varname == 'portal_threadids')
							{
			
								insert_setting($setting['title'], $setting['description'], $varname, $setting['value'], $setting['value'], $setting['optioncode'], $setting['displayorder'], 'adv_portal_latestthreads');
			
								insert_setting($setting['title'], $setting['description'], $varname, $setting['value'], $setting['value'], $setting['optioncode'], $setting['displayorder'], 'adv_portal_poll');
			
								insert_setting($setting['title'], $setting['description'], $varname, $setting['value'], $setting['value'], $setting['optioncode'], $setting['displayorder'], 'adv_portal_news');
							}
							else
							{
								insert_setting($setting['title'], $setting['description'], $varname, $setting['value'], $setting['value'], $setting['optioncode'], $setting['displayorder'], $setting['grouptitle']);
							}
						}
					}

					$DB_site->query("UPDATE " . TABLE_PREFIX . "adv_setting SET value = '$version' WHERE varname = 'portal_version'");
		
					$stepphrase .= 'Updated version number.<br /><br />';
		
					build_adv_settings();
		
					$stepphrase .= 'Updated settings.<br /><br />';
	
					// Update Phrases
					foreach ($mainphrases AS $phrase)
					{
						insert_phrase($phrase['varname'], $phrase['text'], $phrase['ptype']);
					}
		
					build_language(-1);
	
					$stepphrase .= 'Updated phrases.<br /><br />';

					// Update Templates
					foreach ($maintemplates AS $name => $content)
					{
						insert_template($name, $content);
					}

					$rebuildtemp = true;

					$stepphrase .= 'Updated templates.';

					if (!in_array($vcheck['value'], array('1.0.0', '1.0.1')))
					{
						$nextdo = 'finished';
					}

				break;
				
				default:
					$stepphrase = 'You are running a version of vBadvanced CMPS prior to 1.0.0. Please upgrade to 1.0.0 or 1.0.1 before continuing.';
			}
		break;

		case 2:
			$DB_site->reporterror = 0;
			$stepphrase = 'Adding index on user table.<br />';
			flush();
			$DB_site->query("ALTER TABLE " . TABLE_PREFIX . "user ADD INDEX (posts)");
	
		break;

		case 3:
			$DB_site->reporterror = 0;
			$stepphrase = 'Adding index on thread table.<br />';
			flush();
			$DB_site->query("ALTER TABLE " . TABLE_PREFIX . "thread ADD INDEX (lastpost)");
			
		break;

		case 4:
			$DB_site->reporterror = 0;
			$stepphrase = 'Adding index on post table.<br />';
			flush();
			$DB_site->query("ALTER TABLE " . TABLE_PREFIX . "post ADD INDEX (dateline)");
			$nextdo = 'finished';
		break;
		}
	}

	print_install_table_end();

}

// ######################### Uninstall #########################
if ($_REQUEST['do'] == 'uninstall')
{
	globalize($_REQUEST, array('step' => STR));

	print_install_table_start('vBadvanced ' . $scriptname . ' Uninstall', 'uninstall');

	$DB_site->reporterror = 0;

	switch ($step)
	{
		case 1:
			$stepphrase = 'We\'re sorry you didn\'t like vBadvanced ' . $scriptname . '. Running this script will remove all changes that were made for vBadvanced ' . $scriptname . '.</div>';
		break;

		case 2:

			if ($vboptions['bbactive'])
			{
				print_description_row('Please turn your forums off before proceeding', '', 2, 'thead');
				print_textarea_row('Forums closed message:', 'closedmessage', $vboptions['bbclosedreason'], 4, 40, 1, 0);
				construct_hidden_code('redirect', 'uninstall');
				$nextdo = 'closeforums';
			}
			else
			{
				print_cp_redirect($scriptfile . '.php?do=uninstall&amp;step=3');
			}
		
		break;

		case 3:
			$DB_site->query("DROP TABLE " . TABLE_PREFIX . "adv_modules");
			$DB_site->query("DROP TABLE " . TABLE_PREFIX . "adv_pages");

			$stepphrase = 'Removed tables.<br /><br />';

			foreach ($mainphrases AS $phrase)
			{
				kill_phrase($phrase['varname'], $phrase['ptype']);
			}

			$DB_site->query("DELETE FROM " . TABLE_PREFIX . "phrasetype WHERE phrasetypeid IN(569,570)");

			$DB_site->query("ALTER TABLE " . TABLE_PREFIX . "language DROP phrasegroup_adv_portal");
			$DB_site->query("ALTER TABLE " . TABLE_PREFIX . "language DROP phrasegroup_adv_portal_cp");

			$stepphrase .= 'Removed phrases.<br /><br />';

			foreach ($maintemplates AS $name => $content)
			{
				kill_template($name);
			}

			$stepphrase .= 'Removed templates.<br /><br />';

			$DB_site->query("DELETE FROM " . TABLE_PREFIX . "adv_setting WHERE grouptitle LIKE 'adv_portal%'");
			$DB_site->query("DELETE FROM " . TABLE_PREFIX . "adv_settinggroup WHERE grouptitle LIKE 'adv_portal%'");

			$stepphrase .= 'Removed settings.<br /><br />';

			$DB_site->query("DELETE FROM " . TABLE_PREFIX . "datastore WHERE title IN('adv_portal_opts', 'adv_modules', 'adv_portal_page')");

			$stepphrase .= 'Removed fields from the datastore table.<br />';
	
		break;

		case 4:
			$stepphrase = 'Removed index added on user table.<br />';
			flush();
			$DB_site->query("ALTER TABLE " . TABLE_PREFIX . "user DROP INDEX (posts)");
	
		break;

		case 5:
			$stepphrase = 'Removed index added on thread table.<br />';
			flush();
			$DB_site->query("ALTER TABLE " . TABLE_PREFIX . "thread DROP INDEX (lastpost)");
			
		break;

		case 6:
			$stepphrase = 'Removed index added on post table.<br />';
			flush();
			$DB_site->query("ALTER TABLE " . TABLE_PREFIX . "post DROP INDEX (dateline)");
			$nextstep = 'finished';

		break;

		case 'finished':

			$DB_site->query("UPDATE " . TABLE_PREFIX . "setting SET value = 1 WHERE varname = 'bbactive'");
		
			build_options();

			$stepphrase = 'vBadvanced ' . $scriptname . ' Sucessfully Uninstalled.<br /> <br /><a href="index.php"><b>Log Into Admin CP --&gt;</b></a><br /><br /><a href="' . $scriptfile . '.php"><b>Click here to re-install --&gt;</b></a>';

		break;
	}

	print_install_table_end();
}

print_cp_footer();

?>