<?php

// Get our category & options caches
$categorycache = unserialize($datastore['gallery_c_cache']);
$galleryoptions = unserialize($datastore['adv_gallery_opt']);
if (!empty($vba_options))
{
    $vba_options = array_merge($vba_options, $galleryoptions);
}
else
{
    $vba_options = $galleryoptions;
}

// Create a list of fields to be shown in the imagebit
$showfield = explode(',', $vba_options['gallery_imagebitdisplay']);
if (!empty($showfield))
{
    $showfields = array();
    foreach ($showfield AS $field)
    {
        $showfields["$field"] = 1;
    }
}
// If you DON'T want of these fields to show then unremark
// the line in question by removing the "//" in the front it.
//$showfields['description'] = 0;
//$showfields['rating'] = 0;
//$showfields['user'] = 0;
//$showfields['dateline'] = 0;
//$showfields['views'] = 0;
//$showfields['dimensions'] = 0;
//$showfields['filesize'] = 0;
//$showfields['posts'] = 0;
//$showfields['lastpost'] = 0;

// Get our functions we need to work with
require_once('./includes/functions_bbcodeparse.php');
require_once('./includes/functions_gallery.php');
$show['category'] = true;
$query = fetch_image_fields();

// Turn the category field off/on in the display.
// $show['category'] = 0;

// Get a list of categories to be EXCLUDED from our query
if ($privatecatids = fetch_private_categories())
{
    $privcatids = 'images.catid NOT IN(' . $privatecatids . ') AND ';
}

// Get a random file
$show['randomimages'] = true;
$getrand = $DB_site->query("
    SELECT imageid, images.title, filename, thumbname, extension, images.catid $query[fields]
    FROM " . TABLE_PREFIX . "adv_gallery_images AS images
    $query[tables]
    WHERE $privcatids valid = 1
    ORDER BY RAND()
    LIMIT 1
");

// Yeah, this is the overkill method but by mimicking the logic in 
// index.php it should make it easier to work with multiple images
// if somebody wants to.
if ($DB_site->num_rows($getrand))
{
    while ($images = $DB_site->fetch_array($getrand))
    {
        $randomimagebits .= construct_imagebits($images);
    }
//    $randomimagebits .= construct_empty_cellbits($vba_options['gallery_columns']);
}
$DB_site->free_result($getrand);
unset($images);

// ### Update the template to have the path qualified ###
$randomimagebits = str_replace(array('"showimage.php', '"browseimages.php'), array('"' . $vba_options['gallery_url'] . '/showimage.php', '"' . $vba_options['gallery_url'] . '/browseimages.php'), $randomimagebits);   
// Slipstream the output into the content
eval('$home[$mods[\'modid\']][\'content\'] = "' . fetch_template('adv_portal_gallery_random') . '";');

?>