<?php
/*======================================================================*\
|| #################################################################### ||
|| # Yet Another Award System 1.0  by HacNho                         # ||
|| # Copyright (C) 2005 by HacNho, All rights reserved.               # ||
|| # ---------------------------------------------------------------- # ||
|| # For use with vBulletin Version 3.x                               # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| # Discussion and support available at                              # ||
|| # http://www.vbulletin.org/forum/showthread.php?t=78934            # ||
|| #################################################################### ||
\*======================================================================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// ##################### DEFINE IMPORTANT CONSTANTS #######################
define('NO_REGISTER_GLOBALS', 1);
define('THIS_SCRIPT', 'award.php');

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array();
$specialtemplates = array();

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
// require_once('./includes/adminfunctions_profilefield.php');

// ######################## CHECK ADMIN PERMISSIONS #######################
if (!can_administer('canadminusers'))
{
	print_cp_no_permission();
}

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

print_cp_header($vbphrase['award_manager']);

if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'manage';
}

// ###################### Start manager #######################
if ($_REQUEST['do'] == 'manage')
{

	$getawards = $DB_site->query("
		SELECT award_id, award_name, award_desc, award_icon_url, award_img_url
		FROM " . TABLE_PREFIX . "award
	");

	if ($DB_site->num_rows($getawards))
	{
		print_form_header();
		print_table_header(construct_phrase($vbphrase['awards'], $formname), 4);

		echo "
		<col align=\"center\" style=\"white-space:nowrap\"></col>
		<col align=\"center\" style=\"white-space:nowrap\"></col>
		<col width=\"70%\" align=\"$stylevar[left]\"></col>
		<col align=\"center\" style=\"white-space:nowrap\"></col>
		";

		print_cells_row(array(
			$vbphrase['award_icon'],
			$vbphrase['award_image'],
			"$vbphrase[award_name]/$vbphrase[award_description]",
			$vbphrase['controls']
		), 1, '', -1);
		
		while ($award = $DB_site->fetch_array($getawards))
		{
			echo "
			<tr>
				<td class=\"$bgclass\" align=\"center\"><img src=\"" . iif(substr($award[award_icon_url], 0, 7) != 'http://' AND substr($award[award_icon_url], 0, 1) != '/', '../', '') . "$award[award_icon_url]\" border=\"0\"></td>
				<td class=\"$bgclass\" align=\"center\"><img src=\"" . iif(substr($award[award_img_url], 0, 7) != 'http://' AND substr($award[award_img_url], 0, 1) != '/', '../', '') . "$award[award_img_url]\" border=\"0\"></td>
				<td class=\"$bgclass\"><strong>$award[award_name]
				<dfn>{$award[award_desc]}</dfn></strong></td>
				<td class=\"$bgclass\">" .
				construct_link_code($vbphrase['edit'], "award.php?$session[sessionurl]do=edit&amp;award_id=$award[award_id]") .
				construct_link_code($vbphrase['delete'], "award.php?$session[sessionurl]do=remove&award_id=$award[award_id]") .
				construct_link_code($vbphrase['manage'], "award.php?$session[sessionurl]do=awardusers&award_id=$award[award_id]") .
				"</td>
			</tr>";
				
		}
		$DB_site->free_result($getawards);
		print_table_footer(4, construct_button_code($vbphrase['add_new_award'], "award.php?$session[sessionurl]do=add"));

		print_table_footer();
	}
	else
	{
		print_stop_message('no_awards_defined');
	}

}
// ###################### Start add #######################
if ($_REQUEST['do'] == 'add')
{
	print_form_header('award', 'insert');

	print_table_header($vbphrase['add_new_award']);
	print_input_row($vbphrase['award_name'], 'award_name');
	print_input_row($vbphrase['award_description'], 'award_desc');
	print_input_row($vbphrase['award_icon_url'], 'award_icon_url');
	print_input_row($vbphrase['award_image_url'], 'award_img_url');

	print_submit_row($vbphrase['save']);
}

// ###################### Start insert #######################
if ($_POST['do'] == 'insert')
{
	globalize($_POST, array('award_name' => STR, 'award_desc' => STR, 'award_icon_url' => STR, 'award_img_url' => STR));

	if (empty($award_name))
	{
		print_stop_message('invalid_award_name_specified');
	}

	$DB_site->query("INSERT INTO " . TABLE_PREFIX . "award (award_name, award_desc, award_icon_url, award_img_url)	VALUES ('" . addslashes($award_name) . "','" . addslashes($award_desc) . "','" . addslashes($award_icon_url) . "','" . addslashes($award_img_url) . "')");

	define('CP_REDIRECT', 'award.php?do=manage');
	print_stop_message('saved_award_named_x_successfully', $title);
}

// ###################### Start edit #######################
if ($_REQUEST['do'] == 'edit')
{
	globalize($_REQUEST, array('award_id'));

	if (empty($award_id))
	{
		print_stop_message('no_awards_defined');
	}
		
	$award = $DB_site->query_first("SELECT award_name, award_desc, award_icon_url, award_img_url FROM " . TABLE_PREFIX . "award WHERE award_id = $award_id");

	print_form_header('award', 'doupdate');
	construct_hidden_code('award_id', $award_id);

	print_table_header(construct_phrase($vbphrase['x_y_id_z'], $vbphrase['award_name'], $award['award_name'], $award_id), 2, 0);
	print_input_row($vbphrase['award_name'], 'award_name', $award['award_name']);
	print_input_row($vbphrase['award_description'], 'award_desc', $award['award_desc']);
	print_input_row($vbphrase['award_icon_url'], 'award_icon_url', $award['award_icon_url']);
	print_input_row($vbphrase['award_image_url'], 'award_img_url', $award['award_img_url']);

	print_submit_row($vbphrase['save']);

}

// ###################### Start do update #######################
if ($_POST['do'] == 'doupdate')
{

	globalize($_POST, array('award_id', 'award_name', 'award_desc', 'award_icon_url', 'award_img_url'));

	if (empty($award_name))
	{
		print_stop_message('invalid_award_name_specified');
	}
	if (empty($award_id))
	{
		print_stop_message('no_awards_defined');
	}

	$DB_site->query("
		UPDATE " . TABLE_PREFIX . "award
		SET award_name = '" . addslashes($award_name) . "',
		award_desc = '" . addslashes($award_desc) . "',
		award_icon_url = '" . addslashes($award_icon_url) . "',
		award_img_url = '" . addslashes($award_img_url) . "'
		WHERE award_id = $award_id
	");

	define('CP_REDIRECT', 'award.php?do=manage');
	print_stop_message('saved_award_named_x_successfully', $award_name);

}
// ###################### Start Remove #######################

if ($_REQUEST['do'] == 'remove')
{

	print_form_header('award', 'kill');
	construct_hidden_code('award_id', $_REQUEST['award_id']);
	print_table_header($vbphrase['confirm_deletion']);
	print_description_row($vbphrase['are_you_sure_you_want_to_delete_this_award']);
	print_submit_row($vbphrase['yes'], '', 2, $vbphrase['no']);

}

// ###################### Start Kill #######################

if ($_POST['do'] == 'kill')
{
	globalize($_POST, array('award_id' => INT));

	$DB_site->query("DELETE FROM " . TABLE_PREFIX . "award WHERE award_id = $award_id");
	$DB_site->query("DELETE FROM " . TABLE_PREFIX . "award_user WHERE award_id = $award_id");

	define('CP_REDIRECT', 'award.php?do=manage');
	print_stop_message('deleted_award_successfully');
}


// ###################### Start issue award #######################
if ($_REQUEST['do'] == 'awardusers')
{
	globalize($_REQUEST, array('award_id'));
	
	if (empty($award_id))
	{
		print_stop_message('no_awards_defined');
	}

	$award = $DB_site->query_first("SELECT award_name, award_desc, award_icon_url, award_img_url FROM " . TABLE_PREFIX . "award WHERE award_id = $award_id");

	if (empty($award['award_name']))
	{
		print_stop_message('no_awards_defined');
	}
// print award information

   print_form_header();
   print_table_header(construct_phrase($vbphrase['x_y_id_z'], $vbphrase['award_name'], $award['award_name'], $award_id), 5, 0);

   echo "
   <col align=\"center\" style=\"white-space:nowrap\"></col>
   <col width=\"50%\" align=\"$stylevar[left]\"></col>
   <col align=\"center\" style=\"white-space:nowrap\"></col>
   <col align=\"center\" style=\"white-space:nowrap\"></col>
   <col align=\"center\" style=\"white-space:nowrap\"></col>
   ";

   print_cells_row(array(
           $vbphrase['award_name'],
           $vbphrase['award_description'],
           $vbphrase['award_icon'],
           $vbphrase['award_image'],
           $vbphrase['manage'],
   ), 1, '', -1);
   
  echo "
  <tr>
		<td class=\"$bgclass\"><strong>$award[award_name]</strong></td>
		<td class=\"$bgclass\"><dfn>{$award[award_desc]}</dfn></td>
		<td class=\"$bgclass\" align=\"center\"><img src=\"" . iif(substr($award[award_icon_url], 0, 7) != 'http://' AND substr($award[award_icon_url], 0, 1) != '/', '../', '') . "$award[award_icon_url]\" border=\"0\"></td>
		<td class=\"$bgclass\" align=\"center\"><img src=\"" . iif(substr($award[award_img_url], 0, 7) != 'http://' AND substr($award[award_img_url], 0, 1) != '/', '../', '') . "$award[award_img_url]\" border=\"0\"></td>
		<td class=\"$bgclass\">" .
				construct_link_code($vbphrase['edit'], "award.php?$session[sessionurl]do=edit&amp;award_id=$award_id") .
				construct_link_code($vbphrase['delete'], "award.php?$session[sessionurl]do=remove&award_id=$award_id") .
		"</td>

  </tr>";
	print_table_footer();


// print give award to user block

	print_form_header('award', 'dogiveaward');
	construct_hidden_code('award_id', $award_id);

	print_table_header("Give award to user", 2, 0);
	print_input_row($vbphrase['userid'], 'awarduserid');
	print_input_row($vbphrase['username'], 'awardusername');
	print_input_row($vbphrase['award_reason'], 'issue_reason');
	print_submit_row($vbphrase['save']);
	
// print remove user's award block

	print_form_header('award', 'doremoveaward');
	construct_hidden_code('award_id', $award_id);
	print_table_header($vbphrase['users_with_awards'], 4, 0);
   echo "
   <col align=\"center\" style=\"white-space:nowrap\"></col>
   <col width=\"50%\" align=\"$stylevar[left]\"></col>
   <col align=\"center\" style=\"white-space:nowrap\"></col>
   <col align=\"center\" style=\"white-space:nowrap\"></col>
   ";
	print_cells_row(array(
		$vbphrase['member'],
		$vbphrase['award_reason'],
		$vbphrase['award_time'],
		$vbphrase['remove'],
		), 1, '', -1);

		$awardusers = $DB_site->query("
			SELECT * 
			FROM " . TABLE_PREFIX . "award_user
			WHERE award_user.award_id=$award_id
		");
		while ($awarduser = $DB_site->fetch_array($awardusers))
		{
		construct_hidden_code('issue_id', $awarduser[issueid]);
		$awarduser1 = $DB_site->query_first("
			SELECT user.username
		FROM user
		WHERE (user.userid=$awarduser[userid])
		");	
			$cell = array();
			$cell[] = "<a href=\"user.php?$session[sessionurl]do=edit&amp;userid=$awarduser[userid]\" target=\"_user\"><b>$awarduser1[username]</b>";
			$cell[] = "$awarduser[issue_reason]";
			$cell[] = '<span class="smallfont">' . vbdate($vboptions['dateformat'], $awarduser['issue_time']) . ' ' . vbdate($vboptions['timeformat'], $awarduser['issue_time']) . '</span>';
			$cell[] = "
				<label for=\"d_$awarduser[issue_id]\"><input type=\"radio\" name=\"validate[$awarduser[issue_id]]\" value=\"-1\" id=\"d_$user[userid]\" tabindex=\"1\" />$vbphrase[delete]</label>
				<label for=\"i_$awarduser[issue_id]\"><input type=\"radio\" name=\"validate[$awarduser[issue_id]]\" value=\"0\" id=\"i_$user[userid]\" tabindex=\"1\" checked=\"checked\" />$vbphrase[ignore]</label>
			";
			print_cells_row($cell, 0, '', -4);
		}

    print_submit_row($vbphrase['remove'],0,4);
}

// ###################### Start do give award #######################
if ($_POST['do'] == 'dogiveaward')
{

	globalize($_POST, array('award_id', 'awarduserid','awardusername', 'issue_reason'));

	if (empty($awarduserid) AND empty($awardusername))
	{
		print_stop_message('please_complete_required_fields');
	}

	if (!empty($awarduserid))
	{
		$countusers = $DB_site->query_first("
			SELECT COUNT(*) AS users
			FROM " . TABLE_PREFIX . "user AS user
			WHERE user.userid = $awarduserid
		");
	
		if ($countusers['users'] > 1)
		{
			// show a user if there is just one found
			print_stop_message('invalid_ users_ specified');
		}
		else if ($countusers['users'] == 0)
		{
			// no users found!
			print_stop_message('no_users_matched_your_query');
		}
	}
	else if (!empty($awardusername))
	{
		$user = $DB_site->query_first("
			SELECT user.userid
			FROM " . TABLE_PREFIX . "user AS user
			WHERE user.username = '$awardusername'
		");
	$awarduserid = $user['userid'];
	}

	$DB_site->query("
		INSERT INTO " . TABLE_PREFIX . "award_user
		(award_id, userid, issue_reason, issue_time) 
				VALUES ( '$award_id', '$awarduserid', '$issue_reason', " . time() . ")
	");

	define('CP_REDIRECT', "award.php?do=awardusers&award_id=$award_id");
	print_stop_message('saved_award_named_x_successfully', $award_name);
}

// ###################### Start do REMOVE award #######################

if ($_POST['do'] == 'doremoveaward')
{
	globalize($_POST, array('award_id','issue_id' => INT));
	foreach($_POST['validate'] AS $issue_id => $status)
	{
	if ($status == -1)
	{
		$DB_site->query("DELETE FROM " . TABLE_PREFIX . "award_user WHERE issue_id = $issue_id");
	}
	}
	define('CP_REDIRECT', "award.php?do=awardusers&award_id=$award_id");
	print_stop_message('deleted_award_successfully');
}

// #############################################################################

print_cp_footer();

?>