/*
 * Decompiled with CFR 0.152.
 */
package org.cesar.inmotion.sea.basic;

import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import org.cesar.inmotion.sea.GameCanvas;
import org.cesar.inmotion.util.GameItem;

public class Fish
extends GameItem {
    private boolean dead = false;
    private boolean up = false;
    private byte cycles;
    public static final byte DIR_LEFT = -1;
    public static final byte DIR_RIGHT = 1;
    public static final byte DIR_NONE = 0;
    private byte DIR_ACTIVE = 1;
    private Image[] images;

    public Fish(Image[] imageArray, byte by) {
        super(0, 0, imageArray[0]);
        this.images = imageArray;
        this.setDirection(by);
        this.setXspeed(2);
        this.setYspeed(1);
        this.cycles = (byte)Math.abs(new Random().nextInt() % 10);
    }

    public void ressurect() {
        this.dead = false;
        this.setXspeed(1);
    }

    public boolean isDead() {
        return this.dead;
    }

    public void kill() {
        this.dead = true;
    }

    public void update() {
        if (this.getX() >= -50 && this.getX() <= GameCanvas.ScreenWidth - this.getImage().getWidth() + 50) {
            this.setX(this.getX() + this.DIR_ACTIVE * this.getXspeed());
            if (this.cycles == 10) {
                if (this.up) {
                    this.setY(this.getY() + this.getYspeed());
                } else {
                    this.setY(this.getY() - this.getYspeed());
                }
                this.cycles = 0;
                this.up = !this.up;
            }
            this.cycles = (byte)(this.cycles + 1);
        } else {
            this.setVisible(false);
        }
    }

    public void draw(Graphics graphics) {
        if (this.isVisible() && !this.dead) {
            graphics.drawImage(this.getImage(), this.getX(), this.getY(), 20);
        }
    }

    public byte getDirection() {
        return this.DIR_ACTIVE;
    }

    public void setDirection(byte by) {
        this.DIR_ACTIVE = by;
        switch (this.DIR_ACTIVE) {
            case -1: {
                this.setImage(this.images[0]);
                break;
            }
            case 1: {
                this.setImage(this.images[1]);
                break;
            }
            default: {
                this.setVisible(false);
                this.kill();
            }
        }
    }
}

