/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class GUI {
    public static int clipWidth;
    public static int clipHeight;
    public static int clipWidthHalf;
    public static int clipHeightHalf;
    public static int clipWidthOffset;
    public static int clipHeightOffset;
    public static int rohaPointer;
    private int hokomPointer = 0;
    public Rand rand = new Rand();

    public GUI(int w, int h) {
        clipWidthOffset = 0;
        clipHeightOffset = 0;
        clipWidth = w;
        clipHeight = h;
        if (clipWidth > 160) {
            clipWidth = 160;
            clipWidthOffset = w - 160 >> 1;
        }
        if (clipHeight > 192) {
            clipHeight = 192;
            clipHeightOffset = h - 192 >> 1;
        }
        clipWidthHalf = clipWidth >> 1;
        clipHeightHalf = clipHeight >> 1;
    }

    public void paint(Graphics g) {
        if (Game.state == Game.STATE_INTRO) {
            g.setColor(0xFFFFFF);
            g.fillRect(clipWidthOffset, clipHeightOffset, clipWidth, clipHeight);
            this.paintFullScreenImage(g, 1);
        } else if (Game.state == Game.STATE_ROHA) {
            if (Game.currentPlayer == 0) {
                this.paintRoha(g);
            }
            this.paintScores(g);
        } else if (Game.state == Game.STATE_HOKOM) {
            if (Game.currentPlayer == 0) {
                this.paintHokom(g);
            }
            this.paintScores(g);
        } else {
            this.paintScores(g);
        }
    }

    public void paintFullScreenImage(Graphics g, int which) {
        g.setColor(0xFFFFFF);
        g.fillRect(clipWidthOffset, clipHeightOffset, clipWidth, clipHeight);
        g.setColor(0);
        Font temp = g.getFont();
        if (which == 1) {
            g.drawImage(Images.intro, clipWidthHalf + clipWidthOffset, clipHeightHalf + clipHeightOffset, 3);
        } else {
            g.drawImage(Images.dot, clipWidthHalf + clipWidthOffset, clipHeightHalf + clipHeightOffset, 3);
        }
        g.setFont(Font.getFont((int)0, (int)0, (int)8));
        g.drawString("www.dotdesign.ws", clipWidthOffset, clipHeight + clipHeightOffset, 36);
        g.setColor(0xFFFFFF);
        g.setFont(temp);
    }

    public void paintRoha(Graphics g) {
        int currentRoha = Game.currentRoha;
        currentRoha = currentRoha < 5 ? 5 : ++currentRoha;
        g.setColor(0xFFFFFF);
        g.fillRect(clipWidthHalf - 30 + clipWidthOffset, clipHeightHalf - 7 + clipHeightOffset, 62, 14);
        g.setColor(0);
        g.drawImage(Images.numberb[0], clipWidthHalf - 25 + clipWidthOffset, clipHeightHalf + clipHeightOffset, 3);
        int i = currentRoha;
        while (i < 10) {
            g.drawImage(Images.numberb[i], clipWidthHalf - 15 + (i - 5) * 10 + clipWidthOffset, clipHeightHalf + clipHeightOffset, 3);
            ++i;
        }
        g.drawRect(clipWidthHalf - 30 + 10 * (rohaPointer - 4) + clipWidthOffset, clipHeightHalf - 6 + clipHeightOffset, 10, 12);
    }

    public void paintHokom(Graphics g) {
        g.setColor(0xFFFFFF);
        g.fillRect(clipWidthHalf - 28 + clipWidthOffset, clipHeightHalf - 2 + clipHeightOffset, 54, 15);
        g.setColor(0);
        int i = 0;
        while (i < 4) {
            g.drawImage(Images.hokom[i], clipWidthHalf - 26 + i * 13 + clipWidthOffset, clipHeightHalf + clipHeightOffset, 20);
            ++i;
        }
        g.setColor(0);
        g.drawRect(clipWidthHalf - 26 + 13 * this.hokomPointer + clipWidthOffset, clipHeightHalf + clipHeightOffset, 11, 11);
    }

    public void paintScores(Graphics g) {
        int i;
        g.setColor(14145215);
        g.drawRect(clipWidthOffset, clipHeightOffset, clipWidth - 1, clipHeight - 1);
        g.fillRect(clipWidthOffset, clipHeight - 6 + clipHeightOffset, clipWidth, 6);
        g.setColor(255);
        g.drawString(Integer.toString(Game.score0), 2 + clipWidthOffset, 14 + clipHeightOffset, 36);
        g.setColor(0xFF0000);
        g.drawString(Integer.toString(Game.score1), clipWidth - 2 + clipWidthOffset, 14 + clipHeightOffset, 40);
        if (Game.state == Game.STATE_PLAY || Game.state == Game.STATE_ROUND_WIN) {
            if (Game.rohaTeam == 0) {
                g.drawImage(Images.hokom[Game.hokom >> 4], 27 + clipWidthOffset, 2 + clipHeightOffset, 20);
            } else {
                g.drawImage(Images.hokom[Game.hokom >> 4], clipWidth - 27 + clipWidthOffset, 2 + clipHeightOffset, 24);
            }
            g.setColor(0);
            if (Game.rohaTeam == 0) {
                i = 0;
                while (i < Game.roha) {
                    g.drawRect(i * 7 + clipWidthOffset, clipHeight - 6 + clipHeightOffset, 5, 5);
                    ++i;
                }
                i = 0;
                while (i < 9 - Game.roha + 1) {
                    g.drawRect(clipWidth - i * 7 - 7 + clipWidthOffset, clipHeight - 6 + clipHeightOffset, 5, 5);
                    ++i;
                }
            } else {
                i = 0;
                while (i < Game.roha) {
                    g.drawRect(clipWidth - i * 7 - 7 + clipWidthOffset, clipHeight - 6 + clipHeightOffset, 5, 5);
                    ++i;
                }
                i = 0;
                while (i < 9 - Game.roha + 1) {
                    g.drawRect(i * 7 + clipWidthOffset, clipHeight - 6 + clipHeightOffset, 5, 5);
                    ++i;
                }
            }
        }
        g.setColor(255);
        i = 0;
        while (i < Game.wins0) {
            g.fillRect(i * 7 + 1 + clipWidthOffset, clipHeight - 5 + clipHeightOffset, 4, 4);
            ++i;
        }
        g.setColor(0xFF0000);
        i = 0;
        while (i < Game.wins1) {
            g.fillRect(clipWidth - (i * 7 - 1) - 7 + clipWidthOffset, clipHeight - 5 + clipHeightOffset, 4, 4);
            ++i;
        }
    }

    public void selectRoha() {
        Game.roha = rohaPointer == 4 ? 0 : rohaPointer;
        rohaPointer = 4;
    }

    public void setRohaPointer(int i, int currentRoha) {
        if ((rohaPointer += i) < 4) {
            rohaPointer = 9;
        } else if (rohaPointer > 9) {
            rohaPointer = 4;
        }
        if (currentRoha == 9) {
            rohaPointer = 4;
        } else if (rohaPointer <= currentRoha && rohaPointer != 4 && i == 1) {
            rohaPointer = currentRoha + 1;
        } else if (rohaPointer <= currentRoha && rohaPointer != 4 && i == -1) {
            rohaPointer = 4;
        }
    }

    public void selectHokom() {
        Game.hokom = this.hokomPointer << 4;
    }

    public void setHokomPointer(int i) {
        this.hokomPointer += i;
        if (this.hokomPointer < 0) {
            this.hokomPointer = 3;
        } else if (this.hokomPointer > 3) {
            this.hokomPointer = 0;
        }
    }

    static {
        rohaPointer = 4;
    }
}

