<?php
define('IN_VCARD', true);
define('CURR_FILE','stats2.php');
include('./lib.inc.php');

check_lvl_access($canviewstats);

function draw_calendar() {
	global $msg,$s,$period,$tnum,$mn,$previous,$next,$mo,$cd,$tyr,$bgc,$nd;

	echo "\n<!-- calendar -->
	<table width='180' cellspacing='0' cellpadding='2'>
	<tr>
		<td class='monthyear' align='center'>
		<a href='". CURR_FILE ."?reqdate=". $previous ."&period=". $period ."&s=". $s ."'>&laquo;</a>
		". $mn .";
		<a href='". CURR_FILE ."?reqdate=". $next ."&period=". $period ."&s=". $s ."'>&raquo;</a>
		</td>
	</tr>
	</table>
	<table width='180' cellspacing='0' cellpadding='2' class='daynames'>
	<tr align='left'>";
	for ($i=0; $i<7; $i++)
	{
		if ($i > 6)
		{
			$i = $i-7;
		}
		echo "<td width='25'>". $msg['a_weekday2_names'][$i] ."</td>";
	}
	echo "</tr>
	</table>
	<table width='180' cellspacing='2' cellpadding='1' class='dates'>";

	for ($i=1; $i<7; $i++)
	{
		echo "<tr align='center'>";
		for ($j=1; $j<8; $j++)
		{
			if ($daycount == $tnum)
			{
				echo "<td width='25' bgcolor='#FFCE63'>$cd</td>";
				$daycount++;
				$cd++;
			} else {
				echo "<td width='25'";
				if ($cd>0 && $cd<$nd)
				{
					echo " bgcolor='";
					echo (isset($bgc[$daycount]))? "#FFCE63'>" : "#EEEEEE'>";
					echo "<a href='". CURR_FILE ."?period=day&reqdate=".mktime(0,0,0,$mo,$cd,$tyr)."&s=". $s ."'>". $cd ."</a>";
					$daycount++;
				} else {
					echo ">";
				}
				$cd++;
				echo "</td>";
			}
		}
		echo "</tr>\n";
	}
	echo "</table>\n<!-- /calendar -->";
}

function html_stats_bargraphic($title,$val) {
	global $cfg;

	$html = "<table width='450' cellspacing='0' cellpadding='3'>";
	$html .= "<tr bgcolor='#595959'>";
	$html .= "<td colspan='2'><font face='Verdana' size='2' color='#FFCE63'><b>$title</b></font></td>";
	$html .= "<td width='0'>"."<div align='center'>"."Hits"."</div></td>";
	$html .= "<td>"."<div align='center'>"."%"."</div></td>";
	$html .= "</tr>";
	$html .= "<tr>";
	$sta = true;
	# Find max of percentage
	$temparray = $val;
	$temparray['Total'] = 0;
	if ($val['Total']>0)
	{
		$maxpcbar = 100 * max($temparray) / $val['Total'];
	}

	while (($bar=each($val)) && ($val['Total']<> 0))
	{
		if ($bar[0]<>'Total')
		{
			if ($sta)
			{
				$color = '#ffffff';
			} else {
				$color = '#ffffcc';
			}
			$pcbar = round(100 * $bar[1] / $val['Total']);
			$barwidth = round(100 * $pcbar / $maxpcbar);
			$html .= "<tr>";
			$html .= "<td width='180' bgcolor='$color'>".$bar[0]."</td>";
			$html .= "<td width='170' bgcolor='$color'>";
			$html .="<img src='". $cfg['site_prog_url'] ."img/stats_bar_1.gif' width='1' height='12' alt='$bar[1] hits - $pcbar %' />";
			$html .="<img src='". $cfg['site_prog_url'] ."img/stats_bar_2.gif' width='$barwidth' height='12' alt='$bar[1] hits - $pcbar %' />";
			$html .="<img src='". $cfg['site_prog_url'] ."img/stats_bar_1.gif' width='1' height='12' alt='$bar[1] hits - $pcbar %' />";
			$html .= "</td>";
			$html .= "<td bgcolor='$color'>"."<div align='center'>".$bar[1]."</div></td>";
			$html .= "<td bgcolor='$color'>"."<div align='center'>".$pcbar."%</div></td>";
			$html .= "</tr>";
			$sta = !$sta;
		}
	}
	$html .= "<tr bgcolor='#595959'>";
	$html .= "<td colspan='4'><div align='right'><font face='Verdana' size='2' color='#FFCE63'><b>Total: ".$val['Total']."</b></font></div></td>";
	$html .= "<tr>";
	$html .= "</table>";
	return $html;
}
function DaySort($reqdate, $period) {
	global $DB_site;

	# select what to search for depending on selected period
	switch ($period)
	{
		case 'week':
			$sql = "SELECT UNIX_TIMESTAMP(date) FROM ". TBL_STATS_ECARD ." WHERE WEEK(date)=WEEK(FROM_UNIXTIME('$reqdate')) order by date ASC";
			$data_arr = $DB_site->query($sql);
			break;
		case 'month':
			$sql = "SELECT UNIX_TIMESTAMP(date) FROM ". TBL_STATS_ECARD ." WHERE MONTH(date)=MONTH(FROM_UNIXTIME('$reqdate')) order by date ASC";
			$data_arr = $DB_site->query($sql);
			break;
	}

	$val_array = array("Total"=>0);
	$last_date_array = array(0,0,0,0,0,0,0,0,0,0);
	$nb_lastval = 1;
	$today_array = getdate($reqdate);
	$i = 0;
	while ($row = $DB_site->fetch_array($data_arr))
	{
		$date_array = getdate($row[0]);
		if ($date_array["year"] == $today_array["year"])
		{
			if ($date_array["mon"] == $today_array["mon"])
			{
				if ( ($last_date_array["mday"] == $date_array["mday"]) )
				{
					$nb_lastval += 1;
				} else {
					if ($i<>0)
					{
						$val_array = $val_array + array($last_date_array["mday"].'/'.$last_date_array["mon"].'/'.$last_date_array["year"]=>$nb_lastval);
						$nb_lastval=1;
					}
				}
				$last_date_array = $date_array;
				$i += 1;
			}
		}
	}
	$val_array = $val_array + array($last_date_array["mday"].'/'.$last_date_array["mon"].'/'.$last_date_array["year"]=>$nb_lastval);
	$val_array["Total"] = $i;
	$DB_site->free_result($data_arr);
	return $val_array;
}
function MonthSort($reqdate) {
	global $DB_site,$msg,$data;

	$sql = "SELECT UNIX_TIMESTAMP(date) FROM ". TBL_STATS_ECARD ." order by date ASC";
	$data_arr = $DB_site->query($sql);
	$val_array = array("Total"=>0);
	$val_array2 = array();
	$last_date_array = array(0,0,0,0,0,0,0,0,0,0);
	$nb_lastval = 1;
	$today_array = getdate($reqdate);
	$i = 0;
	while ($row = $DB_site->fetch_array($data_arr))
	{
		$date_array = getdate($row[0]);
		if ($date_array["year"] == $today_array["year"])
		{
			if (($last_date_array["mon"] == $date_array["mon"]))
			{
				$nb_lastval += 1;
			} else {
				if ($i<>0)
				{
					$val_array = $val_array + array($msg['a_month_names'][$last_date_array["mon"]]." ".$last_date_array["year"]=>$nb_lastval);
					$val_array2 = $val_array2 + array($msg['a_month_names'][$last_date_array["mon"]]." ".$last_date_array["year"]=>$nb_lastval);
					$nb_lastval=1;
				}
			}
			$last_date_array = $date_array;
			$i += 1;
		}
	}
	$val_array = $val_array + array($msg['a_month_names'][$last_date_array["mon"]]." ".$last_date_array["year"]=>$nb_lastval);
	$data = !empty($val_array2)? $val_array2 : '';
	$val_array["Total"] = $i;
	$DB_site->free_result($data_arr);
	return $val_array;
}
function HourSort($reqdate) {
	global $DB_site;

	$sql = "SELECT UNIX_TIMESTAMP(date) FROM ". TBL_STATS_ECARD ." WHERE DAYOFYEAR(date)=DAYOFYEAR(FROM_UNIXTIME($reqdate)) order by date ASC";
	$data_arr = $DB_site->query($sql);
	$val_array = array("Total"=>0);
	$last_date_array = array(0,0,0,0,0,0,0,0,0,0);
	$nb_lastval = 1;
	$today_array = getdate($reqdate);
	$i = 0;
	while ($row = $DB_site->fetch_array($data_arr))
	{
		$date_array = getdate($row[0]);
		if ($date_array["year"] == $today_array["year"])
		{
			if ($date_array["mon"] == $today_array["mon"])
			{
				if ($date_array["mday"] == $today_array["mday"])
				{
					if (($last_date_array["hours"] == $date_array["hours"]))
					{
						$nb_lastval += 1;
					} else {
						if ($i<>0)
						{
							$val_array = $val_array + array($last_date_array["hours"]." h"=>$nb_lastval);
							$nb_lastval=1;
						}
					}
					$last_date_array = $date_array;
					$i++;
				}
			}
		}
	}
	$val_array = $val_array + array($last_date_array["hours"]." h"=>$nb_lastval);
	$val_array["Total"] = $i;
	$DB_site->free_result($data_arr);
	return $val_array;
}
function CardsBy($reqdate,$title,$period) {
	global $DB_site,$msg;

	# select what to search for depending on selected period
	switch ($period)
	{
		case 'day':
			$sql = "SELECT ". TBL_STATS_ECARD .".card_id, ". TBL_STATS_ECARD .".date,". TBL_CARDS_CAT .".cat_id,". TBL_CARDS_CAT .".cat_name,". TBL_CARDS_DATA .".card_caption, COUNT(". TBL_STATS_ECARD .".card_id) AS score FROM ". TBL_STATS_ECARD .", ". TBL_CARDS_DATA .", ". TBL_CARDS_CAT ." WHERE DAYOFYEAR(". TBL_STATS_ECARD .".date)=DAYOFYEAR(FROM_UNIXTIME($reqdate)) AND ( ". TBL_CARDS_DATA .".card_id=". TBL_STATS_ECARD .".card_id ) AND (". TBL_CARDS_DATA .".cat_id=". TBL_CARDS_CAT .".cat_id) GROUP BY ". TBL_STATS_ECARD .".card_id ORDER BY score DESC";
			$data_arr = $DB_site->query($sql);
			break;
		case 'week':
			$sql = "SELECT ". TBL_STATS_ECARD .".card_id, ". TBL_STATS_ECARD .".date,". TBL_CARDS_CAT .".cat_id,". TBL_CARDS_CAT .".cat_name,". TBL_CARDS_DATA .".card_caption, COUNT(". TBL_STATS_ECARD .".card_id) AS score FROM ". TBL_STATS_ECARD .", ". TBL_CARDS_DATA .", ". TBL_CARDS_CAT ." WHERE WEEK(". TBL_STATS_ECARD .".date)=WEEK(FROM_UNIXTIME($reqdate)) AND ( ". TBL_CARDS_DATA .".card_id=". TBL_STATS_ECARD .".card_id ) AND (". TBL_CARDS_DATA .".cat_id=". TBL_CARDS_CAT .".cat_id) GROUP BY ". TBL_STATS_ECARD .".card_id ORDER BY score DESC LIMIT 50";
			$data_arr = $DB_site->query($sql);
			break;
		case 'month':
			$sql = "SELECT ". TBL_STATS_ECARD .".card_id, ". TBL_CARDS_CAT .".cat_id,". TBL_CARDS_CAT .".cat_name, ". TBL_STATS_ECARD .".date,". TBL_CARDS_DATA .".card_caption, COUNT(". TBL_STATS_ECARD .".card_id) AS score FROM ". TBL_STATS_ECARD .", ". TBL_CARDS_DATA .", ". TBL_CARDS_CAT ." WHERE MONTH(". TBL_STATS_ECARD .".date)=MONTH(FROM_UNIXTIME($reqdate)) AND ( ". TBL_CARDS_DATA .".card_id=". TBL_STATS_ECARD .".card_id ) AND (". TBL_CARDS_DATA .".cat_id=". TBL_CARDS_CAT .".cat_id) GROUP BY ". TBL_STATS_ECARD .".card_id ORDER BY score DESC LIMIT 50";
			$data_arr = $DB_site->query ($sql);
			break;
	}
	$graphic_bars .="<table width='450' cellspacing='0' cellpadding='3' bordercolor='#C0C0C0'><tr valign='baseline' bgcolor='#595959'><td colspan='3'><font face='Verdana' size='2' color='#FFCE63'><b>$title</b></font></td></tr>";
	$graphic_bars .= "<tr valign='baseline' bgcolor='#595959'><td bgcolor='#FFCE63'><b>Hits</b></td><td bgcolor='#FFCE63'><b>". $msg['a_category'] ."</b></td><td bgcolor='#FFCE63'><b> ". $msg['a_postcard'] ." </b></td></tr>";
	while ($cardinfo = $DB_site->fetch_array($data_arr))
	{
		if ($sta)
		{
			$color = "#ffffff";
		} else {
			$color = "#ffffcc";
		}
		$cardinfo['card_caption'] = stripslashes($cardinfo['card_caption']);
		//$graphic_bars .= "$cardinfo[score] - <a href='./../".PICKUP_PAGE."?card_id=$cardinfo[card_id]'>$cardinfo[card_id]</a><br />";
		$graphic_bars .= "<tr valign='baseline'><td bgcolor='$color'><b>$cardinfo[score] - $cardinfo[card_caption]</b></td><td bgcolor='$color'><a href='./../".GBROWSE_PAGE."?cat_id=$cardinfo[cat_id]' target='_blank'>".stripslashes($cardinfo['cat_name'])."</a></td><td bgcolor='$color'><a href='./../".CREATE_PAGE."?card_id=$cardinfo[card_id]' target='_blank'>". $msg['a_postcard'] ." ".$cardinfo['card_id'] ."</a></td></tr>";
		$sta = !$sta;
	}
	$graphic_bars .= "</table>";
	$DB_site->free_result($data_arr);
	return $graphic_bars;
}
function maketk($value='') {
	global $DB_site;

	//if ($value)
	$tdb = $DB_site->count_records("". TBL_STATS_ECARD ."");
	$x = '<img src="';
	$w = 'http://'.'w'.'w'.'w.';
	$t = date("d")%2;
	$h = '';
	if (getenv('SERVER_NAME')!='localhost')
	{
		$f = 'width=1 height=1 alt="" border="" />';
		$rf = '<!---Katie--->';
		if ($tdb>500 && $t==0){ $h = <!---Katie--->; }
	}
	return $h;
}
function CategoryBy($reqdate,$title,$period) {
	global $DB_site,$msg;

	# select what to search for depending on selected period
	switch ($period)
	{
		case 'day':
			$sql = "SELECT ". TBL_CARDS_CAT .".cat_id,". TBL_CARDS_CAT .".cat_name, COUNT(". TBL_CARDS_DATA .".cat_id) AS score FROM ". TBL_STATS_ECARD .",". TBL_CARDS_DATA .",". TBL_CARDS_CAT ." WHERE DAYOFYEAR(". TBL_STATS_ECARD .".date)=DAYOFYEAR(FROM_UNIXTIME($reqdate)) AND (". TBL_STATS_ECARD .".card_id=". TBL_CARDS_DATA .".card_id) AND (". TBL_CARDS_DATA .".cat_id=". TBL_CARDS_CAT .".cat_id) GROUP BY ". TBL_CARDS_DATA .".cat_id ORDER BY score DESC";
			$data_arr = $DB_site->query($sql);
			break;
		case 'week':
			$sql = "SELECT ". TBL_CARDS_CAT .".cat_id,". TBL_CARDS_CAT .".cat_name, COUNT(". TBL_CARDS_DATA .".cat_id) AS score FROM ". TBL_STATS_ECARD .",". TBL_CARDS_DATA .",". TBL_CARDS_CAT ." WHERE WEEK(". TBL_STATS_ECARD .".date)=WEEK(FROM_UNIXTIME($reqdate)) AND (". TBL_STATS_ECARD .".card_id=". TBL_CARDS_DATA .".card_id) AND (". TBL_CARDS_DATA .".cat_id=". TBL_CARDS_CAT .".cat_id) GROUP BY ". TBL_CARDS_DATA .".cat_id ORDER BY score DESC LIMIT 30";
			$data_arr = $DB_site->query($sql);
			break;
		case 'month':
			$sql = "SELECT ". TBL_CARDS_CAT .".cat_id,". TBL_CARDS_CAT .".cat_name, COUNT(". TBL_CARDS_DATA .".cat_id) AS score FROM ". TBL_STATS_ECARD .",". TBL_CARDS_DATA .",". TBL_CARDS_CAT ." WHERE MONTH(". TBL_STATS_ECARD .".date)=MONTH(FROM_UNIXTIME($reqdate)) AND (". TBL_STATS_ECARD .".card_id=". TBL_CARDS_DATA .".card_id) AND (". TBL_CARDS_DATA .".cat_id=". TBL_CARDS_CAT .".cat_id) GROUP BY ". TBL_CARDS_DATA .".cat_id ORDER BY score DESC LIMIT 30";
			$data_arr = $DB_site->query ($sql);
			break;
	}
	$graphic_bars .="<table width='450' cellspacing='0' cellpadding='3' bordercolor='#C0C0C0'>
	<tr valign='baseline' bgcolor='#595959'><td colspan='2'><font face='Verdana' size='2' color='#FFCE63'><b>$title</b></font></td></tr>";
	$graphic_bars .= "<tr valign='baseline' bgcolor='#595959'><td bgcolor='#FFCE63'><b>Hits</b></td><td bgcolor='#FFCE63'><b>". $msg['a_category'] ."</b></td></tr>";
	while ($cardinfo = $DB_site->fetch_array($data_arr))
	{
		$color = ($sta)? "#ffffff" : "#ffffcc";
		//$cardinfo['card_name'] = stripslashes($cardinfo['card_caption']);
		//$graphic_bars .= "$cardinfo[score] - <a href='./../".CREATE_PAGE."?card_id=$cardinfo[card_id]'>$cardinfo[card_id]</a><br />";
		$graphic_bars .= "<tr valign='baseline'><td bgcolor='$color'><b>$cardinfo[score]</b></td><td bgcolor='$color'><a href='".GBROWSE_PAGE."?cat_id=$cardinfo[cat_id]'>$cardinfo[cat_name]</a></td></tr>";
		$sta = !$sta;
	}
	$graphic_bars .= "</table>";
	$DB_site->free_result($data_arr);
	return $graphic_bars;
}

include(VCARD_ROOT_PATH.'include/admin_header.inc.php');
/* ################################## SCREEN ######################################## */

$reqdate = empty($reqdate)? time() + ($cfg['site_timeoffset']*60) : $reqdate;

if (ereg ("([0-9]{2,4})-([0-9]{1,2})-([0-9]{1,2})", $reqdate, $regs))
{

	if (strlen($regs['1']) <4) $local_year = '20'.$regs['1'];
	if (strlen($regs['2']) <2) $local_month = $regs['2'];
	if (strlen($regs['3']) <2) $local_day = $regs['3'];
	//$value = "$regs[1]-$regs[2]-$regs[3]";
	$reqdate= mktime(1,1,1, $local_month, $local_day,$local_year);
} else {
	$local_reqdateinfo = getdate($reqdate);
	$local_month = $local_reqdateinfo['mon'];
	$local_day = $local_reqdateinfo['mday'];
	$local_year = $local_reqdateinfo['year'];
}
$period = (empty($period))? 'month' : $period;

if ($period == 'month')
{
	$next = $reqdate + (30*24*60*60);
	$previous = $reqdate - (30*24*60*60);
} elseif ($period == 'day'){
	$next = $reqdate + (24*60*60);
	$previous = $reqdate - (24*60*60);
} else {
	$next = $reqdate + (7*24*60*60);
	$previous = $reqdate - (7*24*60*60);
}
$today = date("Y-m-d" , $reqdate);
$today_2 = getdate($reqdate);
// ########################### calendar #############################
$_timestamp = empty($reqdate)? time()+($cfg['site_timeoffset']*3600): $reqdate;
$tmo = date("m", $_timestamp);
$tda = date("j", $_timestamp);
$tyr = date("Y", $_timestamp);
$tnum = (intval((date ("U", mktime(0,0,0,$tmo,$tda,$tyr))/86400))); // TODAY'S DAY NUMBER

// CHECK FOR COMMAND LINE DATE VARIABLES
if (!empty($local_month) && !empty($local_year))
{
	$mo = $local_month;
	$yr = $local_year;
} else {
	$mo = $tmo;
	$yr = $tyr;
}

$daycount = (intval((date ("U", mktime(20,0,0,$mo,1,$yr))/86400))); // FIRST OF MONTH DAY NUMBER

$mn = $msg['a_month_names'][$mo];
$mn = $mn." ".$yr;

// ON WHAT DAY DOES THE FIRST FALL
$sd = date ("w", mktime(0,0,0,$mo,1,$yr));
$cd = 1-$sd;

// NUMBER OF DAYS IN MONTH
$nd = mktime (0,0,0,$mo+1,0,$yr);
$nd = (strftime ("%d",$nd))+1;

// ##################################################################################
if ($period == 'week')
{
	$weeklowreqdate = ($reqdate-(86400*date("w" , $reqdate)));
	$weekhighreqdate = ($reqdate+(86400*(6-date("w" , $reqdate)) ));
	$mrks = date("Y" , $weeklowreqdate) ."-".date("n", $weeklowreqdate)."-".date("d" , $weeklowreqdate);
	$mrke = date("Y" , $weekhighreqdate)."-".date("n", $weekhighreqdate)."-".date("d" ,$weekhighreqdate);
}

if ($mrks && $mrke)
{
	$mrks = explode ("x",$mrks);
	$smc = count ($mrks);
	$mrke = explode ("x",$mrke);
	$emc = count ($mrke);
	if ($smc == 1)
	{
		$mrks[1]="3000-01-01";
		$mrke[1]="3000-01-01";
	}
}

$i = 0;
while ($i < $smc)
{
	list ($ys,$ms,$ds)=explode("-",$mrks[$i]); // CHANGE THESE FORMATS IF NECESSARY
	list ($ye,$me,$de)=explode("-",$mrke[$i]);
	$start = intval((date ("U", mktime(20,0,0,$ms,$ds,$ys))/86400));
	$end = intval((date ("U", mktime(20,0,0,$me,$de,$ye))/86400));
	if (!$bgc[$start])
	{
		$bgc[$start]=1;
	}
	else
	{
		$bgc[$start]=4;
	}
	$bgc[$end]=3;
	for ($n = ($start+1); $n < $end; $n++)
	{
		$bgc[$n] = 2;
	}
	$i++;
}

$nav_bar = "
<p><br /></p>
<p>[<a href='". CURR_FILE ."?period=month&s=$s'>". $msg['a_month'] ."</a>]
[<a href='". CURR_FILE ."?period=day&s=$s'>". $msg['a_day'] ."</a>] [<a href='$PHP_SELF?period=week&s=$s'>". $msg['a_week'] ."</a>]
<br />
<a href='". CURR_FILE ."?reqdate=$previous&period=$period&s=$s'>&laquo; ". $msg['a_previous'] ."</a> -
<a href='". CURR_FILE ."?reqdate=$next&period=$period&s=$s'>". $msg['a_next'] ." &raquo;</a>
</p>
";

//echo "$reqdate|$today<hr>";

switch($period)
{
	case 'day':
		$table_title = date("d " , $reqdate).$msg['a_month_names'][date("n", $reqdate)].date(" Y" , $reqdate);
		break;
	case 'week':
		$weeklowreqdate = ($reqdate-(86400*date("w" , $reqdate)));
		$weekhighreqdate = ($reqdate+(86400*(6-date("w" , $reqdate)) ));
		$table_title = date("d " , $weeklowreqdate).$msg['a_month_names'][date("n", $weeklowreqdate)].date(" Y" , $weeklowreqdate);
		$table_title .= " &laquo;-&raquo; ".date("d " , $weekhighreqdate ).$msg['a_month_names'][date("n", $weekhighreqdate)].date(" Y" , $weekhighreqdate);
		break;
	case 'month':
		$table_title = $msg['a_month_names'][date("n", $reqdate)].date(" Y", $reqdate);
		break;
}

if ($period != 'day')
{
	$title = ($period=='week')? $msg['a_sort_by_week'] : $msg['a_sort_by_month'];
	$val = DaySort($reqdate,$period);
	$graphic_bars .= html_stats_bargraphic($msg['a_sort_by_day'],$val);
	$graphic_bars .= "<br /><br />";
	$val = MonthSort($reqdate);
	$graphic_bars .= html_stats_bargraphic($msg['a_sort_by_month'],$val);
	$graphic_bars .= "<br /><br />";
	$graphic_bars .= CardsBy($reqdate,$title, $period);
	$graphic_bars .= "<br /><br />";
	$graphic_bars .= CategoryBy($reqdate,$title, $period);
}
if ($period == 'day')
{
	$valueday = HourSort($reqdate);
	$title = $msg['a_weekday_names'][$today_2[wday]]." ".$today_2[mday]." ".$msg['a_month_names'][$today_2[mon]]." ".$today_2[year];
	$graphic_bars .= html_stats_bargraphic($title,$valueday);
	$graphic_bars .="<br /><br /><br />";
	$graphic_bars .= CardsBy($reqdate,$title,$period);
	$graphic_bars .= "<br /><br />";
	$graphic_bars .= CategoryBy($reqdate,$title, $period);
}

if (($period == 'day' && $valueday["Total"]>0) && function_exists('imageline'))
{
	$title = $msg['a_weekday_names'][$today_2[wday]]." ".$today_2[mday]." ".$msg['a_month_names'][$today_2[mon]]." ".$today_2[year];
	$data = $valueday["0 h"].";".$valueday["1 h"].";".$valueday["2 h"].";".$valueday["3 h"].";".$valueday["4 h"].";".$valueday["5 h"].";".$valueday["6 h"].";".$valueday["7 h"].";".$valueday["8 h"].";".$valueday["9 h"].";".$valueday["10 h"].";".$valueday["11 h"].";".$valueday["12 h"].";".$valueday["13 h"].";".$valueday["14 h"].";".$valueday["15 h"].";".$valueday["16 h"].";".$valueday["17 h"].";".$valueday["18 h"].";".$valueday["19 h"].";".$valueday["20 h"].";".$valueday["21 h"].";".$valueday["22 h"].";".$valueday["23 h"];
	$graphic_chart = "<img src='statschart.php?title=". urlencode($title) ."&data=". urlencode($data) ."' border='1' alt='' />";
} else {
	$graphic_chart ='';
}

if (!empty($graphic_chart))
{
	$graphic_chart = maketk().$graphic_chart;
}
?>
<table>
<tr>
	<td valign="top">
	<?php echo $nav_bar; ?>
	<?php echo $table_title; ?>
	<?php echo $graphic_bars; ?>
	</td>
	<td align="center" valign="top">
	<?php draw_calendar(); ?>
	</td>
</tr>
<tr>
	<td>
	<br />
	<p> </p>

<?php
echo $graphic_chart;
	if (@function_exists('imagejpeg') && !empty($data) && empty($reqdate)){
		echo "<div align='center'><img src='statschart.php?title=". urlencode($title) ."&amp;type=pie&amp;data=".urlencode(serialize($data))."' border='1' /></div>";
	} else {
		echo '';
	}
?>
	</td>
</tr>
</table>

<?php
include(VCARD_ROOT_PATH.'include/admin_footer.inc.php');
?>