<?

class ValidateInput
{

	private $validType;
 	private $checkXss;
 	private	$checkSql;
 	private $strip_tags;
 	private $strip_js;

	public function __construct ($validType, $checkXss, $checkSql, $strip_tags, $strip_js)
	{

		$this->validType 		= $validType;
		$this->checkXss	 		= $checkXss;
		$this->checkSql	 		= $checkSql;
		$this->strip_tags 		= $strip_tags;
		$this->strip_js 		= $strip_js;

	}


	public function CleanInput ($val,$type = '')
	{

		if(in_array($type,$this->validType) OR $type == '' )
		{

            // set val type
			if($type == 'int')
			{

              $val =  $this->setInt($val);
			}
			else if($type == 'bool')
			{
				$val =  $this->setBoll($val);
			}
			else if($type == 'null')
			{
              $val =  $this->setNull($val);
			}

            if($this->checkXss)
            {
              $val = $this->checkXss($val);
            }

            if($this->checkSql)
            {
              $val = $this->checkSql($val);
            }


            if($this->strip_tags)
            {
              $val = $this->strip_tags($val);
            }


            if($this->strip_js)
            {
              $val = $this->strip_javascript($val);
            }


            return(trim($val));


		}
		else
		{
			return(false);
		}

	}


	private function setInt ($val)
	{

       if(!is_numeric($val))
       {
          $val = intval($val);
       }
       else
       {
			return($val);
	   }
	}

	private function setBoll ($val)
	{
       if(!is_bool($val))
       {

          $val = 0;
       }
       else
       {
			return($val);
	   }

	}

	private function setNull($val)
	{
       if(!is_null($val))
       {

          $val = "";
       }
       else
       {
			return($val);
	   }

	}


	private function strip_javascript($filter)
	{

	    // realign javascript href to onclick
	    $filter = preg_replace("/href=(['\"]).*?javascript:(.*)?\\1/i", "onclick=' $2 '", $filter);

	    //remove javascript from tags
	    while( preg_match("/<(.*)?javascript.*?\(.*?((?>[^()]+)|(?R)).*?\)?\)(.*)?>/i", $filter))
	       $filter = preg_replace("/<(.*)?javascript.*?\(.*?((?>[^()]+)|(?R)).*?\)?\)(.*)?>/i", "<$1$3$4$5>", $filter);

	    // dump expressions from contibuted content
	    if(0) $filter = preg_replace("/:expression\(.*?((?>[^
			(.*?)]+)|(?R)).*?\)\)/i", "", $filter);

		    while( preg_match("/<(.*)?:expr.*?\(.*?((?>[^()]+)|(?
			R)).*?\)?\)(.*)?>/i", $filter))
	        	$filter = preg_replace("/<(.*)?:expr.*?\(.*?((?>[^()]
				+)|(?R)).*?\)?\)(.*)?>/i", "<$1$3$4$5>", $filter);

			    // remove all on* events
	    		while( preg_match("/<(.*)?\s?on.+?=?\s?.+?(['\"]).*?\\2
					\s?(.*)?>/i", $filter) )
			       $filter = preg_replace("/<(.*)?\s?on.+?=?\s?.+?
				(['\"]).*?\\2\s?(.*)?>/i", "<$1$3>", $filter);

	    return $filter;
	}

	private function strip_tags($val)
	{

		if(function_exists("strip_tags"))
		{

   			return(strip_tags($val));
		}
		else
		{

			return(false);

		}
	}


	private function checkXss ($val)
	{
		$search = array('@<script[^>]*?>.*?</script>@si',
               '@<[\/\!]*?[^<>]*?>@si',
               '@<style[^>]*?>.*?</style>@siU',
               '@<![\s\S]*?--[ \t\n\r]*>@'
		);

		$val = preg_replace($search, '', $val);

		return($val);

	}

	private function checkSql ($val)
	{
		if(get_magic_quotes_gpc())
		{
			$val = addslashes($val);
		}

		return mysql_real_escape_string($val);
	}




}

?>